/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler;

import com.hello2morrow.sonargraph.ide.eclipse.model.E4ModelUtil;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewLicenseTicketAutomaticallyHandler
extends CommandHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenewLicenseTicketAutomaticallyHandler.class);
    public static final String ITEM_ID = "com.hello2morrow.sonargraph.ide.eclipse.handledmenuitem.renewlicenseticketautomatically";
    @Inject
    @Preference(value="RenewLicenseTicketAutomatically")
    private static boolean s_renewAutomatically;
    @Inject
    @Preference
    private IEclipsePreferences m_preferences;

    public static boolean isActive() {
        return s_renewAutomatically;
    }

    @PostConstruct
    public void postConstruct(MApplication application, EModelService modelService) {
        MItem renewItem = E4ModelUtil.findSonargraphItem(application, modelService, ITEM_ID);
        if (renewItem != null) {
            renewItem.setSelected(s_renewAutomatically);
        }
    }

    @Execute
    public void execute(MHandledItem handledItem) {
        boolean selected = handledItem.isSelected();
        this.save(selected);
    }

    private void save(boolean selected) {
        this.m_preferences.putBoolean("RenewLicenseTicketAutomatically", selected);
        try {
            this.m_preferences.flush();
        }
        catch (BackingStoreException bse) {
            LOGGER.warn("Could not save RenewLicenseTicketAutomatically", (Throwable)bse);
        }
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin) {
        return plugin != null && plugin.isInitialized() && plugin.getSoftwareSystemProvider().hasSoftwareSystem();
    }
}

