/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.command.system.SendFeedbackCommand;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.EclipsePluginProxySettingsProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.FeedbackDialog;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.StandardFeedbackInteraction;
import de.schlichtherle.truezip.file.TFile;
import jakarta.inject.Named;
import java.io.File;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.widgets.Shell;

public final class EclipsePluginSendFeedbackHandler
extends CommandHandler {
    @Execute
    public void execute(ISonargraphEclipsePlugin plugin, @Named(value="activeShell") Shell shell) {
        TFile logFile = SendFeedbackCommand.getLogFile();
        FeedbackDialog dialog = new FeedbackDialog(shell, logFile, "com.hello2morrow.sonargraph.ide.eclipse", (IProxySettingsProvider)new EclipsePluginProxySettingsProvider(SonargraphLicenseHandler.getHosts()));
        if (dialog.open() == 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            TFile workspaceDirectory = new TFile(workspace.getRoot().getLocation().toFile());
            TFile workspaceMetaDataDirectory = new TFile((File)workspaceDirectory, ".metadata");
            EclipseFeedbackInteraction interaction = new EclipseFeedbackInteraction(dialog, logFile, workspaceMetaDataDirectory, plugin.getEclipsePlatformVersion());
            SendFeedbackCommand.sendUserFeedback((ProxySettings)new EclipsePluginProxySettingsProvider(SonargraphLicenseHandler.getHosts()).getProxySettings(false), (SendFeedbackCommand.IInteraction)interaction);
        }
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin) {
        if (plugin == null) {
            return false;
        }
        return plugin.isInitialized();
    }

    private static class EclipseFeedbackInteraction
    extends StandardFeedbackInteraction {
        private final String m_eclipseVersion;

        public EclipseFeedbackInteraction(FeedbackDialog dialog, TFile logFile, TFile workspaceMetaDataDirectory, String eclipseVersion) {
            super(dialog, logFile, workspaceMetaDataDirectory);
            this.m_eclipseVersion = eclipseVersion;
        }

        public boolean collect(SendFeedbackCommand.FeedbackData data) {
            boolean collected = super.collect(data);
            if (collected) {
                data.addToContextInfo("Running on Eclipse platform version " + this.m_eclipseVersion);
            }
            return collected;
        }

        public void handleResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'handleResult' must not be null";
            if (result.isSuccess()) {
                UserInterfaceAdapter.getInstance().information("Feedback successfully sent.", "Thank you for providing feedback! " + StringUtility.LINE_SEPARATOR + "It is forwarded to support@hello2morrow.com." + StringUtility.LINE_SEPARATOR);
            } else {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }
}

