/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.CreateHtmlReportJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.view.ExportHtmlReportDialog;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.widgets.Shell;

public final class CreateHtmlReportHandler
extends CommandHandler {
    @Execute
    public Object execute(ISonargraphEclipsePlugin plugin, @Named(value="activeShell") Shell shell) {
        assert (plugin != null) : "Parameter 'plugin' of method 'execute' must not be null";
        ExportHtmlReportDialog dialog = new ExportHtmlReportDialog(shell);
        if (dialog.open() != 0) {
            return null;
        }
        ISoftwareSystemProvider systemProvider = plugin.getSoftwareSystemProvider();
        CreateHtmlReportJob reportJob = new CreateHtmlReportJob(systemProvider, dialog.getOutputDirectory(), IReport.Format.HTML);
        reportJob.schedule();
        return null;
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin, @Optional SonargraphLicenseHandler licenseHandler) {
        return plugin.getSoftwareSystemProvider().hasSoftwareSystem() && plugin.getSoftwareSystemProvider().getSoftwareSystem().getState() == SoftwareSystemState.MODEL_LOADED;
    }
}

