/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.view.refactoring;

import com.hello2morrow.sonargraph.ide.eclipse.view.SonargraphEclipseDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class RefactoringConfirmationDialog
extends StandardDialog {
    private static final IDialogId ID = SonargraphEclipseDialogId.REFACTORING_CONFIRMATION;
    private final String m_executionPlan;

    public RefactoringConfirmationDialog(Shell shell, String executionPlan) {
        super(shell, ID.getPresentationName());
        assert (executionPlan != null && executionPlan.length() > 0) : "Parameter 'executionPlan' of method 'RefactoringConfirmationDialog' must not be empty";
        this.m_executionPlan = executionPlan;
    }

    protected Point getPreferredSize() {
        return new Point(600, 500);
    }

    protected IDialogId getDialogId() {
        return ID;
    }

    protected void fillDialogArea(Composite composite) {
        super.fillDialogArea(composite);
        Label info = new Label(composite, 64);
        info.setLayoutData((Object)new GridData(1, 128, true, false));
        StringBuilder infoMsg = new StringBuilder();
        infoMsg.append("The Sonargraph refactoring needs to be split into several steps.\n\n");
        infoMsg.append("NOTE: We strongly recommend to commit all pending modifications locally before executing the refactorings, ");
        infoMsg.append("so you have a chance to rollback the changes if anything goes wrong.\n");
        infoMsg.append("NOTE: If this Sonargraph refactoring is not the first one in the list, you risk making subsequent refactorings inapplicable!\n");
        infoMsg.append("NOTE: You can adjust the target location(s) and name(s), but you risk making subsequent Sonargraph refactorings inapplicable!");
        info.setText(infoMsg.toString());
        Text steps = new Text(composite, 2818);
        steps.setLayoutData((Object)new GridData(4, 4, true, true));
        steps.setText(this.m_executionPlan);
        steps.setEditable(false);
        steps.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        Label question = new Label(composite, 0);
        question.setLayoutData((Object)new GridData(1, 128, true, false));
        question.setText("Do you want to continue?");
    }

    protected void applyData() {
        super.applyData();
        this.getButton(0).setEnabled(true);
        this.getButton(0).setFocus();
    }
}

