/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.view.refactoring;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ide.eclipse.view.SonargraphEclipseDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class RefactoringCommentDialog
extends StandardDialog {
    private static final IDialogId ID = SonargraphEclipseDialogId.REFACTORING_COMMENT;
    private String m_comment = "";

    public RefactoringCommentDialog(Shell shell) {
        super(shell, ID.getPresentationName());
    }

    protected IDialogId getDialogId() {
        return ID;
    }

    protected Point getPreferredSize() {
        return new Point(600, 300);
    }

    protected void fillDialogArea(Composite composite) {
        super.fillDialogArea(composite);
        Label info = new Label(composite, 64);
        info.setLayoutData((Object)new GridData(1, 128, true, false));
        info.setText("The refactoring was not executed as planned. You can provide a comment that will be added to the refactoring log:");
        ValidatingTextWidget comment = new ValidatingTextWidget(composite, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null || newInput.isEmpty()) {
                    result.addError("Must not be empty");
                } else {
                    RefactoringCommentDialog.this.getButton(0).setEnabled(true);
                }
                return result;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (inputModified) {
                    RefactoringCommentDialog.this.m_comment = input;
                }
            }
        }, this.m_comment, true, true, 0);
        comment.setLayoutData((Object)new GridData(4, 4, true, true));
        comment.setBackground(UiResourceManager.getInstance().getBackgroundColor());
    }

    protected void applyData() {
        super.applyData();
        this.getButton(1).setFocus();
    }

    public String getComment() {
        return this.m_comment;
    }
}

