/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.view;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.system.IDynamicSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.IInfoWithMappingStatus;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleMappingInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathMappingInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseClassRootProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.view.SonargraphEclipseDialogId;
import com.hello2morrow.sonargraph.ide.eclipse.view.SystemMappingInfoContentProvider;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeContributionButton;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class OpenSonargraphSystemDialog
extends StandardDialog {
    private static final int ROOT_COLUMN_WIDTH = 200;
    private static final int MODULE_COLUMN_WIDTH = 250;
    private static final String NO_MATCH = "<<no match>>";
    private static final String NO_MATCH_WARNINGS = "<<no match, warnings>>";
    private final List<ModuleInfo> m_workspaceProjects;
    private final IPathValidator m_pathValidator;
    private final IDynamicSystemProvider m_dynamicSystemProvider;
    private SystemMappingInfo m_systemMappingInfo;
    private TFile m_systemDirectory;
    private TreeViewer m_treeViewer;
    private boolean m_isExpanded = true;
    private final ISoftwareSystemProvider m_provider;
    private ValidatingPathWidget m_validatingPathWidget;

    public OpenSonargraphSystemDialog(Shell shell, List<ModuleInfo> workspaceProjects, IPathValidator pathValidator, ISoftwareSystemProvider provider, TFile currentSystemDirectory) {
        super(shell, "Open Sonargraph Software System");
        assert (workspaceProjects != null) : "Parameter 'workspaceProjects' of method 'OpenSonargraphSystemDialog' must not be null";
        assert (pathValidator != null) : "Parameter 'pathValidator' of method 'OpenSonargraphSystemDialog' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'OpenSonargraphSystemDialog' must not be null";
        this.m_workspaceProjects = workspaceProjects;
        this.m_pathValidator = pathValidator;
        this.m_provider = provider;
        this.m_dynamicSystemProvider = (IDynamicSystemProvider)provider.getInstallation().getExtension(IDynamicSystemProvider.class);
        this.m_systemMappingInfo = new SystemMappingInfo(this.m_workspaceProjects);
        this.m_systemDirectory = currentSystemDirectory;
        if (this.m_systemDirectory != null) {
            this.loadSonargraphSystem(false);
        }
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected Point getPreferredSize() {
        return new Point(1000, 400);
    }

    protected IDialogId getDialogId() {
        return SonargraphEclipseDialogId.OPEN_SYSTEM_DIALOG;
    }

    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogArea' must not be null";
        Label directoryLabel = new Label(composite, 0);
        directoryLabel.setText("Sonargraph System Directory:");
        this.m_validatingPathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                if (!inputModified) {
                    return;
                }
                OpenSonargraphSystemDialog.this.m_systemDirectory = input;
                if (input != null) {
                    OpenSonargraphSystemDialog.this.loadSonargraphSystem(true);
                } else {
                    OpenSonargraphSystemDialog.this.m_systemMappingInfo = new SystemMappingInfo(OpenSonargraphSystemDialog.this.m_workspaceProjects);
                }
                OpenSonargraphSystemDialog.this.applyData();
            }
        }, this.m_pathValidator, 2, this.m_systemDirectory, false);
        GridData layoutData = new GridData(768);
        this.m_validatingPathWidget.setLayoutData((Object)layoutData);
        Label filterLabel = new Label(composite, 0);
        filterLabel.setText("Filter:");
        Composite treeControllersComposite = new Composite(composite, 0);
        treeControllersComposite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        treeControllersComposite.setLayoutData((Object)new GridData(768));
        final Combo filter = new Combo(treeControllersComposite, 0x800808);
        filter.setLayoutData((Object)new GridData(1, 128, false, false));
        filter.setItems(new String[]{SystemMappingInfoContentProvider.Filter.SHOW_ALL.getLabel(), SystemMappingInfoContentProvider.Filter.SHOW_MATCHED.getLabel(), SystemMappingInfoContentProvider.Filter.SHOW_UNMATCHED.getLabel()});
        filter.select(0);
        filter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenSonargraphSystemDialog.this.m_treeViewer.setFilters(new ViewerFilter[]{new SystemMappingInfoContentProvider.MappingFilter(SystemMappingInfoContentProvider.Filter.forLabel(filter.getText()))});
            }
        });
        Composite collapseExpandComposite = new Composite(treeControllersComposite, 0);
        collapseExpandComposite.setLayout((Layout)new FillLayout());
        collapseExpandComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Image expandAll = UiResourceManager.getInstance().getImage("ExpandAll");
        CompositeContributionButton expandButton = new CompositeContributionButton(collapseExpandComposite, expandAll);
        expandButton.setToolTipText("Expand All");
        expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenSonargraphSystemDialog.this.m_treeViewer.expandAll();
                OpenSonargraphSystemDialog.this.m_isExpanded = true;
            }
        });
        Image collapseAll = UiResourceManager.getInstance().getImage("CollapseAll");
        CompositeContributionButton collapseButton = new CompositeContributionButton(collapseExpandComposite, collapseAll);
        collapseButton.setToolTipText("Collapse All");
        collapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenSonargraphSystemDialog.this.m_treeViewer.collapseAll();
                OpenSonargraphSystemDialog.this.m_isExpanded = false;
            }
        });
        this.m_treeViewer = new TreeViewer(composite, 66306);
        this.m_treeViewer.getTree().setHeaderVisible(true);
        this.m_treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TreeViewerColumn column1 = new TreeViewerColumn(this.m_treeViewer, 0);
        column1.getColumn().setWidth(250);
        column1.getColumn().setText("Eclipse Java Projects");
        column1.setLabelProvider((CellLabelProvider)new MappingColumnLabelProvider(this){

            public String getText(Object obj) {
                if (obj instanceof ModuleMappingInfo) {
                    ModuleMappingInfo info = (ModuleMappingInfo)obj;
                    return info.getExternalProject().map(p -> p.getName()).orElse(OpenSonargraphSystemDialog.NO_MATCH);
                }
                return "";
            }

            public String getToolTipText(Object obj) {
                ModuleMappingInfo info;
                if (obj instanceof ModuleMappingInfo && !(info = (ModuleMappingInfo)obj).getWarningMessages().isEmpty()) {
                    return info.getWarningMessages().stream().collect(Collectors.joining("\n"));
                }
                return super.getToolTipText(obj);
            }

            public Image getImage(Object obj) {
                ModuleMappingInfo info;
                if (obj instanceof ModuleMappingInfo && (info = (ModuleMappingInfo)obj).getExternalProject().isPresent()) {
                    if (info.isMappingDefined()) {
                        CompositeImageDescriptor compositeImageDescriptor = new CompositeImageDescriptor("EclipseJavaProject");
                        compositeImageDescriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_LEFT, "SonargraphDecorator");
                        return UiResourceManager.getInstance().getImage(compositeImageDescriptor);
                    }
                    if (!info.getWarningMessages().isEmpty()) {
                        CompositeImageDescriptor compositeImageDescriptor = new CompositeImageDescriptor("EclipseJavaProject");
                        compositeImageDescriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_LEFT, "WarningMarker");
                        return UiResourceManager.getInstance().getImage(compositeImageDescriptor);
                    }
                    return UiResourceManager.getInstance().getImage("EclipseJavaProject");
                }
                return null;
            }
        });
        TreeViewerColumn column2 = new TreeViewerColumn(this.m_treeViewer, 0);
        column2.getColumn().setWidth(200);
        column2.getColumn().setText("Source and Class Directories");
        column2.setLabelProvider((CellLabelProvider)new MappingColumnLabelProvider(this){

            public String getText(Object obj) {
                RootPathMappingInfo info;
                if (obj instanceof RootPathMappingInfo && (info = (RootPathMappingInfo)obj).getStatus().contains(RootPathMappingInfo.MappingStatus.EXTERNAL)) {
                    Optional<IFolder> optFolder = EclipseWorkspaceUtils.getLocationForDirectory(new TFile(info.getRoot().getPath()));
                    return optFolder.map(folder -> folder.getProjectRelativePath().toString()).orElse("");
                }
                return "";
            }

            public Image getImage(Object obj) {
                if (!(obj instanceof RootPathMappingInfo)) {
                    return null;
                }
                RootPathMappingInfo info = (RootPathMappingInfo)obj;
                if (info.getStatus().contains(RootPathMappingInfo.MappingStatus.EXTERNAL)) {
                    if (info.isMappingDefined()) {
                        CompositeImageDescriptor compositeImageDescriptor = null;
                        if (info.getRoot().getType() == RootPathType.STANDARD) {
                            compositeImageDescriptor = new CompositeImageDescriptor("EclipseFolder");
                        } else if (info.getRoot().getType() == RootPathType.NON_STANDARD) {
                            compositeImageDescriptor = new CompositeImageDescriptor("EclipseSourceFolder");
                        } else {
                            return null;
                        }
                        compositeImageDescriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_LEFT, "SonargraphDecorator");
                        return UiResourceManager.getInstance().getImage(compositeImageDescriptor);
                    }
                    if (info.getRoot().getType() == RootPathType.STANDARD) {
                        return UiResourceManager.getInstance().getImage("EclipseFolder");
                    }
                    if (info.getRoot().getType() == RootPathType.NON_STANDARD) {
                        return UiResourceManager.getInstance().getImage("EclipseSourceFolder");
                    }
                }
                return null;
            }
        });
        TreeViewerColumn column3 = new TreeViewerColumn(this.m_treeViewer, 0);
        column3.getColumn().setWidth(250);
        column3.getColumn().setText("Sonargraph Module");
        column3.setLabelProvider((CellLabelProvider)new MappingColumnLabelProvider(this){

            public String getText(Object obj) {
                if (obj instanceof ModuleMappingInfo) {
                    ModuleMappingInfo info = (ModuleMappingInfo)obj;
                    if (!info.getWarningMessages().isEmpty()) {
                        return OpenSonargraphSystemDialog.NO_MATCH_WARNINGS;
                    }
                    return info.getSonargraphModule().map(m -> m.getName()).orElse(OpenSonargraphSystemDialog.NO_MATCH);
                }
                return "";
            }

            public Image getImage(Object obj) {
                if (obj instanceof ModuleMappingInfo) {
                    ModuleMappingInfo info = (ModuleMappingInfo)obj;
                    return info.getSonargraphModule().map(m -> UiResourceManager.getInstance().getImage("Module")).orElse(null);
                }
                return null;
            }
        });
        TreeViewerColumn column4 = new TreeViewerColumn(this.m_treeViewer, 0);
        column4.getColumn().setWidth(200);
        column4.getColumn().setText("Sonargraph Source Directories");
        column4.setLabelProvider((CellLabelProvider)new MappingColumnLabelProvider(this){

            public String getText(Object obj) {
                RootPathMappingInfo info;
                if (obj instanceof RootPathMappingInfo && (info = (RootPathMappingInfo)obj).getStatus().contains(RootPathMappingInfo.MappingStatus.INTERNAL)) {
                    String relativePath = FileUtility.calculateRelativePath((TFile)new TFile(info.getRoot().getPath()), (TFile)m_systemDirectory);
                    return relativePath;
                }
                return "";
            }

            public Image getImage(Object obj) {
                RootPathMappingInfo info;
                if (obj instanceof RootPathMappingInfo && (info = (RootPathMappingInfo)obj).getStatus().contains(RootPathMappingInfo.MappingStatus.INTERNAL)) {
                    if (info.getRoot().getType() == RootPathType.STANDARD) {
                        return UiResourceManager.getInstance().getImage("RootDirectoryPath");
                    }
                    if (info.getRoot().getType() == RootPathType.NON_STANDARD) {
                        return UiResourceManager.getInstance().getImage("JavaSourceRootDirectoryPath");
                    }
                }
                return null;
            }
        });
        this.m_treeViewer.setContentProvider((IContentProvider)new SystemMappingInfoContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_treeViewer);
    }

    private void loadSonargraphSystem(boolean isApplyData) {
        OperationResultWithOutcome failure = null;
        OperationResultWithOutcome loadResult = this.m_dynamicSystemProvider.loadSystemInfo((IWorkerContext)DefaultWorkerContext.INSTANCE, this.m_systemDirectory);
        if (loadResult.isFailure()) {
            this.m_systemMappingInfo = new SystemMappingInfo(this.m_workspaceProjects);
            failure = loadResult;
        } else {
            OperationResultWithOutcome mappingResult = this.m_dynamicSystemProvider.mapSystemInfo(this.m_provider, (DynamicSystemInfo)loadResult.getOutcome(), this.m_workspaceProjects, (IDynamicSystemProvider.ISourceToClassRootProvider)new EclipseClassRootProvider(), IDynamicSystemProvider.MappingType.INCLUDE_UNMATCHED);
            if (mappingResult.isSuccess()) {
                this.m_systemMappingInfo = (SystemMappingInfo)mappingResult.getOutcome();
            } else {
                this.m_systemMappingInfo = new SystemMappingInfo(this.m_workspaceProjects);
                failure = mappingResult;
            }
        }
        if (isApplyData) {
            this.applyData();
        }
        if (failure != null) {
            UserInterfaceAdapter.getInstance().process((OperationResult)failure);
        }
    }

    public boolean hasValidData() {
        if (this.m_systemMappingInfo.getModuleMappings().isEmpty()) {
            return false;
        }
        if (this.m_systemDirectory == null) {
            return false;
        }
        for (ModuleMappingInfo module : this.m_systemMappingInfo.getModuleMappings()) {
            List activeSrcRoots = module.getRootPaths(r -> r.getRoot().getType() == RootPathType.NON_STANDARD && r.getStatus().contains(RootPathMappingInfo.MappingStatus.ACTIVE));
            List activeClsRoots = module.getRootPaths(r -> r.getRoot().getType() == RootPathType.STANDARD && r.getStatus().contains(RootPathMappingInfo.MappingStatus.ACTIVE));
            if (activeSrcRoots.isEmpty() || activeClsRoots.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void validate() {
        boolean isValid = this.hasValidData();
        this.getButton(0).setEnabled(isValid);
    }

    protected void applyData() {
        this.m_treeViewer.getControl().setRedraw(false);
        this.m_treeViewer.setInput((Object)this.m_systemMappingInfo);
        if (this.m_isExpanded) {
            this.m_treeViewer.expandToLevel(2);
        }
        this.m_treeViewer.getControl().setRedraw(true);
        this.validate();
    }

    public SystemMappingInfo getSystemMappingInfo() {
        return this.m_systemMappingInfo;
    }

    public TFile getSystemDirectory() {
        return this.m_systemDirectory;
    }

    private class MappingColumnLabelProvider
    extends ColumnLabelProvider {
        private MappingColumnLabelProvider() {
        }

        public Color getForeground(Object element) {
            if (element instanceof IInfoWithMappingStatus && !((IInfoWithMappingStatus)element).isMappingDefined()) {
                return UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_GREY);
            }
            return super.getForeground(element);
        }
    }
}

