/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.refactoring;

import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.IEclipseRefactoringInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringChange;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringScope;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.StandardEclipseRefactoringInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RenamePackageInteraction
extends StandardEclipseRefactoringInteraction {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenamePackageInteraction.class);
    private final IPackageFragment m_target;
    private final IEclipseRefactoringInteraction.Recursive m_includeSubPackages;
    private final boolean m_isEscaped;

    public RenamePackageInteraction(IPackageFragment source, IPackageFragment target, IEclipseRefactoringInteraction.Recursive includeSubPackages, boolean isEscaped) {
        super(new ArrayList<IPackageFragment>(Arrays.asList(source)));
        assert (target != null) : "Parameter 'target' of method 'MoveSinglePackageInteraction' must not be null";
        assert (source.getParent().getElementName().equals(target.getParent().getElementName())) : "Same parent for source '" + String.valueOf(source) + "' and target '" + String.valueOf(target) + "' expected.";
        assert (!source.getElementName().equals(target.getElementName())) : "Source and target names must be different, both are '" + source.getElementName() + "'";
        assert (includeSubPackages != null) : "Parameter 'includeSubPackages' of method 'RenamePackageInteraction' must not be null";
        this.m_target = target;
        this.m_includeSubPackages = includeSubPackages;
        this.m_isEscaped = isEscaped;
    }

    public RenamePackageInteraction(IPackageFragment source, IPackageFragment target, IEclipseRefactoringInteraction.Recursive includeSubPackages) {
        this(source, target, includeSubPackages, false);
    }

    @Override
    public boolean isExecutable() {
        return this.getElements().get(0).exists() && !this.m_target.exists();
    }

    @Override
    public boolean isExecutedAsPlanned(List<RefactoringChange> changes) {
        assert (changes != null) : "Parameter 'changes' of method 'isExecutedAsPlanned' must not be null";
        boolean executedAsPlanned = true;
        String targetFullPath = this.m_target.getResource().getFullPath().toString();
        for (IJavaElement element : this.getElements()) {
            boolean anyChildrenRenamed;
            IPath fullPath = element.getResource().getFullPath();
            boolean isRenamed = changes.stream().anyMatch(change -> change.getFrom().equals((Object)element.getResource()) && change.getTo().equals((Object)this.m_target.getResource()));
            if (isRenamed || (anyChildrenRenamed = changes.stream().anyMatch(change -> change.getFrom().getFullPath().toString().startsWith(fullPath.toString()) && change.getTo().getFullPath().toString().startsWith(targetFullPath)))) continue;
            LOGGER.info("Deviation detected, because element '" + String.valueOf(element.getResource().getFullPath()) + "' is not found as renamed element in changes");
            executedAsPlanned = false;
        }
        return executedAsPlanned;
    }

    @Override
    public boolean execute() throws CoreException {
        assert (this.isExecutable()) : "Not executable";
        IDialogSettings refactoringSettings = this.getRefactoringSettings();
        Boolean originalRenameSubPackages = this.getBooleanSetting(refactoringSettings, "renameSubpackages");
        Boolean originalUpdateReferences = this.getBooleanSetting(refactoringSettings, "updateQualifiedNames");
        refactoringSettings.put("renameSubpackages", this.m_includeSubPackages == IEclipseRefactoringInteraction.Recursive.YES);
        refactoringSettings.put("updateQualifiedNames", true);
        try {
            RenameSupport support = RenameSupport.create((IPackageFragment)((IPackageFragment)this.getElements().get(0)), (String)this.m_target.getElementName(), (int)65);
            boolean bl = support.openDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), false);
            return bl;
        }
        finally {
            if (originalRenameSubPackages != null) {
                refactoringSettings.put("renameSubpackages", originalRenameSubPackages.booleanValue());
            }
            if (originalUpdateReferences != null) {
                refactoringSettings.put("updateQualifiedNames", originalUpdateReferences.booleanValue());
            }
        }
    }

    @Override
    public String toString() {
        return "Rename package '" + this.getElements().get(0).getElementName() + "' to '" + this.m_target.getElementName() + "'" + (this.m_isEscaped ? " (because of naming collision)" : "");
    }

    @Override
    public Set<RefactoringScope> getScopes() {
        return EnumSet.of(RefactoringScope.PACKAGE);
    }
}

