/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.refactoring;

import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringChange;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringScope;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.StandardEclipseRefactoringInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.view.refactoring.MoveRenameRefactoringStarter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MovePackagesInteraction
extends StandardEclipseRefactoringInteraction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovePackagesInteraction.class);
    private final IPackageFragmentRoot m_targetRoot;

    public MovePackagesInteraction(List<IPackageFragment> packageFragments, IPackageFragmentRoot targetRoot) {
        super(new ArrayList<IPackageFragment>(packageFragments));
        assert (targetRoot != null) : "Parameter 'targetRoot' of method 'MovePackagesInteraction' must not be null";
        this.m_targetRoot = targetRoot;
    }

    @Override
    public boolean isExecutable() {
        return this.m_targetRoot.exists();
    }

    @Override
    public boolean isExecutedAsPlanned(List<RefactoringChange> changes) {
        assert (changes != null) : "Parameter 'changes' of method 'isExecutedAsPlanned' must not be null";
        boolean executedAsPlanned = true;
        for (IJavaElement element : this.getElements()) {
            boolean isMoved = changes.stream().anyMatch(change -> change.getFrom().equals((Object)element.getResource()) && change.getTo() != null && change.getTo().getFullPath().toString().startsWith(this.m_targetRoot.getResource().getFullPath().toString()));
            if (isMoved) continue;
            LOGGER.info("Deviation detected, because element '" + String.valueOf(element.getResource().getFullPath()) + "' has not been found to be moved to target '" + String.valueOf(this.m_targetRoot.getResource().getFullPath()) + "' in changes");
            executedAsPlanned = false;
        }
        return executedAsPlanned;
    }

    @Override
    public boolean execute() throws CoreException {
        try {
            IReorgDestination reorgDestination = ReorgDestinationFactory.createDestination((Object)this.m_targetRoot);
            IResource[] toBeMovedResources = this.getElements().stream().map(e -> e.getResource()).collect(Collectors.toList()).toArray(new IResource[this.getElements().size()]);
            MoveRenameRefactoringStarter starter = MoveRenameRefactoringStarter.create(this.getElements().toArray(new IJavaElement[this.getElements().size()]), toBeMovedResources, reorgDestination, (IJavaElement)this.m_targetRoot, this.getDialogInfo());
            return starter.run(WorkbenchRegistry.getInstance().getMainApplicationWindowShell());
        }
        catch (Throwable ex) {
            UserInterfaceAdapter.getInstance().error("Refactoring Failed", ex.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public String toString() {
        if (this.getElements().size() == 1) {
            return "Move '" + this.getElements().get(0).getElementName() + "' to '" + this.m_targetRoot.getParent().getElementName() + "/" + this.m_targetRoot.getElementName() + "'";
        }
        return "Move " + this.getElements().size() + " packages to '" + this.m_targetRoot.getParent().getElementName() + "/" + this.m_targetRoot.getElementName() + "'";
    }

    @Override
    public Set<RefactoringScope> getScopes() {
        return EnumSet.of(RefactoringScope.PACKAGE);
    }
}

