/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.refactoring;

import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringChange;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringScope;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.StandardEclipseRefactoringInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.view.refactoring.MoveRenameRefactoringStarter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MoveCompilationUnitsInteraction
extends StandardEclipseRefactoringInteraction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveCompilationUnitsInteraction.class);
    private final IPackageFragment m_target;
    private final List<String> m_plannedNamesWhenExecuting;

    public MoveCompilationUnitsInteraction(List<ICompilationUnit> compilationUnits, IPackageFragment target) {
        super(new ArrayList<ICompilationUnit>(compilationUnits));
        assert (target != null) : "Parameter 'target' of method 'MoveCompilationUnitsInteraction' must not be null";
        this.m_target = target;
        this.m_plannedNamesWhenExecuting = Collections.emptyList();
    }

    public MoveCompilationUnitsInteraction(List<ICompilationUnit> compilationUnits, IPackageFragment target, List<String> namesWhenExecuting) {
        super(new ArrayList<ICompilationUnit>(compilationUnits));
        assert (target != null) : "Parameter 'target' of method 'MoveCompilationUnitsInteraction' must not be null";
        assert (namesWhenExecuting != null && !namesWhenExecuting.isEmpty()) : "Parameter 'namesWhenExecuting' of method 'MoveCompilationUnitsInteraction' must not be empty";
        this.m_target = target;
        this.m_plannedNamesWhenExecuting = namesWhenExecuting;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public boolean isExecutedAsPlanned(List<RefactoringChange> changes) {
        assert (changes != null) : "Parameter 'changes' of method 'isExecutedAsPlanned' must not be null";
        boolean executedAsPlanned = true;
        for (IJavaElement element : this.getElements()) {
            boolean isMoved = false;
            for (RefactoringChange change : changes) {
                if (change.getTo() == null || !change.getFrom().equals((Object)element.getResource()) || !change.getTo().getParent().getFullPath().equals((Object)this.m_target.getResource().getFullPath())) continue;
                isMoved = true;
            }
            if (isMoved) continue;
            LOGGER.info("Deviation detected, because element '" + String.valueOf(element.getResource().getFullPath()) + "' has not been found to be moved to target '" + String.valueOf(this.m_target.getResource().getFullPath()) + "' in changes");
            executedAsPlanned = false;
        }
        return executedAsPlanned;
    }

    @Override
    public boolean execute() throws CoreException {
        try {
            IReorgDestination reorgDestination = ReorgDestinationFactory.createDestination((Object)this.m_target);
            IResource[] toBeMovedResources = this.getElements().stream().map(e -> e.getResource()).collect(Collectors.toList()).toArray(new IResource[this.getElements().size()]);
            MoveRenameRefactoringStarter starter = MoveRenameRefactoringStarter.create(this.getElements().toArray(new IJavaElement[this.getElements().size()]), toBeMovedResources, reorgDestination, (IJavaElement)this.m_target, this.getDialogInfo());
            return starter.run(WorkbenchRegistry.getInstance().getMainApplicationWindowShell());
        }
        catch (Throwable ex) {
            UserInterfaceAdapter.getInstance().error("Refactoring Failed", ex.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public String toString() {
        boolean sameParent;
        IJavaElement root = this.m_target.getParent();
        if (this.getElements().size() == 1) {
            return "Move '" + this.getElements().get(0).getParent().getElementName() + "/" + this.getElements().get(0).getElementName() + "' to '" + root.getElementName() + "/" + this.m_target.getElementName() + "'";
        }
        boolean bl = sameParent = this.getElements().stream().map(c -> c.getParent()).distinct().count() == 1L;
        if (sameParent) {
            IJavaElement sourcePackage = this.getElements().get(0).getParent();
            return "Move " + this.getElements().size() + " compilation units from '" + root.getElementName() + "/" + sourcePackage.getElementName() + "' to '" + root.getElementName() + "/" + this.m_target.getElementName() + "'";
        }
        return "Move " + this.getElements().size() + " compilation units to '" + root.getElementName() + "/" + this.m_target.getElementName() + "'";
    }

    @Override
    public String getExecutionPlan() {
        boolean sameParent;
        if (this.m_plannedNamesWhenExecuting.isEmpty()) {
            return this.toString();
        }
        IJavaElement root = this.m_target.getParent();
        if (this.getElements().size() == 1) {
            String elementToMove = this.getElements().get(0).getParent().getElementName() + "/" + this.m_plannedNamesWhenExecuting.get(0);
            return "Move '" + elementToMove + "' to '" + root.getElementName() + "/" + this.m_target.getElementName() + "'";
        }
        boolean bl = sameParent = this.getElements().stream().map(c -> c.getParent()).distinct().count() == 1L;
        if (sameParent) {
            IJavaElement sourcePackage = this.getElements().get(0).getParent();
            return "Move " + this.getElements().size() + " compilation units from '" + root.getElementName() + "/" + sourcePackage.getElementName() + "' to '" + root.getElementName() + "/" + this.m_target.getElementName() + "'";
        }
        return "Move " + this.getElements().size() + " compilation units to '" + root.getElementName() + "/" + this.m_target.getElementName() + "'";
    }

    @Override
    public Set<RefactoringScope> getScopes() {
        return EnumSet.of(RefactoringScope.COMPILATION_UNIT);
    }
}

