/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.refactoring;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.refactoring.RenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.ElementMapper;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.ChangeType;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.IEclipseRefactoringInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringChange;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringLog;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.DeleteElementsInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.MoveCompilationUnitsInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.MovePackagesInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.RefactoringChangeListener;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.RenameCompilationUnitInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.RenamePackageInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.view.refactoring.RefactoringCommentDialog;
import com.hello2morrow.sonargraph.ide.eclipse.view.refactoring.RefactoringConfirmationDialog;
import com.hello2morrow.sonargraph.ide.eclipse.view.refactoring.RefactoringLogDialog;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EclipseRefactoringController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipseRefactoringController.class);
    private static final String DEFAULT_PACKAGE = "";
    private static final Integer TOP_LEVEL = 1;
    private final ISonargraphEclipsePlugin m_plugin;

    public EclipseRefactoringController(ISonargraphEclipsePlugin plugin) {
        assert (plugin != null) : "Parameter 'plugin' of method 'EclipseRefactoringController' must not be null";
        assert (plugin.getSoftwareSystemProvider() != null) : "SystemProvider must be available";
        assert (plugin.getSoftwareSystemProvider().hasSoftwareSystem()) : "SoftwareSystem must be available";
        this.m_plugin = plugin;
    }

    private void execute(RefactoringAction action) {
        assert (action != null) : "Parameter 'action' of method 'execute' must not be null";
        boolean autoBuild = this.isAutoBuildActive();
        try {
            this.m_plugin.refactoringStarted();
            if (autoBuild) {
                try {
                    this.setWorkspaceAutoBuild(false);
                }
                catch (CoreException ex) {
                    UserInterfaceAdapter.getInstance().error("Failed to Configure Workspace Auto-Build", "Failed to disable auto-build: " + ex.getLocalizedMessage());
                    this.m_plugin.refactoringFinished();
                    if (autoBuild) {
                        try {
                            LOGGER.debug("Activating auto-build");
                            this.setWorkspaceAutoBuild(true);
                        }
                        catch (CoreException ex2) {
                            UserInterfaceAdapter.getInstance().error("Failed to Configure Workspace Auto-Build", "Failed to enable auto-build: " + ex2.getLocalizedMessage());
                        }
                    }
                    return;
                }
            }
            action.doIt();
        }
        finally {
            this.m_plugin.refactoringFinished();
            if (autoBuild) {
                try {
                    LOGGER.debug("Activating auto-build");
                    this.setWorkspaceAutoBuild(true);
                }
                catch (CoreException ex) {
                    UserInterfaceAdapter.getInstance().error("Failed to Configure Workspace Auto-Build", "Failed to enable auto-build: " + ex.getLocalizedMessage());
                }
            }
        }
    }

    public void rename(NamedElement namedElement, RenameRefactoringDefinition refactoring) {
        assert (namedElement != null) : "Parameter 'element' of method 'rename' must not be null";
        assert (refactoring != null) : "Parameter 'refactoring' of method 'rename' must not be null";
        assert (refactoring.getNewName() != null && refactoring.getNewName().length() > 0) : "'refactoring.getNewName()' of method 'rename' must not be empty";
        RefactoringAction action = () -> {
            LOGGER.debug("rename {} to {}", (Object)namedElement, (Object)refactoring.getNewName());
            IJavaElement eclipseElement = ElementMapper.getEclipseElement(namedElement);
            ArrayList<IEclipseRefactoringInteraction> interactions = new ArrayList<IEclipseRefactoringInteraction>();
            if (eclipseElement instanceof ICompilationUnit) {
                ICompilationUnit compilationUnit = (ICompilationUnit)eclipseElement;
                interactions.add(new RenameCompilationUnitInteraction(compilationUnit, refactoring.getNewName() + "." + compilationUnit.getResource().getFileExtension()));
            } else if (eclipseElement instanceof IPackageFragment) {
                String newNameWithParent = namedElement.getParent().getName() + "." + refactoring.getNewName();
                String rootDirectoryFqName = ((RootDirectoryPath)namedElement.getParent(RootDirectoryPath.class, new Class[0])).getFullyQualifiedName();
                IPackageFragment packageFragment = (IPackageFragment)eclipseElement;
                IPackageFragment targetPackage = EclipseWorkspaceUtils.getPackage(rootDirectoryFqName, newNameWithParent);
                interactions.addAll(this.determinePackageRenameActions(TOP_LEVEL, packageFragment, targetPackage, false));
            } else {
                LOGGER.warn("Rename only for ICompilationUnit or IPackageFragment, but not for {}", (Object)eclipseElement);
                return;
            }
            this.executeActions((RefactoringDefinition)refactoring, interactions);
        };
        this.execute(action);
    }

    public void move(List<NamedElement> namedElements, MoveRefactoringDefinition refactoring) {
        assert (namedElements != null && namedElements.size() > 0) : "Parameter 'namedElements' of method 'move' must not be empty";
        assert (refactoring != null) : "Parameter 'refactoring' of method 'move' must not be null";
        RefactoringAction action = () -> {
            String targetRootFqName = refactoring.getTargetRootDirectoryFqName();
            String targetPackageName = refactoring.getMoveToParentName();
            IPackageFragmentRoot targetRoot = EclipseWorkspaceUtils.getRootDirectory(targetRootFqName);
            if (targetRoot == null) {
                UserInterfaceAdapter.getInstance().error("Failed to determine Root Directory", "Error detecting the Eclipse target source directory of the move refactoring.");
                return;
            }
            IPackageFragment targetPackage = EclipseWorkspaceUtils.getPackage(targetRootFqName, targetPackageName);
            if (targetPackage == null) {
                UserInterfaceAdapter.getInstance().error("Failed to determine Package", "Error detecting the Eclipse target package '" + targetPackageName + "' of the move refactoring.");
                return;
            }
            List<IJavaElement> javaElements = ElementMapper.getEclipseElements(namedElements);
            if (javaElements.isEmpty()) {
                UserInterfaceAdapter.getInstance().error("Failed to determine Elements", "No Eclipse elements could be determined that match the Sonargraph elements of the move refactoring.");
                return;
            }
            ArrayList<IEclipseRefactoringInteraction> actions = new ArrayList<IEclipseRefactoringInteraction>();
            ArrayList<IJavaElement> reduced = new ArrayList<IJavaElement>(javaElements);
            Map<IPackageFragment, List<ICompilationUnit>> packagesToCompilationUnits = this.groupCompilationUnitsByPackageFragment(javaElements);
            if (!packagesToCompilationUnits.isEmpty()) {
                List compilationUnits = packagesToCompilationUnits.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
                reduced.removeAll(compilationUnits);
                actions.addAll(this.createMoveInteractions(packagesToCompilationUnits, targetPackage));
            }
            if (!reduced.isEmpty()) {
                List<IPackageFragment> packagesToRename = this.getPackagesForRename(reduced, targetRoot);
                for (IPackageFragment next : packagesToRename) {
                    IPackageFragment newPackage = EclipseWorkspaceUtils.getPackage(targetRootFqName, targetPackage.getElementName() + "." + EclipseWorkspaceUtils.getLastPackageNamePart(next));
                    actions.addAll(this.determinePackageRenameActions(TOP_LEVEL, next, newPackage, false));
                }
                reduced.removeAll(packagesToRename);
                try {
                    Map<IPackageFragmentRoot, List<IPackageFragment>> packagesForSimpleMove = this.getPackagesForChangeOfRoot(reduced, targetRoot, targetPackageName, IEclipseRefactoringInteraction.Recursive.YES);
                    for (Map.Entry entry : packagesForSimpleMove.entrySet()) {
                        actions.addAll(this.determinePackageMoveActions((List)entry.getValue(), targetRoot));
                    }
                    List list2 = packagesForSimpleMove.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
                    reduced.removeAll(list2);
                    for (IJavaElement next : reduced) {
                        assert (next != null && next instanceof IPackageFragment) : "Unexpected class in method 'move': " + String.valueOf(next);
                        IPackageFragment nextPackage = (IPackageFragment)next;
                        actions.addAll(this.determinePackageMoveAndRenameActions(nextPackage, targetRoot, targetPackage, EclipseWorkspaceUtils.getLastPackageNamePart(nextPackage)));
                    }
                }
                catch (JavaModelException ex) {
                    LOGGER.error("Failed to Pre-Process Refactoring '" + String.valueOf(refactoring) + "'", (Throwable)ex);
                    UserInterfaceAdapter.getInstance().error("Failed to Pre-Process Refactoring", "Failed to determine the necessary actions for the move refactoring:\n\n" + ex.getLocalizedMessage());
                }
            }
            this.executeActions((RefactoringDefinition)refactoring, actions);
        };
        this.execute(action);
    }

    public void moveAndRename(NamedElement element, MoveRenameRefactoringDefinition refactoring) {
        assert (element != null) : "Parameter 'element' of method 'moveAndRename' must not be null";
        assert (refactoring != null) : "Parameter 'refactoring' of method 'doMoveRenameJavaElements' must not be null";
        RefactoringAction action = () -> {
            LOGGER.debug("move+rename for {}", (Object)element);
            IJavaElement eclipseElement = ElementMapper.getEclipseElement(element);
            ArrayList<IEclipseRefactoringInteraction> interactions = new ArrayList<IEclipseRefactoringInteraction>();
            if (eclipseElement instanceof ICompilationUnit) {
                interactions.addAll(this.determineCompilationUnitMoveRenameActions(refactoring, (ICompilationUnit)eclipseElement));
            } else if (eclipseElement instanceof IPackageFragment) {
                IPackageFragment packageToMove = (IPackageFragment)eclipseElement;
                String targetRootDirectoryFqName = refactoring.getTargetRootDirectoryFqName();
                IPackageFragmentRoot targetRoot = EclipseWorkspaceUtils.getRootDirectory(targetRootDirectoryFqName);
                IPackageFragment targetParentPackage = EclipseWorkspaceUtils.getPackage(targetRootDirectoryFqName, refactoring.getMoveToParentName());
                if (this.getPackagesForRename(Arrays.asList(packageToMove), targetRoot).size() > 0) {
                    IPackageFragment newPackage = EclipseWorkspaceUtils.getPackage(targetRootDirectoryFqName, targetParentPackage.getElementName() + "." + EclipseWorkspaceUtils.getLastPackageNamePart(refactoring.getNewName()));
                    interactions.addAll(this.determinePackageRenameActions(TOP_LEVEL, packageToMove, newPackage, false));
                } else {
                    try {
                        interactions.addAll(this.determinePackageMoveAndRenameActions(packageToMove, targetRoot, targetParentPackage, refactoring.getNewName()));
                    }
                    catch (JavaModelException ex) {
                        UserInterfaceAdapter.getInstance().error("Failed to Prepare Move/Rename Refactoring", "Failed to determine actions to move/rename package " + String.valueOf(eclipseElement.getResource().getFullPath()));
                        return;
                    }
                }
            }
            this.executeActions((RefactoringDefinition)refactoring, interactions);
        };
        this.execute(action);
    }

    public void delete(List<NamedElement> elements, DeleteRefactoringDefinition refactoring) {
        assert (elements != null) : "Parameter 'elements' of method 'delete' must not be null";
        assert (!elements.isEmpty()) : "Parameter 'elements' of method 'delete' must not be empty";
        assert (refactoring != null) : "Parameter 'refactoring' of method 'delete' must not be null";
        RefactoringAction action = () -> {
            Map<Module, List<NamedElement>> moduleMap = this.groupBySonargraphModule(elements);
            ArrayList<IEclipseRefactoringInteraction> actions = new ArrayList<IEclipseRefactoringInteraction>(moduleMap.size());
            for (Map.Entry<Module, List<NamedElement>> next : moduleMap.entrySet()) {
                List<IJavaElement> elementsToDelete = ElementMapper.getEclipseElements(next.getValue());
                if (!elementsToDelete.isEmpty()) {
                    actions.add(new DeleteElementsInteraction(elementsToDelete, IEclipseRefactoringInteraction.Recursive.YES));
                    continue;
                }
                UserInterfaceAdapter.getInstance().warning("Failed to map Sonargraph Elements", "Elements " + next.getValue().stream().map(element -> element.toString()).collect(Collectors.joining(", ")) + " could not be mapped to Eclipse elements.");
                return;
            }
            this.executeActions((RefactoringDefinition)refactoring, actions);
        };
        this.execute(action);
    }

    private void executeActions(RefactoringDefinition refactoring, List<IEclipseRefactoringInteraction> interactions) {
        RefactoringConfirmationDialog confirm;
        assert (refactoring != null) : "Parameter 'refactoring' of method 'executeActions' must not be null";
        assert (interactions != null) : "Parameter 'interactions' of method 'executeActions' must not be null";
        if (!this.isStillRunning()) {
            return;
        }
        if (interactions.size() == 0) {
            UserInterfaceAdapter.getInstance().error("Refactoring Failed", "Failed to determine interactions for refactoring:\n" + String.valueOf(refactoring));
            return;
        }
        String executionPlan = RefactoringLog.getExecutionPlan(refactoring, interactions);
        if (interactions.size() > 1 && (confirm = new RefactoringConfirmationDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), executionPlan)).open() != 0) {
            return;
        }
        LOGGER.debug(executionPlan);
        RefactoringType type = refactoring.getRefactoringType();
        RefactoringLog refactoringLog = new RefactoringLog(refactoring);
        int actionCounter = 0;
        while (actionCounter < interactions.size()) {
            block41: {
                boolean isExecutionInterrupted = false;
                boolean isActionSkipped = false;
                if (!this.isStillRunning()) {
                    return;
                }
                IEclipseRefactoringInteraction nextInteraction = interactions.get(actionCounter);
                ChangeType changeType = nextInteraction.getChangeType();
                nextInteraction.setDialogInfo("Step " + (actionCounter + 1) + " of " + interactions.size());
                if (nextInteraction.isExecutable()) {
                    List<IEclipseRefactoringInteraction> remainingInteractions;
                    String comment;
                    RefactoringCommentDialog commentDialog;
                    List<RefactoringChange> changes;
                    String msg;
                    RefactoringChangeListener refactoringChangeListener;
                    block39: {
                        LOGGER.debug("Executing {} of {}: {}", new Object[]{actionCounter + 1, interactions.size(), nextInteraction});
                        refactoringChangeListener = null;
                        try {
                            refactoringChangeListener = new RefactoringChangeListener(changeType, nextInteraction.getScopes());
                            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)refactoringChangeListener, 1);
                            if (nextInteraction.execute()) break block39;
                            isActionSkipped = true;
                            RefactoringCommentDialog commentDialog2 = new RefactoringCommentDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell());
                            if (actionCounter > 0) {
                                if (commentDialog2.open() == 0) {
                                    refactoringLog.add(nextInteraction, Collections.emptyList(), commentDialog2.getComment());
                                } else {
                                    refactoringLog.add(nextInteraction, Collections.emptyList(), "Skipped " + nextInteraction.toString());
                                }
                            }
                            isExecutionInterrupted = true;
                        }
                        catch (CoreException ex) {
                            block40: {
                                try {
                                    LOGGER.error("Failed to execute '" + String.valueOf(nextInteraction) + "'", (Throwable)ex);
                                    UserInterfaceAdapter.getInstance().error("Failed to execute refactoring", "Failed to execute '" + type.getPresentationName() + "':\n\n" + ex.getLocalizedMessage());
                                    refactoringLog.add(nextInteraction, refactoringChangeListener.getChanges(), "Failed to execute '" + type.getPresentationName() + "':\n\n" + ex.getLocalizedMessage());
                                    if (actionCounter >= interactions.size() - 1 || UserInterfaceAdapter.getInstance().question("Do you want to continue with the refactorings?", false) == UserInterfaceAdapter.Feedback.CONFIRMED) break block40;
                                    isExecutionInterrupted = true;
                                }
                                catch (Throwable throwable) {
                                    ResourcesPlugin.getWorkspace().removeResourceChangeListener(refactoringChangeListener);
                                    if (isExecutionInterrupted) {
                                        msg = "Canceled " + type.getPresentationName() + " refactoring after " + (actionCounter + 1) + " of " + interactions.size() + " steps.";
                                        LOGGER.warn(msg);
                                        refactoringLog.addCancelMessage(msg);
                                    } else if (!isActionSkipped) {
                                        assert (refactoringChangeListener != null);
                                        changes = refactoringChangeListener.getChanges();
                                        comment = !nextInteraction.isExecutedAsPlanned(changes) ? ((commentDialog = new RefactoringCommentDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell())).open() == 0 ? commentDialog.getComment() : "Not executed as planned") : "Executed as planned.";
                                        refactoringLog.add(nextInteraction, changes, comment);
                                        if (changeType != ChangeType.DELETE && !(remainingInteractions = interactions.subList(actionCounter + 1, interactions.size())).isEmpty() && !changes.isEmpty()) {
                                            this.adjustInteractions(remainingInteractions, changes);
                                        }
                                    }
                                    throw throwable;
                                }
                                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)refactoringChangeListener);
                                if (isExecutionInterrupted) {
                                    msg = "Canceled " + type.getPresentationName() + " refactoring after " + (actionCounter + 1) + " of " + interactions.size() + " steps.";
                                    LOGGER.warn(msg);
                                    refactoringLog.addCancelMessage(msg);
                                } else if (!isActionSkipped) {
                                    assert (refactoringChangeListener != null);
                                    changes = refactoringChangeListener.getChanges();
                                    comment = !nextInteraction.isExecutedAsPlanned(changes) ? ((commentDialog = new RefactoringCommentDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell())).open() == 0 ? commentDialog.getComment() : "Not executed as planned") : "Executed as planned.";
                                    refactoringLog.add(nextInteraction, changes, comment);
                                    if (changeType != ChangeType.DELETE && !(remainingInteractions = interactions.subList(actionCounter + 1, interactions.size())).isEmpty() && !changes.isEmpty()) {
                                        this.adjustInteractions(remainingInteractions, changes);
                                    }
                                }
                                return;
                            }
                            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)refactoringChangeListener);
                            if (isExecutionInterrupted) {
                                msg = "Canceled " + type.getPresentationName() + " refactoring after " + (actionCounter + 1) + " of " + interactions.size() + " steps.";
                                LOGGER.warn(msg);
                                refactoringLog.addCancelMessage(msg);
                            } else if (!isActionSkipped) {
                                assert (refactoringChangeListener != null);
                                changes = refactoringChangeListener.getChanges();
                                comment = !nextInteraction.isExecutedAsPlanned(changes) ? ((commentDialog = new RefactoringCommentDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell())).open() == 0 ? commentDialog.getComment() : "Not executed as planned") : "Executed as planned.";
                                refactoringLog.add(nextInteraction, changes, comment);
                                if (changeType != ChangeType.DELETE && !(remainingInteractions = interactions.subList(actionCounter + 1, interactions.size())).isEmpty() && !changes.isEmpty()) {
                                    this.adjustInteractions(remainingInteractions, changes);
                                }
                            }
                            break block41;
                        }
                        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)refactoringChangeListener);
                        if (isExecutionInterrupted) {
                            msg = "Canceled " + type.getPresentationName() + " refactoring after " + (actionCounter + 1) + " of " + interactions.size() + " steps.";
                            LOGGER.warn(msg);
                            refactoringLog.addCancelMessage(msg);
                            break;
                        }
                        if (isActionSkipped) break;
                        assert (refactoringChangeListener != null);
                        changes = refactoringChangeListener.getChanges();
                        comment = !nextInteraction.isExecutedAsPlanned(changes) ? ((commentDialog = new RefactoringCommentDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell())).open() == 0 ? commentDialog.getComment() : "Not executed as planned") : "Executed as planned.";
                        refactoringLog.add(nextInteraction, changes, comment);
                        if (changeType == ChangeType.DELETE || (remainingInteractions = interactions.subList(actionCounter + 1, interactions.size())).isEmpty() || changes.isEmpty()) break;
                        this.adjustInteractions(remainingInteractions, changes);
                        break;
                    }
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)refactoringChangeListener);
                    if (isExecutionInterrupted) {
                        msg = "Canceled " + type.getPresentationName() + " refactoring after " + (actionCounter + 1) + " of " + interactions.size() + " steps.";
                        LOGGER.warn(msg);
                        refactoringLog.addCancelMessage(msg);
                    } else if (!isActionSkipped) {
                        assert (refactoringChangeListener != null);
                        changes = refactoringChangeListener.getChanges();
                        comment = !nextInteraction.isExecutedAsPlanned(changes) ? ((commentDialog = new RefactoringCommentDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell())).open() == 0 ? commentDialog.getComment() : "Not executed as planned") : "Executed as planned.";
                        refactoringLog.add(nextInteraction, changes, comment);
                        if (changeType != ChangeType.DELETE && !(remainingInteractions = interactions.subList(actionCounter + 1, interactions.size())).isEmpty() && !changes.isEmpty()) {
                            this.adjustInteractions(remainingInteractions, changes);
                        }
                    }
                } else {
                    LOGGER.warn("Action [" + (actionCounter + 1) + " of " + interactions.size() + "] no longer executable: " + String.valueOf(nextInteraction));
                }
            }
            ++actionCounter;
        }
        if (actionCounter > 0) {
            LOGGER.info("Refactoring log: \n" + String.valueOf(refactoringLog));
            RefactoringLogDialog logDialog = new RefactoringLogDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), refactoringLog);
            logDialog.open();
        }
    }

    private boolean isStillRunning() {
        ISoftwareSystemProvider systemProvider = this.m_plugin.getSoftwareSystemProvider();
        if (systemProvider == null || !systemProvider.hasSoftwareSystem()) {
            LOGGER.error("Plugin no longer running");
            return false;
        }
        return true;
    }

    private void adjustInteractions(List<IEclipseRefactoringInteraction> remaining, List<RefactoringChange> changes) {
        assert (remaining != null && !remaining.isEmpty()) : "Parameter 'remaining' of method 'adjustInteractions' must not be empty";
        assert (changes != null && !changes.isEmpty()) : "Parameter 'changes' of method 'adjustInteractions' must not be empty";
        HashMap<IResource, IJavaElement> oldResourceToNewJavaElementMap = new HashMap<IResource, IJavaElement>();
        for (RefactoringChange nextChange : changes) {
            ICompilationUnit changed;
            IResource original = nextChange.getFrom();
            IResource newResource = nextChange.getTo();
            assert (newResource != null) : "Adjustment must not be executed for deleted elements";
            if (original instanceof IFile) {
                changed = JavaCore.createCompilationUnitFrom((IFile)((IFile)newResource));
                assert (changed != null) : "changed resource not found: " + String.valueOf(newResource.getFullPath());
                oldResourceToNewJavaElementMap.put(original, (IJavaElement)changed);
                continue;
            }
            if (original instanceof IFolder) {
                changed = JavaCore.create((IFolder)((IFolder)newResource));
                assert (changed != null) : "changed resource not found: " + String.valueOf(newResource.getFullPath());
                oldResourceToNewJavaElementMap.put(original, (IJavaElement)changed);
                continue;
            }
            assert (false) : "Unsupported resource type '" + original.getClass().getCanonicalName() + "' of resource " + String.valueOf(newResource.getFullPath());
        }
        for (IEclipseRefactoringInteraction nextInteraction : remaining) {
            nextInteraction.updateElements(oldResourceToNewJavaElementMap);
        }
    }

    private List<IEclipseRefactoringInteraction> determinePackageRenameActions(Integer level, IPackageFragment source, IPackageFragment target, IPackageFragment intermediate, boolean isEscaped) {
        assert (level != null) : "Parameter 'level' of method 'determinePackageRenameActions' must not be null";
        assert (source != null) : "Parameter 'source' of method 'determineRenameActions' must not be null";
        assert (target != null) : "Parameter 'target' of method 'determineRenameActions' must not be null";
        assert (intermediate != null) : "Parameter 'intermediate' of method 'determinePackageRenameActions' must not be null";
        assert (!intermediate.exists()) : "Parameter 'intermediate' of method 'determinePackageRenameActions' must not exist";
        ArrayList<IEclipseRefactoringInteraction> actions = new ArrayList<IEclipseRefactoringInteraction>();
        try {
            ArrayList<IPackageFragment> sourceChildPackages = new ArrayList<IPackageFragment>(EclipseWorkspaceUtils.getSubPackages(source));
            LOGGER.debug(StringUtility.concat((String)" ", (int)level) + String.valueOf(level) + ": Determine rename actions for " + source.getElementName());
            if (!target.exists()) {
                actions.add(new RenamePackageInteraction(intermediate, target, IEclipseRefactoringInteraction.Recursive.YES, isEscaped));
            } else {
                ICompilationUnit[] compilationUnits = source.getCompilationUnits();
                if (compilationUnits.length > 0) {
                    LOGGER.debug(StringUtility.concat((String)" ", (int)level) + String.valueOf(level) + ": Moving compilation units of " + source.getElementName() + " to " + target.getElementName());
                    actions.add(new MoveCompilationUnitsInteraction(new ArrayList<ICompilationUnit>(Arrays.asList(compilationUnits)), target));
                }
                int start = source.getElementName().length();
                String targetName = target.getElementName();
                for (IPackageFragment sourceChildPackage : sourceChildPackages) {
                    String elementName = sourceChildPackage.getElementName();
                    String childPackageSuffix = elementName.substring(start);
                    String childTargetName = targetName + childPackageSuffix;
                    IPackageFragmentRoot intermediateRoot = (IPackageFragmentRoot)intermediate.getParent();
                    IPackageFragment childTargetPackage = EclipseWorkspaceUtils.getPackage(intermediateRoot, childTargetName);
                    IPackageFragment intermediateChild = EclipseWorkspaceUtils.getPackage(intermediateRoot, intermediate.getElementName() + childPackageSuffix);
                    actions.addAll(this.determinePackageRenameActions(level + 1, sourceChildPackage, childTargetPackage, intermediateChild, isEscaped));
                }
                if (level == 1) {
                    LOGGER.debug(StringUtility.concat((String)" ", (int)level) + String.valueOf(level) + ": Deleting package " + intermediate.getElementName());
                    actions.add(new DeleteElementsInteraction(new ArrayList<IPackageFragment>(Arrays.asList(intermediate)), IEclipseRefactoringInteraction.Recursive.YES, Arrays.asList(intermediate.getElementName())));
                }
            }
        }
        catch (JavaModelException ex) {
            LOGGER.error("Failed to process elements for rename refactoring", (Throwable)ex);
            UserInterfaceAdapter.getInstance().error("Preprocessing for Refactoring Failed", "The necessary Eclipse interactions for the rename refactoring could not be determined:\n\n" + ex.getLocalizedMessage());
        }
        return actions;
    }

    private List<IEclipseRefactoringInteraction> determinePackageRenameActions(Integer level, IPackageFragment source, IPackageFragment target, boolean isEscaped) {
        assert (level != null) : "Parameter 'level' of method 'innerDeterminePackageRenameActions' must not be null";
        assert (source != null) : "Parameter 'source' of method 'determineRenameActions' must not be null";
        assert (target != null) : "Parameter 'target' of method 'determineRenameActions' must not be null";
        ArrayList<IEclipseRefactoringInteraction> actions = new ArrayList<IEclipseRefactoringInteraction>();
        try {
            ArrayList<IPackageFragment> sourceChildPackages = new ArrayList<IPackageFragment>(EclipseWorkspaceUtils.getSubPackages(source));
            LOGGER.trace(StringUtility.concat((String)" ", (int)level) + String.valueOf(level) + ": Determine rename actions for " + source.getElementName());
            if (!target.exists()) {
                actions.add(new RenamePackageInteraction(source, target, IEclipseRefactoringInteraction.Recursive.YES, isEscaped));
            } else {
                ICompilationUnit[] compilationUnits = source.getCompilationUnits();
                if (compilationUnits.length > 0) {
                    LOGGER.trace(StringUtility.concat((String)" ", (int)level) + String.valueOf(level) + ": Moving compilation units of " + source.getElementName() + " to " + target.getElementName());
                    actions.add(new MoveCompilationUnitsInteraction(Arrays.asList(compilationUnits), target));
                }
                int start = source.getElementName().length();
                for (IPackageFragment sourceChildPackage : sourceChildPackages) {
                    String elementName = sourceChildPackage.getElementName();
                    String childTargetName = elementName.substring(start + 1);
                    IPackageFragment childTargetPackage = EclipseWorkspaceUtils.getPackage(target, childTargetName);
                    actions.addAll(this.determinePackageRenameActions(level + 1, sourceChildPackage, childTargetPackage, isEscaped));
                }
                if (level == 1) {
                    LOGGER.trace(StringUtility.concat((String)" ", (int)level) + String.valueOf(level) + ": Deleting package " + source.getElementName());
                    actions.add(new DeleteElementsInteraction(new ArrayList<IPackageFragment>(Arrays.asList(source)), IEclipseRefactoringInteraction.Recursive.YES));
                }
            }
        }
        catch (JavaModelException ex) {
            LOGGER.error("Failed to process elements for rename refactoring", (Throwable)ex);
            UserInterfaceAdapter.getInstance().error("Preprocessing for Refactoring Failed", "The necessary Eclipse interactions for the rename refactoring could not be determined:\n\n" + ex.getLocalizedMessage());
        }
        return actions;
    }

    private List<IEclipseRefactoringInteraction> determinePackageMoveActions(List<IPackageFragment> packagesToMove, IPackageFragmentRoot targetRoot) throws JavaModelException {
        assert (packagesToMove != null) : "Parameter 'packagesToMove' of method 'determinePackageMoveActions' must not be null";
        assert (targetRoot != null) : "Parameter 'targetRoot' of method 'determinePackageMoveActions' must not be null";
        ArrayList<IPackageFragment> packagesToCreate = new ArrayList<IPackageFragment>();
        ArrayList<MoveCompilationUnitsInteraction> moveCompilationUnitsActions = new ArrayList<MoveCompilationUnitsInteraction>();
        ArrayList<IJavaElement> packagesToDelete = new ArrayList<IJavaElement>();
        for (IPackageFragment next : packagesToMove) {
            IPackageFragment destination = targetRoot.getPackageFragment(next.getElementName());
            if (!destination.exists()) {
                packagesToCreate.add(next);
                continue;
            }
            List<ICompilationUnit> compilationUnits = Arrays.asList(next.getCompilationUnits());
            if (!compilationUnits.isEmpty()) {
                moveCompilationUnitsActions.add(new MoveCompilationUnitsInteraction(compilationUnits, destination));
            }
            packagesToDelete.add((IJavaElement)next);
        }
        ArrayList<IEclipseRefactoringInteraction> actions = new ArrayList<IEclipseRefactoringInteraction>();
        if (!packagesToCreate.isEmpty()) {
            actions.add(new MovePackagesInteraction(packagesToCreate, targetRoot));
        }
        actions.addAll(moveCompilationUnitsActions);
        if (!packagesToDelete.isEmpty()) {
            actions.add(new DeleteElementsInteraction(packagesToDelete, IEclipseRefactoringInteraction.Recursive.NO));
        }
        return actions;
    }

    private List<IEclipseRefactoringInteraction> determineVirtualPackageMoveActions(List<IPackageFragment> packagesToMove, List<IPackageFragment> virtualPackagesToMove, IPackageFragmentRoot targetRoot) throws JavaModelException {
        assert (packagesToMove != null) : "Parameter 'packagesToMove' of method 'determinePackageMoveActions' must not be null";
        assert (virtualPackagesToMove != null) : "Parameter 'virtualPackagesToMove' of method 'determineVirtualPackageMoveActions' must not be null";
        assert (packagesToMove.size() == virtualPackagesToMove.size()) : "number of packages to move does not match: " + packagesToMove.size() + " vs. " + virtualPackagesToMove.size();
        assert (targetRoot != null) : "Parameter 'targetRoot' of method 'determinePackageMoveActions' must not be null";
        ArrayList<IPackageFragment> packagesToCreate = new ArrayList<IPackageFragment>();
        ArrayList<MoveCompilationUnitsInteraction> moveCompilationUnitsActions = new ArrayList<MoveCompilationUnitsInteraction>();
        int i = 0;
        while (i < packagesToMove.size()) {
            IPackageFragment currentPackage = packagesToMove.get(i);
            IPackageFragment virtualPackage = virtualPackagesToMove.get(i);
            IPackageFragment destination = targetRoot.getPackageFragment(virtualPackage.getElementName());
            if (!destination.exists()) {
                packagesToCreate.add(virtualPackage);
            } else {
                ArrayList<ICompilationUnit> compilationUnits = new ArrayList<ICompilationUnit>(Arrays.asList(currentPackage.getCompilationUnits()));
                if (!compilationUnits.isEmpty()) {
                    moveCompilationUnitsActions.add(new MoveCompilationUnitsInteraction(compilationUnits, destination));
                }
            }
            ++i;
        }
        ArrayList<IEclipseRefactoringInteraction> actions = new ArrayList<IEclipseRefactoringInteraction>();
        if (!packagesToCreate.isEmpty()) {
            actions.add(new MovePackagesInteraction(packagesToCreate, targetRoot));
        }
        actions.addAll(moveCompilationUnitsActions);
        return actions;
    }

    private Map<Module, List<NamedElement>> groupBySonargraphModule(List<NamedElement> namedElements) {
        assert (namedElements != null) : "Parameter 'namedElements' of method 'sameSonargraphModule' must not be null";
        assert (!namedElements.isEmpty()) : "Parameter 'namedElements' of method 'sameSonargraphModule' must not be empty";
        LinkedHashMap<Module, ArrayList<NamedElement>> moduleMap = new LinkedHashMap<Module, ArrayList<NamedElement>>();
        for (NamedElement namedElement : namedElements) {
            Module parent = (Module)namedElement.getOriginalParent(Module.class);
            if (parent == null) {
                LOGGER.error("Skipping element '" + namedElement.getFullyQualifiedName() + "' because no module could be determined");
                continue;
            }
            ArrayList<NamedElement> elements = (ArrayList<NamedElement>)moduleMap.get(parent);
            if (elements == null) {
                elements = new ArrayList<NamedElement>();
                moduleMap.put(parent, elements);
            }
            elements.add(namedElement);
        }
        return Collections.unmodifiableMap(moduleMap);
    }

    private List<IEclipseRefactoringInteraction> determineCompilationUnitMoveRenameActions(MoveRenameRefactoringDefinition refactoring, ICompilationUnit compilationUnit) {
        assert (refactoring != null) : "Parameter 'refactoring' of method 'determineMoveRenameActions' must not be null";
        assert (compilationUnit != null) : "Parameter 'compilationUnit' of method 'determineMoveRenameActions' must not be null";
        ArrayList<IEclipseRefactoringInteraction> interactions = new ArrayList<IEclipseRefactoringInteraction>();
        IPackageFragment targetPackage = EclipseWorkspaceUtils.getPackage(refactoring.getTargetRootDirectoryFqName(), refactoring.getMoveToParentName());
        IPackageFragment sourcePackage = (IPackageFragment)compilationUnit.getParent();
        ICompilationUnit cuIntermediate = targetPackage != null ? targetPackage.getCompilationUnit(compilationUnit.getElementName()) : null;
        String fileExtension = "." + compilationUnit.getResource().getFileExtension();
        if (targetPackage == null || !targetPackage.exists() || cuIntermediate == null || !cuIntermediate.exists()) {
            interactions.add(new MoveCompilationUnitsInteraction(Arrays.asList(compilationUnit), targetPackage));
            interactions.add(new RenameCompilationUnitInteraction(compilationUnit, refactoring.getNewName() + fileExtension));
            return interactions;
        }
        ICompilationUnit cuIntermediate2 = sourcePackage.getCompilationUnit(refactoring.getNewName() + fileExtension);
        if (cuIntermediate2 == null || !cuIntermediate2.exists()) {
            interactions.add(new RenameCompilationUnitInteraction(compilationUnit, refactoring.getNewName() + fileExtension));
            interactions.add(new MoveCompilationUnitsInteraction(Arrays.asList(compilationUnit), targetPackage, Arrays.asList(refactoring.getNewName() + fileExtension)));
            return interactions;
        }
        String escapedName = "__" + refactoring.getNewName() + "__" + fileExtension;
        ICompilationUnit cuIntermediate3 = sourcePackage.getCompilationUnit(escapedName);
        ICompilationUnit cuIntermediate4 = targetPackage.getCompilationUnit(escapedName);
        if (cuIntermediate3 != null && cuIntermediate3.exists() || cuIntermediate4 != null && cuIntermediate4.exists()) {
            StringBuilder names = new StringBuilder();
            if (cuIntermediate3 != null && cuIntermediate3.exists()) {
                names.append(cuIntermediate3.getResource().getFullPath().toString()).append("\n");
            }
            if (cuIntermediate4 != null && cuIntermediate4.exists()) {
                names.append(cuIntermediate4.getResource().getFullPath().toString());
            }
            UserInterfaceAdapter.getInstance().error("Failed to Execute Refactoring", "Left-over compilation unit from past refactorings exists. Please remove it:\n" + String.valueOf(names));
            return Collections.emptyList();
        }
        interactions.add(new RenameCompilationUnitInteraction(compilationUnit, escapedName, true));
        interactions.add(new MoveCompilationUnitsInteraction(Arrays.asList(compilationUnit), targetPackage, Arrays.asList(escapedName)));
        interactions.add(new RenameCompilationUnitInteraction(compilationUnit, refactoring.getNewName() + fileExtension, escapedName));
        return interactions;
    }

    private Collection<IEclipseRefactoringInteraction> determinePackageMoveAndRenameActions(IPackageFragment packageToMove, IPackageFragmentRoot targetRoot, IPackageFragment targetParentPackage, String newPackageName) throws JavaModelException {
        assert (packageToMove != null) : "Parameter 'packageToMove' of method 'determinePackageMoveAndRenameActions' must not be null";
        assert (targetRoot != null) : "Parameter 'targetRoot' of method 'determinePackageMoveAndRenameActions' must not be null";
        assert (targetParentPackage != null) : "Parameter 'targetParentPackage' of method 'determinePackageMoveAndRenameActions' must not be null";
        ArrayList<IEclipseRefactoringInteraction> actions = new ArrayList<IEclipseRefactoringInteraction>();
        IPackageFragment intermediate = EclipseWorkspaceUtils.getPackage(targetRoot, packageToMove.getElementName());
        if (intermediate == null || !intermediate.exists()) {
            ArrayList<IPackageFragment> packages = new ArrayList<IPackageFragment>();
            packages.add(packageToMove);
            packages.addAll(EclipseWorkspaceUtils.getSubPackagesRecursively(packageToMove));
            actions.addAll(this.determinePackageMoveActions(packages, targetRoot));
            IPackageFragment targetPackage = EclipseWorkspaceUtils.getPackage(targetRoot, targetParentPackage.getElementName() + "." + newPackageName);
            actions.addAll(this.determinePackageRenameActions(TOP_LEVEL, packageToMove, targetPackage, intermediate, false));
        } else {
            IJavaElement parent = packageToMove.getParent();
            assert (parent != null && parent instanceof IPackageFragmentRoot) : "Unexpected class in method 'determinePackageMoveAndRenameActions': " + String.valueOf(parent);
            IPackageFragmentRoot sourceRoot = (IPackageFragmentRoot)parent;
            String intermediateName = targetParentPackage.getElementName() + "." + newPackageName;
            IPackageFragment intermediate2 = EclipseWorkspaceUtils.getPackage(sourceRoot, intermediateName);
            if (intermediate2 == null || !intermediate2.exists()) {
                actions.addAll(this.determinePackageRenameActions(TOP_LEVEL, packageToMove, intermediate2, false));
                ArrayList<IPackageFragment> packages = new ArrayList<IPackageFragment>();
                packages.add(packageToMove);
                packages.addAll(EclipseWorkspaceUtils.getSubPackagesRecursively(packageToMove));
                ArrayList<IPackageFragment> intermediatePackages = new ArrayList<IPackageFragment>();
                assert (intermediate2 != null);
                intermediatePackages.add(intermediate2);
                for (IPackageFragment next : EclipseWorkspaceUtils.getSubPackagesRecursively(packageToMove)) {
                    String packageSuffix = next.getElementName().substring(packageToMove.getElementName().length() + 1, next.getElementName().length());
                    String intermediatePackageName = intermediate2.getElementName() + "." + packageSuffix;
                    IPackageFragment intermediateSubPackage = EclipseWorkspaceUtils.getPackage(sourceRoot, intermediatePackageName);
                    intermediatePackages.add(intermediateSubPackage);
                }
                actions.addAll(this.determineVirtualPackageMoveActions(packages, intermediatePackages, targetRoot));
                IPackageFragment targetPackage = EclipseWorkspaceUtils.getPackage(targetRoot, targetParentPackage.getElementName() + "." + newPackageName);
                if (targetPackage.exists()) {
                    LOGGER.debug("Final package {} of rename+move exists, therefore the intermediate {} needs to be deleted at the end", (Object)targetPackage.getResource().getFullPath(), (Object)intermediate2.getResource().getFullPath());
                    actions.add(new DeleteElementsInteraction(new ArrayList<IPackageFragment>(Arrays.asList(intermediate2)), IEclipseRefactoringInteraction.Recursive.YES, Arrays.asList(intermediate2.getElementName())));
                }
            } else {
                String escapedIntermediateName = targetParentPackage.getElementName() + ".__" + newPackageName + "__";
                IPackageFragment escapedIntermediate = EclipseWorkspaceUtils.getPackage(sourceRoot, escapedIntermediateName);
                IPackageFragment escapedIntermediateTarget = EclipseWorkspaceUtils.getPackage(targetRoot, escapedIntermediateName);
                if (escapedIntermediate.exists() || escapedIntermediateTarget.exists()) {
                    StringBuilder names = new StringBuilder();
                    if (escapedIntermediate.exists()) {
                        names.append("   ").append(escapedIntermediate.getResource().getFullPath().toString()).append("\n");
                    }
                    if (escapedIntermediateTarget.exists()) {
                        names.append("   ").append(escapedIntermediateTarget.getResource().getFullPath().toString());
                    }
                    UserInterfaceAdapter.getInstance().error("Failed to Execute Refactoring", "Left-over package from past refactorings exists. Please remove it:\n" + String.valueOf(names));
                    return Collections.emptyList();
                }
                actions.addAll(this.determinePackageRenameActions(TOP_LEVEL, packageToMove, escapedIntermediate, true));
                ArrayList<IPackageFragment> packages = new ArrayList<IPackageFragment>();
                packages.add(packageToMove);
                packages.addAll(EclipseWorkspaceUtils.getSubPackagesRecursively(packageToMove));
                ArrayList<IPackageFragment> intermediatePackages = new ArrayList<IPackageFragment>();
                intermediatePackages.add(escapedIntermediate);
                for (IPackageFragment next : EclipseWorkspaceUtils.getSubPackagesRecursively(packageToMove)) {
                    String packageSuffix = next.getElementName().substring(packageToMove.getElementName().length() + 1, next.getElementName().length());
                    String intermediatePackageName = escapedIntermediate.getElementName() + "." + packageSuffix;
                    IPackageFragment intermediateSubPackage = EclipseWorkspaceUtils.getPackage(sourceRoot, intermediatePackageName);
                    intermediatePackages.add(intermediateSubPackage);
                }
                actions.addAll(this.determineVirtualPackageMoveActions(packages, intermediatePackages, targetRoot));
                IPackageFragment targetPackage = EclipseWorkspaceUtils.getPackage(targetRoot, targetParentPackage.getElementName() + "." + newPackageName);
                actions.addAll(this.determinePackageRenameActions(TOP_LEVEL, packageToMove, targetPackage, escapedIntermediateTarget, false));
            }
        }
        return actions;
    }

    private Collection<MoveCompilationUnitsInteraction> createMoveInteractions(Map<IPackageFragment, List<ICompilationUnit>> packageToCompilationUnits, IPackageFragment targetPackage) {
        assert (packageToCompilationUnits != null) : "Parameter 'packageToCompilationUnits' of method 'createMoveInteractions' must not be null";
        assert (targetPackage != null) : "Parameter 'targetRootPackage' of method 'createMoveInteractions' must not be null";
        ArrayList<MoveCompilationUnitsInteraction> result = new ArrayList<MoveCompilationUnitsInteraction>();
        for (Map.Entry<IPackageFragment, List<ICompilationUnit>> entry : packageToCompilationUnits.entrySet()) {
            MoveCompilationUnitsInteraction interaction = new MoveCompilationUnitsInteraction(entry.getValue(), targetPackage);
            result.add(interaction);
        }
        return result;
    }

    private Map<IPackageFragmentRoot, List<IPackageFragment>> getPackagesForChangeOfRoot(List<IJavaElement> packagesToMove, IPackageFragmentRoot targetRoot, String targetPackageName, IEclipseRefactoringInteraction.Recursive recursive) throws JavaModelException {
        assert (packagesToMove != null) : "Parameter 'packagesToMove' of method 'getPackagesForMove' must not be null";
        assert (targetRoot != null) : "Parameter 'targetRoot' of method 'getPackagesForMove' must not be null";
        assert (targetPackageName != null) : "Parameter 'targetPackageName' of method 'getPackagesForChangeOfRoot' must not be null";
        assert (recursive != null) : "Parameter 'recursive' of method 'getPackagesForSimpleMove' must not be null";
        if (packagesToMove.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<IPackageFragmentRoot, List<IPackageFragment>> rootToPackages = new LinkedHashMap<IPackageFragmentRoot, List<IPackageFragment>>();
        for (IJavaElement next : packagesToMove) {
            List<IPackageFragment> packages;
            assert (next != null && next instanceof IPackageFragment) : "Unexpected class in method 'getPackagesForMove': " + String.valueOf(next);
            IPackageFragment nextPackage = (IPackageFragment)next;
            IJavaElement parent = next.getParent();
            assert (parent != null && parent instanceof IPackageFragmentRoot) : "Unexpected class in method 'getPackagesForMove': " + String.valueOf(parent);
            if ((targetPackageName != DEFAULT_PACKAGE || !EclipseWorkspaceUtils.isTopLevelPackage(nextPackage)) && !targetPackageName.equals(EclipseWorkspaceUtils.getNameOfParentPackage(nextPackage))) continue;
            IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
            if (!rootToPackages.containsKey(root)) {
                packages = new ArrayList();
                rootToPackages.put(root, packages);
            } else {
                packages = (List)rootToPackages.get(root);
            }
            if (!packages.contains(nextPackage)) {
                packages.add(nextPackage);
            }
            if (recursive != IEclipseRefactoringInteraction.Recursive.YES) continue;
            for (IPackageFragment sub : EclipseWorkspaceUtils.getSubPackagesRecursively(nextPackage)) {
                if (packages.contains(sub)) continue;
                packages.add(sub);
            }
        }
        return rootToPackages;
    }

    private List<IPackageFragment> getPackagesForRename(List<IJavaElement> packages, IPackageFragmentRoot targetRoot) {
        assert (packages != null) : "Parameter 'packages' of method 'getPackagesForRename' must not be null";
        ArrayList<IPackageFragment> result = new ArrayList<IPackageFragment>();
        for (IJavaElement next : packages) {
            assert (next != null && next instanceof IPackageFragment) : "Unexpected class in method 'getPackagesForRename': " + String.valueOf(next);
            IPackageFragment nextFragment = (IPackageFragment)next;
            if (!nextFragment.getParent().equals(targetRoot)) continue;
            result.add(nextFragment);
        }
        return result;
    }

    private Map<IPackageFragment, List<ICompilationUnit>> groupCompilationUnitsByPackageFragment(List<IJavaElement> javaElements) {
        assert (javaElements != null) : "Parameter 'javaElements' of method 'groupCompilationUnitsByPackageFragment' must not be null";
        LinkedHashMap<IPackageFragment, List<ICompilationUnit>> result = new LinkedHashMap<IPackageFragment, List<ICompilationUnit>>();
        for (IJavaElement next : javaElements) {
            if (!(next instanceof ICompilationUnit)) continue;
            ICompilationUnit cu = (ICompilationUnit)next;
            IJavaElement parent = cu.getParent();
            assert (parent != null && parent instanceof IPackageFragment) : "Unexpected class in method 'groupCompilationUnitsByPackageFragment': " + String.valueOf(parent);
            IPackageFragment fragment = (IPackageFragment)parent;
            ArrayList<ICompilationUnit> units = (ArrayList<ICompilationUnit>)result.get(fragment);
            if (units == null) {
                units = new ArrayList<ICompilationUnit>();
                result.put(fragment, units);
            }
            units.add(cu);
        }
        return result;
    }

    public static boolean areBuildsRunningOrPending() {
        boolean running = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length > 0 || Job.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0;
        return running;
    }

    private boolean isAutoBuildActive() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    private void setWorkspaceAutoBuild(boolean enabled) throws CoreException {
        IWorkspaceDescription workspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
        workspaceDescription.setAutoBuilding(enabled);
        ResourcesPlugin.getWorkspace().setDescription(workspaceDescription);
    }

    @FunctionalInterface
    private static interface RefactoringAction {
        public void doIt();
    }
}

