/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.EnumSet;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public final class StatusController
implements EventHandler,
ISonargraphStatusProvider {
    @Inject
    private IEventBroker m_eventBroker;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusController.class);
    private ISonargraphStatusProvider.SonargraphStatus m_status = ISonargraphStatusProvider.SonargraphStatus.UNINITIALIZED;
    private StrictPair<Integer, Integer> m_errors_warnings = null;

    void connect() {
        this.m_eventBroker.subscribe(ISonargraphStatusProvider.Topic.SONARGRAPH_STATUS.getName(), null, (EventHandler)this, true);
    }

    void disconnect() {
        this.m_eventBroker.unsubscribe((EventHandler)this);
    }

    void setStatus(ISonargraphStatusProvider.SonargraphStatus status, Object sender) {
        this.setStatus(status, sender, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(ISonargraphStatusProvider.SonargraphStatus status, Object sender, StrictPair<Integer, Integer> errorsWarnings) {
        assert (status != null) : "Parameter 'status' of method 'setStatus' must not be null";
        assert (sender != null) : "Parameter 'sender' of method 'setStatus' must not be null";
        StatusController statusController = this;
        synchronized (statusController) {
            if (status == this.m_status) {
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received status {} from {}", (Object)status, sender);
            }
            if (!this.validateTransition(this.m_status, status)) {
                LOGGER.error("Invalid transition from {} to {}", (Object)this.m_status, (Object)status);
            }
            this.m_status = status;
            this.m_errors_warnings = errorsWarnings;
        }
        this.m_eventBroker.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"com.hello2morrow.sonargraph.ide.eclipse.handledtoolitem.status");
    }

    private boolean validateTransition(ISonargraphStatusProvider.SonargraphStatus from, ISonargraphStatusProvider.SonargraphStatus to) {
        assert (from != null) : "Parameter 'from' of method 'validateTransition' must not be null";
        assert (to != null) : "Parameter 'to' of method 'validateTransition' must not be null";
        switch (from) {
            case UNINITIALIZED: {
                return to == ISonargraphStatusProvider.SonargraphStatus.INITIALIZED;
            }
            case INITIALIZED: {
                return EnumSet.of(ISonargraphStatusProvider.SonargraphStatus.UNINITIALIZED, ISonargraphStatusProvider.SonargraphStatus.ANALYZING, ISonargraphStatusProvider.SonargraphStatus.SUSPENDED, ISonargraphStatusProvider.SonargraphStatus.CANCELLED).contains((Object)to);
            }
            case SUSPENDED: {
                return EnumSet.of(ISonargraphStatusProvider.SonargraphStatus.ANALYZING, ISonargraphStatusProvider.SonargraphStatus.WORKSPACE_CLEARED, ISonargraphStatusProvider.SonargraphStatus.INITIALIZED, ISonargraphStatusProvider.SonargraphStatus.UNINITIALIZED).contains((Object)to);
            }
            case ANALYZING: {
                return EnumSet.of(ISonargraphStatusProvider.SonargraphStatus.INITIALIZED, new ISonargraphStatusProvider.SonargraphStatus[]{ISonargraphStatusProvider.SonargraphStatus.CANCELLED, ISonargraphStatusProvider.SonargraphStatus.WORKSPACE_CLEARED, ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_OK, ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_WITH_ISSUES, ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_OK_BASELINE, ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_WITH_ISSUES_BASELINE, ISonargraphStatusProvider.SonargraphStatus.UNINITIALIZED, ISonargraphStatusProvider.SonargraphStatus.SUSPENDED}).contains((Object)to);
            }
            case CANCELLED: {
                return EnumSet.of(ISonargraphStatusProvider.SonargraphStatus.ANALYZING, ISonargraphStatusProvider.SonargraphStatus.WORKSPACE_CLEARED, ISonargraphStatusProvider.SonargraphStatus.SUSPENDED, ISonargraphStatusProvider.SonargraphStatus.UNINITIALIZED).contains((Object)to);
            }
            case WORKSPACE_CLEARED: {
                return EnumSet.of(ISonargraphStatusProvider.SonargraphStatus.ANALYZING, new ISonargraphStatusProvider.SonargraphStatus[]{ISonargraphStatusProvider.SonargraphStatus.SUSPENDED, ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_OK, ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_WITH_ISSUES, ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_OK_BASELINE, ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_WITH_ISSUES_BASELINE, ISonargraphStatusProvider.SonargraphStatus.UNINITIALIZED}).contains((Object)to);
            }
            case RESULTS_PRESENT_OK: 
            case RESULTS_PRESENT_OK_BASELINE: 
            case RESULTS_PRESENT_WITH_ISSUES: 
            case RESULTS_PRESENT_WITH_ISSUES_BASELINE: {
                return EnumSet.of(ISonargraphStatusProvider.SonargraphStatus.ANALYZING, ISonargraphStatusProvider.SonargraphStatus.SUSPENDED, ISonargraphStatusProvider.SonargraphStatus.WORKSPACE_CLEARED, ISonargraphStatusProvider.SonargraphStatus.UNINITIALIZED).contains((Object)to);
            }
        }
        return false;
    }

    public void handleEvent(Event event) {
        StrictPair errorsWarnings;
        Object property = event.getProperty(ISonargraphStatusProvider.Property.STATUS.name());
        assert (property != null && property instanceof ISonargraphStatusProvider.SonargraphStatus) : "Unexpected class in method 'handleEvent': " + String.valueOf(property);
        Object sender = event.getProperty(ISonargraphStatusProvider.Property.SENDER.name());
        Object errorsWarningsObj = event.getProperty(ISonargraphStatusProvider.Property.ERROR_WARNING_COUNT.name());
        if (errorsWarningsObj != null) {
            assert (errorsWarningsObj != null && errorsWarningsObj instanceof StrictPair) : "Unexpected class in method 'handleEvent': " + String.valueOf(errorsWarningsObj);
            errorsWarnings = (StrictPair)errorsWarningsObj;
        } else {
            errorsWarnings = null;
        }
        assert (sender != null) : "sender must not be null";
        this.setStatus((ISonargraphStatusProvider.SonargraphStatus)((Object)property), sender, (StrictPair<Integer, Integer>)errorsWarnings);
    }

    @Override
    public synchronized Pair<ISonargraphStatusProvider.SonargraphStatus, StrictPair<Integer, Integer>> getStatus() {
        return new Pair((Object)this.m_status, this.m_errors_warnings);
    }
}

