/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.client.eclipse.application.EclipseRelease;
import com.hello2morrow.sonargraph.core.application.ILicenseHandlerProvider;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandlerProduction;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemClosedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemIssuesModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemOpenedEvent;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.ide.eclipse.activator.SonargraphEclipsePluginActivator;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.EclipsePluginProxySettingsProvider;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.RenewLicenseTicketAutomaticallyHandler;
import com.hello2morrow.sonargraph.ide.eclipse.e3.E3DecoratorManager;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.CloseSoftwareSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ReloadSoftwareSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.ide.eclipse.model.IMarkerProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.model.RefreshInfo;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.EclipsePluginExceptionHandler;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.MarkerController;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.SonargraphEclipsePluginApplication;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.SonargraphEclipsePluginLogListener;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.SonargraphEclipseWorkspaceBuildEventListener;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.SonargraphEclipseWorkspaceChangeListener;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.StatusController;
import com.hello2morrow.sonargraph.ide.eclipse.view.EclipsePreferenceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.view.MostRecentlyUsedSystemsDialog;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaLanguage;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IExceptionHandlingSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.LinkSelectionListener;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.dialog.MessageDialogWithContent;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionDialog;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import com.hello2morrow.sonargraph.ui.swt.license.LicenseServerComposite;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphEclipsePlugin
implements ILicenseHandlerProvider,
SonargraphLicenseHandler.ILicenseLostEventHandler,
ISonargraphEclipsePlugin,
IExceptionHandlingSupport,
ISonargraphUIContribution {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphEclipsePlugin.class);
    @Inject
    private IEclipseContext m_eclipseContext;
    @Inject
    private SonargraphEclipsePluginApplication m_application;
    @Inject
    private E3DecoratorManager m_decoratorManager;
    @Inject
    private IEventBroker m_eventBroker;
    @Inject
    private StatusController m_statusController;
    @Inject
    private MarkerController m_markerProvider;
    @Inject
    private org.eclipse.e4.core.services.log.Logger m_logger;
    private Display m_display;
    private final FileRegistry m_fileRegistry = new FileRegistry();
    private final RefreshInfo m_refreshInfo = new RefreshInfo();
    private ILogListener m_logListener;
    private ISoftwareSystemProvider m_softwareSystemProvider;
    private SonargraphEclipseWorkspaceBuildEventListener m_buildEventListener;
    private SonargraphEclipseWorkspaceChangeListener m_resourceChangeListener;
    private SonargraphLicenseHandlerProduction m_licenseHandler;
    private SystemMappingInfo m_currentMappingInfo;
    private OperationResult m_licenseHandlerInitializationResult;
    private boolean m_isStopping = false;
    private ISonargraphEclipsePlugin.SystemDiffStatus m_systemDiffStatus;

    @Inject
    public SonargraphEclipsePlugin() {
    }

    @PostConstruct
    public void start(final IEventBroker eventBroker, Display display) throws Exception {
        LOGGER.info("Start Sonargraph Eclipse plugin");
        this.m_display = display;
        this.m_eclipseContext.set(ISonargraphEclipsePlugin.class, (Object)this);
        this.m_eclipseContext.set(ISonargraphStatusProvider.class, (Object)this.m_statusController);
        this.m_statusController.connect();
        this.m_eclipseContext.set(IMarkerProvider.class, (Object)this.m_markerProvider);
        this.m_logListener = new SonargraphEclipsePluginLogListener(new EclipsePluginExceptionHandler(this, this));
        Platform.addLogListener((ILogListener)this.m_logListener);
        org.osgi.service.event.EventHandler eventHandler = new org.osgi.service.event.EventHandler(){

            public void handleEvent(Event event) {
                eventBroker.unsubscribe((org.osgi.service.event.EventHandler)this);
                SonargraphEclipsePlugin.this.initialize(EclipsePreferenceUtils.isExecutingStatus() ? ISonargraphEclipsePlugin.StartupOption.LOAD_SYSTEM : ISonargraphEclipsePlugin.StartupOption.PLAIN, JobType.PROVIDES_PROGESS);
            }
        };
        eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appStartupComplete", eventHandler);
        LOGGER.info("Start Sonargraph Eclipse plugin - done");
    }

    private void loadLastUsedSystem(JobType jobType) {
        String message;
        LOGGER.debug("loadLastUsedSystem {}", (Object)jobType);
        assert (jobType != null) : "Parameter 'jobType' of method 'loadLastUsedSystem' must not be null";
        assert (this.m_softwareSystemProvider != null) : "SoftwareSystemProvider must be initialized";
        String lastUsedSystemPath = EclipsePreferenceUtils.getLastUsedSoftwareSystemPath();
        TFile systemDir = this.getSystemDirectory(lastUsedSystemPath);
        if (lastUsedSystemPath != null && systemDir == null) {
            message = "Last used system no longer exists:\n" + lastUsedSystemPath + "\n";
            EclipsePreferenceUtils.storeLastUsedSystemInPreferences(null);
        } else {
            message = null;
        }
        if (systemDir == null) {
            UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> {
                MostRecentlyUsedSystemsDialog dialog;
                List<String> sonargraphSystemPaths = EclipseWorkspaceUtils.getSonargraphSystemPaths();
                if (sonargraphSystemPaths.size() > 0 && (dialog = new MostRecentlyUsedSystemsDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), sonargraphSystemPaths, message)).open() == 0) {
                    String systemPath = dialog.getSelectedSystemPath();
                    assert (systemPath != null) : "systemPath must not be null";
                    this.openSystem(JobType.PROVIDES_PROGESS, new TFile(systemPath));
                }
            });
        } else {
            this.openSystem(jobType, systemDir);
        }
    }

    private void openSystem(JobType jobType, TFile systemDir) {
        LOGGER.debug("openSystem {} {}", (Object)jobType, (Object)systemDir);
        assert (jobType != null) : "Parameter 'jobType' of method 'openSystem' must not be null";
        assert (systemDir != null) : "Parameter 'systemDir' of method 'openSystem' must not be null";
        ReloadSoftwareSystemJob job = new ReloadSoftwareSystemJob(this.m_eventBroker, this, this.m_softwareSystemProvider, this.m_fileRegistry, systemDir, jobType);
        job.schedule();
    }

    private TFile getSystemDirectory(String path) {
        if (path == null) {
            return null;
        }
        TFile systemDir = new TFile(path);
        if (!systemDir.exists() || !systemDir.isDirectory()) {
            return null;
        }
        return systemDir;
    }

    @Override
    public boolean initialize(ISonargraphEclipsePlugin.StartupOption option, JobType jobType) {
        LOGGER.debug("initialize {} {}", (Object)option, (Object)jobType);
        assert (option != null) : "Parameter 'option' of method 'initialize' must not be null";
        assert (jobType != null) : "Parameter 'jobType' of method 'initialize' must not be null";
        assert (this.m_logger != null) : "'m_logger' of method 'initialize' must not be null";
        this.detachEventHandler();
        this.setStopping(false);
        if (this.m_application.isInitialized()) {
            if (this.m_softwareSystemProvider != null && this.m_softwareSystemProvider.hasSoftwareSystem()) {
                CloseSoftwareSystemJob closeJob = new CloseSoftwareSystemJob(this.m_eventBroker, this.m_softwareSystemProvider);
                closeJob.schedule();
                try {
                    closeJob.join();
                }
                catch (InterruptedException ex) {
                    LOGGER.error("Interrupted while closing software system during re-initialization", (Throwable)ex);
                }
            }
            this.m_application.shutdownStarted(this.m_softwareSystemProvider);
            this.m_application.shutdown();
        }
        TrueZipFacade.clear();
        this.m_softwareSystemProvider = this.m_application.initialize(SonargraphEclipsePluginActivator.getBundleContext(), new ScriptOutputStreamProvider(), Collections.singleton(JavaLanguage.INSTANCE.getStandardName().toLowerCase()), WorkbenchRegistry.readAnalyzerExecutionLevel(), this, this);
        if (this.m_softwareSystemProvider == null) {
            LOGGER.error("Failed to initialize software system provider: {}", (Object)this.m_licenseHandlerInitializationResult);
            this.showInitializationWarningDialog("Failed to initialize Sonargraph!", "Please use the 'Manage License' dialog from the Sonargraph menu to check if you have a valid license.\nIf you think you have a valid license contact support@hello2morrow.com.");
            return false;
        }
        this.enableDecoratorManager();
        this.m_markerProvider.clear(this.m_softwareSystemProvider, this.m_eventBroker);
        this.attachEventHandler();
        if (WorkbenchRegistry.hasInstance()) {
            WorkbenchRegistry.delete();
        }
        MApplication application = (MApplication)this.m_eclipseContext.get(MApplication.class);
        MWindow mainApplicationWindow = (MWindow)application.getChildren().get(0);
        WorkbenchRegistry.createInstance((IEclipseContext)this.m_eclipseContext, (IEventBroker)this.m_eventBroker, (Display)this.m_display, (MWindow)mainApplicationWindow, (ISoftwareSystemProvider)this.m_softwareSystemProvider, Collections.emptySet(), (WorkbenchRegistry.ILinkSelectionListener)new LinkSelectionListener(), Collections.emptyList(), Collections.emptyList(), (WorkbenchRegistry.Mode)WorkbenchRegistry.Mode.INTEGRATED);
        UserInterfaceAdapter.createInstance((org.eclipse.e4.core.services.log.Logger)this.m_logger, (boolean)false);
        this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.INITIALIZED, this);
        this.m_application.startupComplete();
        WorkbenchRegistry.getInstance().startupComplete();
        if (option == ISonargraphEclipsePlugin.StartupOption.LOAD_SYSTEM) {
            this.loadLastUsedSystem(jobType);
        }
        return true;
    }

    @Override
    public void showInitializationWarningDialog(String title, String message) {
        this.m_display.asyncExec(() -> {
            MessageDialogWithContent dialog = new MessageDialogWithContent(this.m_display.getActiveShell(), title, 4, message);
            dialog.open();
        });
    }

    private void attachEventHandler() {
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemOpenedEvent>(SoftwareSystemOpenedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemOpenedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                SonargraphEclipsePlugin.this.m_buildEventListener = new SonargraphEclipseWorkspaceBuildEventListener(SonargraphEclipsePlugin.this, SonargraphEclipsePlugin.this.m_eventBroker);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)SonargraphEclipsePlugin.this.m_buildEventListener, 24);
                SonargraphEclipsePlugin.this.m_resourceChangeListener = new SonargraphEclipseWorkspaceChangeListener(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)SonargraphEclipsePlugin.this.m_resourceChangeListener, 6);
                JavaCore.addElementChangedListener((IElementChangedListener)SonargraphEclipsePlugin.this.m_resourceChangeListener, (int)1);
                EclipsePreferenceUtils.storeLastUsedSystemInPreferences(SonargraphEclipsePlugin.this.getCurrentSoftwareSystemPath());
                SonargraphEclipsePlugin.this.enableDecoratorManager();
                SonargraphEclipsePlugin.this.determineSystemDiffStatus();
                if (!SonargraphEclipsePlugin.this.isSystemDiffActive()) {
                    SonargraphEclipsePlugin.this.m_markerProvider.initForCurrentIssues(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemIssuesModifiedEvent>(SoftwareSystemIssuesModifiedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemIssuesModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (!event.getDelta().isEmpty() && !SonargraphEclipsePlugin.this.isSystemDiffActive()) {
                    SonargraphEclipsePlugin.this.m_markerProvider.update(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker, event.getDelta());
                } else {
                    THashMap data = new THashMap();
                    ISonargraphStatusProvider.SonargraphStatus status = ISonargraphStatusProvider.SonargraphStatus.ANALYZING;
                    data.put(ISonargraphStatusProvider.Property.STATUS.name(), status);
                    data.put(ISonargraphStatusProvider.Property.SENDER.name(), ((Object)((Object)this)).getClass().getSimpleName());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Posting status for issues modified: {}, sender: {}", (Object)status, (Object)((Object)((Object)this)).getClass().getSimpleName());
                    }
                    SonargraphEclipsePlugin.this.m_eventBroker.post(ISonargraphStatusProvider.Topic.SONARGRAPH_STATUS.getName(), (Object)data);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersStartedEvent>(AnalyzersStartedEvent.class, (Object)this){

            public void handleEvent(AnalyzersStartedEvent startedEvent) {
                if (!$assertionsDisabled && startedEvent == null) {
                    throw new AssertionError((Object)"Parameter 'started' of method 'handleEvent' must not be null");
                }
                THashMap data = new THashMap();
                ISonargraphStatusProvider.SonargraphStatus status = ISonargraphStatusProvider.SonargraphStatus.ANALYZING;
                data.put(ISonargraphStatusProvider.Property.STATUS.name(), status);
                data.put(ISonargraphStatusProvider.Property.SENDER.name(), ((Object)((Object)this)).getClass().getSimpleName());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Posting status: {}, sender: {}", (Object)status, (Object)((Object)((Object)this)).getClass().getSimpleName());
                }
                SonargraphEclipsePlugin.this.m_eventBroker.post(ISonargraphStatusProvider.Topic.SONARGRAPH_STATUS.getName(), (Object)data);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersFinishedEvent>(AnalyzersFinishedEvent.class, (Object)this){

            public void handleEvent(AnalyzersFinishedEvent finishedEvent) {
                if (!$assertionsDisabled && finishedEvent == null) {
                    throw new AssertionError((Object)"Parameter 'finishedEvent' of method 'handleEvent' must not be null");
                }
                if (SonargraphEclipsePlugin.this.isSystemDiffActive()) {
                    SonargraphEclipsePlugin.this.m_markerProvider.refreshForSystemDiff(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker);
                } else {
                    SonargraphEclipsePlugin.this.m_markerProvider.analysisFinished(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemClosedEvent>(SoftwareSystemClosedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemClosedEvent event) {
                if (SonargraphEclipsePlugin.this.m_buildEventListener != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)SonargraphEclipsePlugin.this.m_buildEventListener);
                    SonargraphEclipsePlugin.this.m_buildEventListener = null;
                }
                if (SonargraphEclipsePlugin.this.m_resourceChangeListener != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)SonargraphEclipsePlugin.this.m_resourceChangeListener);
                    JavaCore.removeElementChangedListener((IElementChangedListener)SonargraphEclipsePlugin.this.m_resourceChangeListener);
                    SonargraphEclipsePlugin.this.m_resourceChangeListener = null;
                }
                SonargraphEclipsePlugin.this.innerDeactivate();
            }
        });
    }

    @Override
    public void determineSystemDiffStatus() {
        long start = System.currentTimeMillis();
        if (!this.m_softwareSystemProvider.hasSoftwareSystem()) {
            this.m_systemDiffStatus = ISonargraphEclipsePlugin.SystemDiffStatus.INACTIVE;
            return;
        }
        SoftwareSystem softwareSystem = this.m_softwareSystemProvider.getSoftwareSystem();
        ISystemDiffProvider diffProvider = (ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class);
        boolean isDiffActive = diffProvider.isLicensed() && diffProvider.executesOnCurrentAnalyzerExecutionLevel() && diffProvider.getActiveBaselineFile() != null;
        LOGGER.debug("Needed {} ms to determine that system diff is {}.", (Object)(System.currentTimeMillis() - start), (Object)(isDiffActive ? "active" : "inactive"));
        this.m_systemDiffStatus = isDiffActive ? ISonargraphEclipsePlugin.SystemDiffStatus.ACTIVE : ISonargraphEclipsePlugin.SystemDiffStatus.INACTIVE;
    }

    @Override
    public boolean isSystemDiffActive() {
        return this.m_softwareSystemProvider.getAnalyzerExecutionLevel() == AnalyzerExecutionLevel.FULL && this.m_systemDiffStatus == ISonargraphEclipsePlugin.SystemDiffStatus.ACTIVE;
    }

    private void detachEventHandler() {
        LOGGER.debug("detach");
        EventManager.getInstance().detach(SoftwareSystemOpenedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersStartedEvent.class, (Object)this);
        EventManager.getInstance().detach(SoftwareSystemIssuesModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersFinishedEvent.class, (Object)this);
        EventManager.getInstance().detach(SoftwareSystemClosedEvent.class, (Object)this);
    }

    @Override
    public boolean reinitializeAfterError() {
        LOGGER.debug("reinitializeAfterError");
        this.innerDeactivate();
        WorkbenchRegistry.getInstance().shutdownStarted();
        this.m_application.shutdownStarted(this.m_softwareSystemProvider);
        this.m_application.shutdown();
        this.resetLicenseHandler();
        this.m_softwareSystemProvider = null;
        UserInterfaceAdapter.delete();
        return this.initialize(ISonargraphEclipsePlugin.StartupOption.PLAIN, JobType.PROVIDES_PROGESS);
    }

    private void resetLicenseHandler() {
        if (this.m_licenseHandler != null) {
            this.m_licenseHandler.releaseLicenseTicket();
            this.m_licenseHandler = null;
            this.m_eclipseContext.remove(SonargraphLicenseHandler.class);
        }
    }

    private void innerDeactivate() {
        LOGGER.debug("innerDeactivate");
        this.m_fileRegistry.clear();
        this.m_currentMappingInfo = null;
        this.m_refreshInfo.clear();
        this.m_markerProvider.clear(this.m_softwareSystemProvider, this.m_eventBroker);
        for (IProject project : EclipseWorkspaceUtils.getActiveSonargraphProjects()) {
            EclipseWorkspaceUtils.clearSonargraphResourceProperties((IResource)project);
        }
        this.disableDecoratorManager();
        TrueZipFacade.clear();
        String lastUsedSystem = EclipsePreferenceUtils.getLastUsedSoftwareSystemPath();
        if (lastUsedSystem != null) {
            this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.SUSPENDED, this);
        } else {
            this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.INITIALIZED, this);
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        LOGGER.info("Stop Sonargraph Eclipse plugin");
        LOGGER.debug("Cancel all Sonargraph jobs...");
        Job.getJobManager().cancel((Object)"com.hello2morrow.sonargraph.ide.eclipse.jobs");
        this.m_statusController.disconnect();
        this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.UNINITIALIZED, this);
        boolean isExecuting = false;
        if (this.m_softwareSystemProvider != null && this.m_softwareSystemProvider.hasSoftwareSystem()) {
            LOGGER.debug("Close Sonargraph software system...");
            isExecuting = true;
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_buildEventListener);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_resourceChangeListener);
            JavaCore.removeElementChangedListener((IElementChangedListener)this.m_resourceChangeListener);
            CloseSoftwareSystemJob closeJob = new CloseSoftwareSystemJob(this.m_eventBroker, this.m_softwareSystemProvider);
            closeJob.schedule();
        }
        EclipsePreferenceUtils.storeExecutingStatus(isExecuting);
        try {
            LOGGER.debug("Wait for all Sonargraph jobs to finish...");
            Job.getJobManager().join((Object)"com.hello2morrow.sonargraph.ide.eclipse.jobs", null);
            LOGGER.debug("All Sonargraph jobs finished");
        }
        catch (OperationCanceledException e) {
            LOGGER.debug("... canceled");
        }
        catch (InterruptedException e) {
            LOGGER.debug("... interrupted");
        }
        catch (Exception e) {
            LOGGER.error("Could not wait for Sonargraph jobs to finish", (Throwable)e);
        }
        this.detachEventHandler();
        if (WorkbenchRegistry.hasInstance()) {
            WorkbenchRegistry.getInstance().shutdownStarted();
        }
        this.m_application.shutdownStarted(this.m_softwareSystemProvider);
        this.m_softwareSystemProvider = null;
        this.resetLicenseHandler();
        if (this.m_logListener != null) {
            Platform.removeLogListener((ILogListener)this.m_logListener);
        }
        this.m_application.shutdown();
        LOGGER.info("Stop Sonargraph Eclipse plugin - done");
    }

    @Override
    public FileRegistry getFileRegistry() {
        return this.m_fileRegistry;
    }

    @Override
    public IEventBroker getEventBroker() {
        return this.m_eventBroker;
    }

    public SonargraphLicenseHandler initializeLicenseHandler(SonargraphProduct product, Set<Language> availableLanguages, SonargraphLicenseHandler.ILicenseLostEventHandler handler) {
        LOGGER.debug("initializeLicenseHandler {} {} {}", new Object[]{product, availableLanguages, handler});
        assert (product != null) : "Parameter 'product' of method 'initializeLicenseHandler' must not be null";
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'getLicenseHandler' must not be null";
        this.m_licenseHandler = new SonargraphLicenseHandlerProduction(product, availableLanguages, handler);
        this.m_eclipseContext.set(SonargraphLicenseHandler.class, (Object)this.m_licenseHandler);
        EclipsePluginProxySettingsProvider proxySettingsProvider = new EclipsePluginProxySettingsProvider(SonargraphLicenseHandler.getHosts());
        ConnectionMode connectionMode = ConnectionDialog.getConnectionMode((IProxySettingsProvider)proxySettingsProvider);
        if (connectionMode == ConnectionMode.ONLINE) {
            boolean autoRenew = RenewLicenseTicketAutomaticallyHandler.isActive();
            this.m_licenseHandler.setRenewLicenseTicketAutomatically(autoRenew);
            this.m_licenseHandler.setProxySettings(proxySettingsProvider.getProxySettings(false));
            this.m_licenseHandler.setLicenseServer(LicenseServerComposite.createLicenseServerSettings((boolean)false));
        }
        this.m_licenseHandlerInitializationResult = this.m_licenseHandler.initialize();
        return this.m_licenseHandler;
    }

    @Override
    public boolean isInitialized() {
        return this.m_application.isInitialized() && this.m_softwareSystemProvider != null;
    }

    public void handleLicenseLostEvent(String serverReply) {
        UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> UserInterfaceAdapter.getInstance().warning("Sonargraph License Lost", serverReply));
        this.updateSonargraphAnalysisStatus(ISonargraphEclipsePlugin.AnalysisStatus.SUSPENDED);
    }

    @Override
    public String getCurrentSoftwareSystemPath() {
        return ((Files)this.m_softwareSystemProvider.getSoftwareSystem().getUniqueExistingChild(Files.class)).getSystemDirectory().getFile().getNormalizedAbsolutePath();
    }

    @Override
    public void updateSonargraphAnalysisStatus(ISonargraphEclipsePlugin.AnalysisStatus status) {
        boolean isExecuting;
        assert (status != null) : "Parameter 'status' of method 'setSonargraphAnalysisStatus' must not be null";
        if (this.m_softwareSystemProvider.hasSoftwareSystem()) {
            Job.getJobManager().cancel((Object)"com.hello2morrow.sonargraph.ide.eclipse.jobs");
            CloseSoftwareSystemJob closeJob = new CloseSoftwareSystemJob(this.m_eventBroker, this.m_softwareSystemProvider);
            closeJob.schedule();
        }
        if (status == ISonargraphEclipsePlugin.AnalysisStatus.ACTIVE) {
            this.loadLastUsedSystem(JobType.PROVIDES_PROGESS);
            isExecuting = true;
        } else {
            isExecuting = false;
            this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.SUSPENDED, this);
        }
        EclipsePreferenceUtils.storeExecutingStatus(isExecuting);
    }

    @Override
    public void resetSonargraphAnalysisStatus() {
        if (this.m_softwareSystemProvider.hasSoftwareSystem()) {
            CloseSoftwareSystemJob closeJob = new CloseSoftwareSystemJob(this.m_eventBroker, this.m_softwareSystemProvider);
            closeJob.schedule();
        }
        this.loadLastUsedSystem(JobType.PROVIDES_PROGESS);
        EclipsePreferenceUtils.storeExecutingStatus(true);
    }

    public boolean isRunning() {
        return this.m_softwareSystemProvider != null;
    }

    @Override
    public ISoftwareSystemProvider getSoftwareSystemProvider() {
        return this.m_softwareSystemProvider;
    }

    @Override
    public IMarkerProvider getMarkerProvider() {
        return this.m_markerProvider;
    }

    @Override
    public void refactoringStarted() {
    }

    @Override
    public void refactoringFinished() {
    }

    @Override
    public String getEclipsePlatformVersion() {
        return EclipseRelease.getEclipseVersion().toString();
    }

    @Override
    public RefreshInfo getRefreshInfo() {
        return this.m_refreshInfo;
    }

    @Override
    public void setSystemMapping(SystemMappingInfo mappingInfo) {
        assert (mappingInfo != null) : "Parameter 'mappingInfo' of method 'setCurrentSystemMapping' must not be null";
        this.m_currentMappingInfo = mappingInfo;
    }

    @Override
    public SystemMappingInfo getSystemMapping() {
        return this.m_currentMappingInfo;
    }

    private void enableDecoratorManager() {
        assert (this.m_decoratorManager != null) : "Field 'm_decoratorManager' must be injected";
        this.m_decoratorManager.enable();
    }

    private void disableDecoratorManager() {
        assert (this.m_decoratorManager != null) : "Field 'm_decoratorManager' must be injected";
        this.m_decoratorManager.disable();
    }

    public String toString() {
        return SonargraphEclipsePlugin.class.getSimpleName();
    }

    @Override
    public void setStopping(boolean stop) {
        this.m_isStopping = stop;
    }

    @Override
    public boolean isStopping() {
        return this.m_isStopping;
    }

    @Override
    public Version getVersion() {
        return this.m_licenseHandler.getProductVersion();
    }
}

