/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model.refactoring;

import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.IEclipseRefactoringInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringChange;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RefactoringLog {
    private final Date m_executionTimeStamp = new Date();
    private final RefactoringDefinition m_refactoring;
    private final List<LogEntry> m_entries = new ArrayList<LogEntry>();
    private String m_cancelMessage;

    public RefactoringLog(RefactoringDefinition refactoring) {
        assert (refactoring != null) : "Parameter 'refactoring' of method 'RefactoringLog' must not be null";
        this.m_refactoring = refactoring;
    }

    public void add(IEclipseRefactoringInteraction interaction, List<RefactoringChange> changes, String comment) {
        assert (interaction != null) : "Parameter 'interaction' of method 'add' must not be null";
        assert (changes != null) : "Parameter 'changes' of method 'addChangesForLastInteraction' must not be null";
        assert (comment != null) : "Parameter 'comment' of method 'add' must not be null";
        this.m_entries.add(new LogEntry(interaction, changes, comment));
    }

    public String toString() {
        StringBuilder log = new StringBuilder();
        log.append("Execution of refactoring ").append(RefactoringLog.getRefactoringDefinitionInfo(this.m_refactoring)).append("\n");
        log.append("Execution timestamp: ").append(Iso8601DateFormat.formatDateAndTime((Date)this.m_executionTimeStamp)).append("\n");
        log.append("List of Changes:\n");
        if (this.m_entries.isEmpty()) {
            log.append("No changes detected to any resources in the Eclipse workspace.\n");
            return log.toString();
        }
        int counter = 0;
        for (LogEntry nextEntry : this.m_entries) {
            log.append(++counter).append(". Eclipse refactoring: ").append(nextEntry.getInteraction().toString()).append("\n");
            String comment = nextEntry.getComment();
            log.append("   Comment: ").append(comment).append("\n");
            for (RefactoringChange change : nextEntry.getChanges()) {
                log.append("   ").append(change.toString()).append("\n");
            }
        }
        if (this.m_cancelMessage != null) {
            log.append("\nCANCELED!\n").append(this.m_cancelMessage);
        }
        return log.toString();
    }

    public static String getRefactoringDefinitionInfo(RefactoringDefinition definition) {
        assert (definition != null) : "Parameter 'definition' of method 'getRefactoringDefinitionInfo' must not be null";
        StringBuilder msg = new StringBuilder();
        msg.append("[Type: '").append(definition.getRefactoringType().getPresentationName()).append("', Assignee: '").append(definition.getAssignee()).append("', Created: '").append(Iso8601DateFormat.formatDateAndTime((Date)definition.getDate())).append("',\nDescription: '").append(definition.getDescription()).append("']:");
        return msg.toString();
    }

    public void addCancelMessage(String msg) {
        assert (msg != null && msg.length() > 0) : "Parameter 'msg' of method 'addCancelMessage' must not be empty";
        this.m_cancelMessage = msg;
    }

    public static String getExecutionPlan(RefactoringDefinition refactoring, List<IEclipseRefactoringInteraction> interactions) {
        assert (refactoring != null) : "Parameter 'refactoring' of method 'getExecutionPlan' must not be null";
        assert (interactions != null && !interactions.isEmpty()) : "Parameter 'interactions' of method 'getExecutionPlan' must not be empty";
        StringBuilder msg = new StringBuilder();
        msg.append("Execution plan for refactoring ");
        msg.append(RefactoringLog.getRefactoringDefinitionInfo(refactoring)).append("\n");
        int i = 0;
        while (i < interactions.size()) {
            IEclipseRefactoringInteraction next = interactions.get(i);
            msg.append(i + 1).append(". ").append(next.getExecutionPlan()).append("\n");
            ++i;
        }
        return msg.toString();
    }

    private static class LogEntry {
        private final IEclipseRefactoringInteraction m_interaction;
        private final List<RefactoringChange> m_changes;
        private final String m_comment;

        public LogEntry(IEclipseRefactoringInteraction interaction, List<RefactoringChange> changes, String comment) {
            assert (interaction != null) : "Parameter 'interaction' of method 'LogEntry' must not be null";
            assert (changes != null) : "Parameter 'changes' of method 'LogEntry' must not be null";
            assert (comment != null) : "Parameter 'comment' of method 'LogEntry' must not be null";
            this.m_interaction = interaction;
            this.m_changes = changes;
            this.m_comment = comment;
        }

        public IEclipseRefactoringInteraction getInteraction() {
            return this.m_interaction;
        }

        public String getComment() {
            return this.m_comment == null ? "" : this.m_comment;
        }

        public List<RefactoringChange> getChanges() {
            return this.m_changes;
        }
    }
}

