/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import de.schlichtherle.truezip.file.TFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileRegistry
implements IFilePathListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRegistry.class);
    private final Map<IModule, Map<String, FilePath>> m_moduleToIdentifyingToFilePath = new HashMap<IModule, Map<String, FilePath>>();

    public FilePath getFilePath(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'exits' must not be empty";
        for (Map<String, FilePath> nextIdentifyingToFilePath : this.m_moduleToIdentifyingToFilePath.values()) {
            FilePath filePath = nextIdentifyingToFilePath.get(identifyingPath);
            if (filePath == null) continue;
            return filePath;
        }
        return null;
    }

    public void clear() {
        this.m_moduleToIdentifyingToFilePath.clear();
    }

    public boolean isEmpty() {
        return this.m_moduleToIdentifyingToFilePath.isEmpty();
    }

    public void filePathCreated(IModule module, FilePath filePath) {
        assert (module != null) : "Parameter 'module' of method 'filePathCreated' must not be null";
        assert (filePath != null) : "Parameter 'filePath' of method 'filePathCreated' must not be null";
        assert (filePath.isValid()) : "Parameter 'filePath' of method 'filePathCreated' is not valid: " + filePath.getIdentifyingPath();
        Map<String, FilePath> identifyingToFilePath = this.m_moduleToIdentifyingToFilePath.get(module);
        if (identifyingToFilePath == null) {
            identifyingToFilePath = new HashMap<String, FilePath>();
            this.m_moduleToIdentifyingToFilePath.put(module, identifyingToFilePath);
        }
        TFile file = filePath.getFile();
        assert (file != null) : "Parameter 'file' of method 'filePathCreated' must not be null";
        String identifyingPath = FileUtility.getIdentifyingPath((TFile)file);
        identifyingToFilePath.put(identifyingPath, filePath);
        LOGGER.trace("File path created: " + identifyingPath);
    }

    public void filePathDeleted(IModule module, FilePath filePath) {
        assert (module != null) : "Parameter 'module' of method 'filePathDeleted' must not be null";
        assert (filePath != null) : "Parameter 'filePath' of method 'filePathDeleted' must not be null";
        assert (filePath.isValid()) : "Parameter 'filePath' of method 'filePathDeleted' is not valid: " + filePath.getIdentifyingPath();
        TFile file = filePath.getFile();
        assert (file != null) : "'file' of method 'filePathDeleted' must not be null";
        Map<String, FilePath> identifyingToFilePath = this.m_moduleToIdentifyingToFilePath.get(module);
        assert (identifyingToFilePath != null) : "'identifyingToFilePath' of method 'filePathDeleted' must not be null";
        String identifyingPath = FileUtility.getIdentifyingPath((TFile)file);
        FilePath removed = identifyingToFilePath.remove(identifyingPath);
        if (removed == null) {
            LOGGER.warn("Removed must not be null: " + identifyingPath);
        }
        if (removed != null && removed != filePath) {
            LOGGER.warn("Not same instances of removed: " + removed.getAbsolutePath() + "; " + identifyingPath);
        }
        LOGGER.trace("File path deleted: " + identifyingPath);
    }

    public void filesCleared(Set<Language> languages) {
        assert (languages != null && !languages.isEmpty()) : "Parameter 'languages' of method 'filesCleared' must not be empty";
        this.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<IModule, Map<String, FilePath>> nextEntry : this.m_moduleToIdentifyingToFilePath.entrySet()) {
            builder.append("Module: ").append(nextEntry.getKey());
            builder.append("\n");
            for (Map.Entry<String, FilePath> nextModuleEntry : nextEntry.getValue().entrySet()) {
                builder.append("  ").append(nextModuleEntry.getKey()).append(" -> ").append(nextModuleEntry.getValue());
                builder.append("\n");
            }
        }
        return builder.toString();
    }
}

