/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;

abstract class AbstractASTBasedFinder
extends ASTVisitor {
    private final ProgrammingElement m_programmingElement;
    private final CompilationUnit m_compilationUnit;
    private ASTNode m_match;
    private ASTNode m_lastVisitedNode;

    public AbstractASTBasedFinder(CompilationUnit compilationUnit, ProgrammingElement programmingElement) {
        assert (compilationUnit != null) : "Parameter 'compilationUnit' of method 'AbstractFinder' must not be null";
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'AbstractASTBasedFinder' must not be null";
        this.m_compilationUnit = compilationUnit;
        this.m_programmingElement = programmingElement;
    }

    protected final ProgrammingElement getProgrammingElement() {
        return this.m_programmingElement;
    }

    protected final ASTNode getMatchingNode() {
        return this.m_match != null ? this.m_match : this.m_lastVisitedNode;
    }

    public abstract IJavaElement getMatch();

    protected final boolean processLineNumber(ASTNode node) {
        if (this.m_match != null) {
            return false;
        }
        int lineNumber = this.m_compilationUnit.getLineNumber(node.getStartPosition());
        if (lineNumber > this.m_programmingElement.getLineNumber()) {
            this.m_match = this.m_lastVisitedNode;
            return false;
        }
        this.m_lastVisitedNode = node;
        return true;
    }
}

