/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs.marker;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphSetBaselineJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.marker.AbstractCreateMarkerJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.IIssueToMarkerMap;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.AbstractIssueDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.ResolutionDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;

public class CreateMarkerJob
extends AbstractCreateMarkerJob {
    public CreateMarkerJob(IEventBroker eventbroker, ISoftwareSystemProvider systemProvider, IIssueToMarkerMap cache, Set<Issue> issuesToAdd, Set<Issue> issuesToRemove) {
        super(eventbroker, systemProvider, "Create Markers for Sonargraph Issues (Delta)", cache, issuesToAdd, issuesToRemove);
    }

    protected CreateMarkerJob(IEventBroker eventbroker, ISoftwareSystemProvider systemProvider, String name, IIssueToMarkerMap cache, Set<Issue> issuesToAdd, Set<Issue> issuesToRemove) {
        super(eventbroker, systemProvider, name, cache, issuesToAdd, issuesToRemove);
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected void postFinishedEvent(Map<String, Object> eventData, int numberOfErrors, int numberOfWarnings) {
        this.postStatusEvent(ISonargraphStatusProvider.SonargraphStatus.ANALYZING, eventData);
    }

    @Override
    protected List<Class<?>> getJobClassesThatMakeThisObsolete() {
        ArrayList clazzes = new ArrayList(super.getJobClassesThatMakeThisObsolete());
        clazzes.add(ISonargraphSetBaselineJob.class);
        return clazzes;
    }

    @Override
    protected List<AbstractIssueDto> convertIssues(Collection<Issue> issues, IProgressMonitor monitor) {
        assert (issues != null) : "Parameter 'issues' of method 'convertIssues' must not be null";
        List filteredIssues = issues.stream().filter(i -> i.getResolution() == null).filter(i -> !i.getId().getCategory().isGenerated() && !IGNORED_ISSUE_CATEGORIES.contains(i.getId().getCategory())).filter(VALID_ISSUE_TYPES).collect(Collectors.toList());
        IIssueProvider issueProvider = (IIssueProvider)this.getProvider().getSoftwareSystem().getExtension(IIssueProvider.class);
        ArrayList<AbstractIssueDto> issueDtos = new ArrayList<AbstractIssueDto>();
        for (Issue issue : filteredIssues) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            AbstractIssueDto dto = this.convertIssue(issueProvider, issue);
            if (dto == null || !dto.isValid()) continue;
            issueDtos.add(dto);
        }
        return issueDtos;
    }

    @Override
    protected List<ResolutionDto> convertResolutions(Collection<Issue> issues, IProgressMonitor monitor) {
        assert (issues != null) : "Parameter 'issues' of method 'convertResolutions' must not be null";
        SoftwareSystem softwareSystem = this.getProvider().getSoftwareSystem();
        IIssueProvider issueProvider = (IIssueProvider)softwareSystem.getExtension(IIssueProvider.class);
        List resolutions = issues.stream().map(i -> i.getResolution()).filter(r -> r != null && r instanceof Resolution).map(r -> (Resolution)r).filter(r -> r.getKind() != ResolutionKind.IGNORE).distinct().collect(Collectors.toList());
        ArrayList<ResolutionDto> resolutionDtos = new ArrayList<ResolutionDto>();
        for (Resolution resolution : resolutions) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            ResolutionDto dto = this.convertResolution(issueProvider, resolution);
            if (dto == null) continue;
            resolutionDtos.add(dto);
        }
        return resolutionDtos;
    }
}

