/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs.marker;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphCompleteMarkerJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphCompleteModelModifyingJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.SonargraphToEclipseResourceConverter;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.IIssueToMarkerMap;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.model.ResourceInfo;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.AbstractIssueDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.AbstractIssueDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.CycleGroupIssueDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.CycleGroupIssueDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateCodeBlockOccurrenceDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateCodeBlockOccurrenceDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateIssueDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateIssueDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.RefactoringDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.ResolutionDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.StandardIssueDto;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaIssueId;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCreateMarkerJob
extends AbstractSonargraphEclipseJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCreateMarkerJob.class);
    public static final String FAMILY = "com.hello2morrow.sonargraph.ide.eclipse.jobs.createMarkers";
    protected static final Set<IssueCategory> IGNORED_ISSUE_CATEGORIES = EnumSet.of(IssueCategory.INSTALLATION_CONFIGURATION, new IssueCategory[]{IssueCategory.SYSTEM_CONFIGURATION, IssueCategory.WORKSPACE, IssueCategory.ARCHITECTURE_CONSISTENCY, IssueCategory.ARCHITECTURE_DEFINITION, IssueCategory.SCRIPT_DEFINITION, IssueCategory.ARCHITECTURAL_VIEW});
    private static final List<Class<?>> JOBS_THAT_MAKE_THIS_OBSOLETE = Arrays.asList(ISonargraphCompleteMarkerJob.class, ISonargraphCompleteModelModifyingJob.class);
    protected static final Predicate<? super Issue> VALID_ISSUE_TYPES = i -> !i.getId().equals(JavaIssueId.JAVA_FILE_UNPARSEABLE) && !i.getId().equals(JavaIssueId.JAVA_FILE_PARSE_ERROR);
    private final IIssueToMarkerMap m_issueToMarkerMap;
    private final Set<Issue> m_issuesToRemove;
    private final Set<Issue> m_issuesToAdd;

    public AbstractCreateMarkerJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, String name, IIssueToMarkerMap issueToMarkerMap, Set<Issue> issuesToAdd, Set<Issue> issuesToRemove) {
        super(eventBroker, provider, name, JobType.BACKGROUND, 50, AbstractSonargraphEclipseJob.Scheduling.SEQUENTIALLY);
        assert (issueToMarkerMap != null) : "Parameter 'cache' of method 'CreateMarkerJob' must not be null";
        assert (issuesToAdd != null) : "Parameter 'issuesToAdd' of method 'AbstractCreateMarkerJob' must not be null";
        assert (issuesToRemove != null) : "Parameter 'issuesToRemove' of method 'AbstractCreateMarkerJob' must not be null";
        this.m_issueToMarkerMap = issueToMarkerMap;
        this.m_issuesToAdd = issuesToAdd;
        this.m_issuesToRemove = issuesToRemove;
    }

    public AbstractCreateMarkerJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, String name, IIssueToMarkerMap cache) {
        super(eventBroker, provider, name, JobType.BACKGROUND, 50, AbstractSonargraphEclipseJob.Scheduling.SEQUENTIALLY);
        this.m_issueToMarkerMap = cache;
        this.m_issuesToRemove = null;
        this.m_issuesToAdd = null;
    }

    @Override
    protected List<Class<?>> getJobClassesThatMakeThisObsolete() {
        return JOBS_THAT_MAKE_THIS_OBSOLETE;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) {
        StrictPair totalIssueCount;
        List<ResolutionDto> resolutionDtos;
        assert (monitor != null) : "Parameter 'monitor' of method 'runInWorkspaceInternal' must not be null";
        if (!this.getProvider().hasSoftwareSystem()) {
            return this.statusCancel("No software system");
        }
        long start = System.currentTimeMillis();
        if (this.m_issuesToRemove != null && !this.m_issuesToRemove.isEmpty()) {
            this.removeIssues(this.m_issuesToRemove, this.m_issueToMarkerMap);
        }
        List<AbstractIssueDto> issueDtos = this.convertIssues(this.m_issuesToAdd, monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.m_issuesToAdd != null) {
            Set<Issue> issuesWithResolution = this.m_issuesToAdd.stream().filter(i -> i.getResolution() != null).collect(Collectors.toSet());
            resolutionDtos = this.convertResolutions(issuesWithResolution, monitor);
        } else {
            resolutionDtos = this.convertResolutions(null, monitor);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time needed to convert issues and resolutions: {} ms", (Object)(System.currentTimeMillis() - start));
        }
        StrictPair issueCount = this.createMarkersForIssues(monitor, issueDtos);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        int taskCount = this.createMarkersForResolutions(monitor, resolutionDtos);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added {} problem markers, {} task markers in {} ms", new Object[]{issueCount, taskCount, System.currentTimeMillis() - start});
        }
        THashMap eventData = new THashMap();
        if (this.m_issuesToAdd == null) {
            eventData.put(ISonargraphStatusProvider.Property.ERROR_WARNING_COUNT.name(), issueCount);
            totalIssueCount = issueCount;
        } else {
            totalIssueCount = new StrictPair((Object)this.m_issueToMarkerMap.getNumberOfErrors(), (Object)this.m_issueToMarkerMap.getNumberOfWarnings());
            eventData.put(ISonargraphStatusProvider.Property.ERROR_WARNING_COUNT.name(), totalIssueCount);
        }
        this.postFinishedEvent((Map<String, Object>)eventData, (Integer)totalIssueCount.getFirst(), (Integer)totalIssueCount.getSecond());
        return Status.OK_STATUS;
    }

    private void removeIssues(Collection<Issue> issuesRemoved, IIssueToMarkerMap processedIssueCache) {
        assert (issuesRemoved != null) : "Parameter 'issuesRemoved' of method 'removeIssues' must not be null";
        assert (processedIssueCache != null) : "Parameter 'processedIssueCache' of method 'removeIssues' must not be null";
        for (Issue next : issuesRemoved) {
            List<IMarker> markers = processedIssueCache.removed(next);
            for (IMarker marker : markers) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    LOGGER.error("Exception occurred for deleting markers of issue '" + String.valueOf(next) + "'", (Throwable)e);
                }
            }
        }
    }

    protected abstract void postFinishedEvent(Map<String, Object> var1, int var2, int var3);

    protected final AbstractIssueDto convertIssue(IIssueProvider issueProvider, Issue issue) {
        AbstractIssueDto dto;
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'convertIssue' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'convertIssue' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        IssueCategory issueCategory = issue.getId().getCategory();
        if (AbstractCreateMarkerJob.isIssueToBeIgnored(issue)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignoring issue with id '{}' of category '{}'.", (Object)issue.getId().getStandardName(), (Object)issueCategory.getStandardName());
            }
            return null;
        }
        if (issueCategory == IssueCategory.CYCLE_GROUP) {
            AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)issue.getAffectedElement();
            NamedElement scope = cycleGroup.getScope();
            if (scope == null) {
                return null;
            }
            ResourceInfo scopeInfo = SonargraphToEclipseResourceConverter.convert((Element)scope);
            ResourceInfo info = new ResourceInfo(scopeInfo.getResource(), cycleGroup.getName(), false, scopeInfo.isPartOfActiveWorkspace());
            dto = issue.getId() == CoreIssueId.COMPONENT_CYCLE_GROUP ? new CycleGroupIssueDto((CycleGroupIssue)issue, info, this.createDescriptionForProblem(issue, cycleGroup.getName(), false), this.getSourceFiles(issueProvider, issue)) : new CycleGroupIssueDto((CycleGroupIssue)issue, info, this.createDescriptionForProblem(issue, cycleGroup.getName(), false), Collections.emptyList());
        } else if (issue.getId() == CoreIssueId.DUPLICATE_CODE_BLOCK) {
            ArrayList<DuplicateCodeBlockOccurrenceDto> occurrences = new ArrayList<DuplicateCodeBlockOccurrenceDto>();
            DuplicateCodeBlockIssue duplicateIssue = (DuplicateCodeBlockIssue)issue;
            ResourceInfo info = SonargraphToEclipseResourceConverter.convert(issue.getAffectedElement());
            for (DuplicateCodeBlockOccurrence next : duplicateIssue.getAffectedElement().getChildren(DuplicateCodeBlockOccurrence.class)) {
                DuplicateCodeBlockOccurrenceDto occurrenceDto = new DuplicateCodeBlockOccurrenceDto(info, next.getSourceFile().getFile(), next.getBlockBegin(), next.getBlockEnd(), next.getBlockSize(), next.getToleranceAsInt());
                occurrences.add(occurrenceDto);
            }
            dto = new DuplicateIssueDto(duplicateIssue, info, this.createDescriptionForProblem(issue, info.getSonargraphElementName(), info.isResourceTrueElement()), occurrences);
        } else {
            Element affectedElement = issue.getAffectedElement();
            if (affectedElement.isExternal()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Omitting issue for external element '{}'", (Object)affectedElement.getName());
                }
                dto = null;
            } else if (affectedElement.isExcluded()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Omitting issue for excluded element '{}'", (Object)affectedElement.getName());
                }
                dto = null;
            } else {
                ResourceInfo info = affectedElement instanceof ElementWithIssues ? SonargraphToEclipseResourceConverter.convert((Element)((ElementWithIssues)affectedElement).getOriginal()) : SonargraphToEclipseResourceConverter.convert(affectedElement);
                dto = new StandardIssueDto(issue, info, this.createDescriptionForProblem(issue, info.getSonargraphElementName(), info.isResourceTrueElement()), this.getSourceFiles(issueProvider, issue));
            }
        }
        return dto;
    }

    private List<TFile> getSourceFiles(IIssueProvider issueProvider, Issue issue) {
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'getSourceFiles' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'getSourceFiles' must not be null";
        List affectedPhysicalSourceFiles = issueProvider.getAffectedPhysicalSourceFiles(issue);
        if (affectedPhysicalSourceFiles.size() == 1) {
            return Collections.singletonList(((FilePath)affectedPhysicalSourceFiles.get(0)).getFile());
        }
        ArrayList<TFile> files = new ArrayList<TFile>(affectedPhysicalSourceFiles.size());
        for (FilePath path : affectedPhysicalSourceFiles) {
            files.add(path.getFile());
        }
        return files;
    }

    protected final ResolutionDto convertResolution(IIssueProvider issueProvider, Resolution resolution) {
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'convertResolution' must not be null";
        assert (resolution != null) : "Parameter 'resolution' of method 'convertResolution' must not be null";
        if (!resolution.isValid() || resolution.getMatchingElementsCount() == 0) {
            return null;
        }
        ArrayList associatedIssues = new ArrayList(resolution.getAssociatedIssues());
        ArrayList<AbstractIssueDto> issueDtos = new ArrayList<AbstractIssueDto>();
        for (IIssue accessor : associatedIssues) {
            Issue issue;
            if (!(accessor instanceof Issue) || !(issue = (Issue)accessor).isValid()) continue;
            AbstractIssueDto issueDto = this.convertIssue(issueProvider, issue);
            if (issueDto != null && issueDto.isValid()) {
                issueDtos.add(issueDto);
                continue;
            }
            if (issueDto == null || !LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("Omitting issue '{}' for resource '{}'", (Object)issueDto.getDebugInfo(), (Object)issueDto.getResourceInfo());
        }
        if (issueDtos.isEmpty()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Ignoring resolution '{}' because it does not contain any valid issues.", (Object)resolution.getDebugInfo());
            }
            return null;
        }
        ResolutionDto dto = resolution instanceof RefactoringDefinition ? new RefactoringDto((RefactoringDefinition)resolution, issueDtos) : new ResolutionDto(resolution, issueDtos);
        return dto;
    }

    protected static boolean isIssueToBeIgnored(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'isIssueToBeIgnored' must not be null";
        return IGNORED_ISSUE_CATEGORIES.contains(issue.getId().getCategory());
    }

    @Override
    public final boolean belongsTo(Object family) {
        return family instanceof AbstractCreateMarkerJob || super.belongsTo(family) || family == FAMILY;
    }

    protected final int convertPriority(Priority priority) {
        assert (priority != null) : "Parameter 'priority' of method 'determinePriority' must not be null";
        return switch (priority) {
            case Priority.HIGH -> 2;
            case Priority.MEDIUM -> 1;
            case Priority.LOW -> 0;
            default -> 1;
        };
    }

    protected final int convertSeverity(Severity severity) {
        assert (severity != null) : "Parameter 'severity' of method 'determineSeverity' must not be null";
        return switch (severity) {
            case Severity.ERROR -> 2;
            case Severity.WARNING -> 1;
            default -> 0;
        };
    }

    protected String createDescriptionForProblem(Issue issue, String elementName, boolean isResourceTrueElement) {
        assert (issue != null) : "Parameter 'issue' of method 'createDescriptionForProblem(Issue)' must not be null";
        StringBuilder description = new StringBuilder();
        if (issue.getId() == CoreIssueId.DUPLICATE_CODE_BLOCK || issue.getId().getCategory() == IssueCategory.CYCLE_GROUP) {
            NamedElementIssue namedElementIssue = (NamedElementIssue)issue;
            description.append(namedElementIssue.getAffectedElement().getShortName()).append(": ");
        } else if (issue.getId() != CoreIssueId.TODO) {
            description.append(issue.getName()).append(": ");
        }
        description.append(issue.getDescription());
        return description.toString();
    }

    protected StrictPair<Integer, Integer> createMarkersForIssues(IProgressMonitor monitor, List<AbstractIssueDto> issues) {
        assert (monitor != null) : "Parameter 'monitor' of method 'createMarkersForIssues' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'createMarkersForIssues' must not be null";
        Counter errors = new Counter();
        Counter warnings = new Counter();
        for (AbstractIssueDto issueDto : issues) {
            if (monitor.isCanceled()) {
                return new StrictPair((Object)-1, (Object)-1);
            }
            if (!issueDto.getIssue().isValid()) continue;
            ArrayList<IMarker> markers = new ArrayList<IMarker>();
            if (issueDto.getId().getCategory() == IssueCategory.CYCLE_GROUP) {
                if (issueDto.getId() == CoreIssueId.COMPONENT_CYCLE_GROUP) {
                    for (TFile nextCyclicElement : issueDto.getAffectedPhysicalSourceFiles()) {
                        IMarker cyclicMarker = this.addProblemMarkerForCyclicElement(nextCyclicElement, issueDto, errors, warnings);
                        if (cyclicMarker == null) continue;
                        markers.add(cyclicMarker);
                    }
                } else {
                    IMarker marker = this.addProblemMarker(null, issueDto.getResourceInfo().getResource(), issueDto, errors, warnings);
                    if (marker != null) {
                        markers.add(marker);
                    }
                }
                this.addMarkersToMap(issueDto.getIssue(), markers);
                continue;
            }
            if (issueDto.getId().getCategory() == IssueCategory.DUPLICATE_CODE) {
                List<DuplicateCodeBlockOccurrenceDto> occurrences;
                if (issueDto instanceof DuplicateIssueDiffDto) {
                    occurrences = ((DuplicateIssueDiffDto)issueDto).getOccurrences();
                } else if (issueDto instanceof DuplicateIssueDto) {
                    occurrences = ((DuplicateIssueDto)issueDto).getOccurrences();
                } else {
                    assert (false) : "Unsupported issueDto " + issueDto.getClass().getCanonicalName();
                    occurrences = Collections.emptyList();
                }
                for (DuplicateCodeBlockOccurrenceDto occurrence : occurrences) {
                    IMarker marker = this.addProblemMarkerForDuplicate(issueDto, occurrence, errors, warnings);
                    if (marker == null) continue;
                    markers.add(marker);
                }
                this.addMarkersToMap(issueDto.getIssue(), markers);
                continue;
            }
            Collection<TFile> sourceFiles = issueDto.getAffectedPhysicalSourceFiles();
            if (!sourceFiles.isEmpty()) {
                for (TFile sourceFile : sourceFiles) {
                    IMarker marker;
                    assert (sourceFile != null) : "source file received must not be null";
                    Optional<IFile> eclipseSourceFile = EclipseWorkspaceUtils.getLocationForFile(sourceFile);
                    if (!eclipseSourceFile.isPresent() || (marker = this.addProblemMarker(sourceFile, (IResource)eclipseSourceFile.get(), issueDto, errors, warnings)) == null) continue;
                    markers.add(marker);
                }
            } else {
                IMarker marker = this.addProblemMarker(null, issueDto.getResourceInfo().getResource(), issueDto, errors, warnings);
                if (marker != null) {
                    markers.add(marker);
                }
            }
            this.addMarkersToMap(issueDto.getIssue(), markers);
        }
        return new StrictPair((Object)errors.getCount(), (Object)warnings.getCount());
    }

    private IMarker addProblemMarkerForCyclicElement(TFile cyclicElement, AbstractIssueDto issueDto, Counter errors, Counter warnings) {
        assert (cyclicElement != null) : "Parameter 'cyclicElement' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (issueDto != null) : "Parameter 'issue' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (errors != null) : "Parameter 'errors' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (warnings != null) : "Parameter 'warnings' of method 'addProblemMarkerForCyclicElement' must not be null";
        boolean isDiff = issueDto instanceof AbstractIssueDiffDto;
        Optional<IFile> locationForFile = EclipseWorkspaceUtils.getLocationForFile(cyclicElement);
        if (!locationForFile.isPresent()) {
            return null;
        }
        IResource resource = (IResource)locationForFile.get();
        if (isDiff) {
            CycleGroupIssueDiffDto diffDto = (CycleGroupIssueDiffDto)issueDto;
            IDiffElement.Change change = diffDto.getChange(cyclicElement);
            if (change != IDiffElement.Change.REMOVED && change != IDiffElement.Change.RESOLUTION_ADDED) {
                String issueDescription = issueDto.getIssueDescription(cyclicElement);
                Severity severity = change == IDiffElement.Change.UNMODIFIED ? Severity.INFO : issueDto.getSeverity();
                IMarker cylicElementMarker = this.addProblemMarkerForCyclicElement(resource, issueDto, issueDescription, severity, errors, warnings);
                return cylicElementMarker;
            }
        } else {
            String issueDescription = issueDto.getIssueDescription(cyclicElement);
            Severity severity = issueDto.getSeverity();
            IMarker cylicElementMarker = this.addProblemMarkerForCyclicElement(resource, issueDto, issueDescription, severity, errors, warnings);
            return cylicElementMarker;
        }
        return null;
    }

    private IMarker addProblemMarkerForCyclicElement(IResource resource, AbstractIssueDto issueDto, String issueDescription, Severity severity, Counter errors, Counter warnings) {
        assert (resource != null) : "Parameter 'resource' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (issueDto != null) : "Parameter 'issue' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (errors != null) : "Parameter 'errors' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (warnings != null) : "Parameter 'warnings' of method 'addProblemMarkerForCyclicElement' must not be null";
        int severityCode = this.convertSeverity(severity);
        try {
            IMarker marker = this.createProblemMarkerType(resource, issueDto);
            marker.setAttribute("message", (Object)issueDescription);
            marker.setAttribute("severity", severityCode);
            marker.setAttribute("lineNumber", 1);
            if (!this.excludeIssueFromCount(issueDto)) {
                if (severityCode == 2) {
                    errors.increment();
                } else if (severityCode == 1) {
                    warnings.increment();
                }
            }
            return marker;
        }
        catch (CoreException e) {
            LOGGER.error("Failed to create marker for resource " + String.valueOf(resource.getFullPath()), (Throwable)e);
            return null;
        }
    }

    protected int createMarkersForResolutions(IProgressMonitor monitor, List<ResolutionDto> resolutions) {
        assert (monitor != null) : "Parameter 'monitor' of method 'createMarkersForTasks' must not be null";
        int markerCount = 0;
        int resolutionCount = 0;
        for (ResolutionDto resolutionDto : resolutions) {
            ++resolutionCount;
            if (monitor.isCanceled()) {
                return markerCount;
            }
            for (AbstractIssueDto issueDto : resolutionDto.getAssociatedIssues()) {
                IMarker marker;
                Issue issue = issueDto.getIssue();
                if (!issue.isValid() || issue.getResolution() == null || issue.getResolution() != resolutionDto.getResolution()) continue;
                ArrayList<IMarker> markers = new ArrayList<IMarker>();
                if (issueDto.getId().getCategory() == IssueCategory.CYCLE_GROUP && issueDto.getId() != CoreIssueId.COMPONENT_CYCLE_GROUP) {
                    CycleGroupIssueDto cycleGroupIssue = (CycleGroupIssueDto)issueDto;
                    marker = this.addTaskMarker(cycleGroupIssue.getResourceInfo().getResource(), resolutionDto, cycleGroupIssue);
                    if (marker == null) continue;
                    markers.add(marker);
                    ++markerCount;
                    this.addMarkersToMap(issue, markers);
                    continue;
                }
                if (issueDto.getId() == CoreIssueId.DUPLICATE_CODE_BLOCK) {
                    DuplicateIssueDto duplicate = (DuplicateIssueDto)issueDto;
                    for (DuplicateCodeBlockOccurrenceDto occurrence : duplicate.getOccurrences()) {
                        IMarker marker2 = this.addTaskMarkerForDuplicate(resolutionDto, duplicate, occurrence, resolutionCount);
                        if (marker2 == null) continue;
                        markers.add(marker2);
                        ++markerCount;
                    }
                    this.addMarkersToMap(duplicate.getIssue(), markers);
                    continue;
                }
                Collection<TFile> physicalSourceFiles = issueDto.getAffectedPhysicalSourceFiles();
                if (!physicalSourceFiles.isEmpty()) {
                    for (TFile sourceFile : physicalSourceFiles) {
                        IMarker marker3;
                        if (sourceFile == null) {
                            LOGGER.error("Received 'null' instead of source file for issue '{}'", (Object)issueDto.getDebugInfo());
                            continue;
                        }
                        assert (sourceFile != null) : "source file received must not be null";
                        Optional<IFile> eclipseSourceFile = EclipseWorkspaceUtils.getLocationForFile(sourceFile);
                        if (!eclipseSourceFile.isPresent() || (marker3 = this.addTaskMarker((IResource)eclipseSourceFile.get(), resolutionDto, issueDto)) == null) continue;
                        ++markerCount;
                        markers.add(marker3);
                    }
                } else {
                    marker = this.addTaskMarker(issueDto.getResourceInfo().getResource(), resolutionDto, issueDto);
                    if (marker != null) {
                        ++markerCount;
                        markers.add(marker);
                    }
                }
                this.addMarkersToMap(issue, markers);
            }
        }
        return markerCount;
    }

    private void addMarkersToMap(Issue issue, List<IMarker> markers) {
        assert (issue != null) : "Parameter 'issue' of method 'addMarkersToMap' must not be null";
        assert (markers != null) : "Parameter 'markers' of method 'addMarkersToMap' must not be null";
        List<IMarker> previous = this.m_issueToMarkerMap.added(issue, markers);
        if (previous != null) {
            LOGGER.warn("Deleting {} previous markers for issue {} that should not exist", (Object)previous.size(), (Object)issue);
            previous.forEach(m -> {
                try {
                    m.delete();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            });
        }
    }

    private IMarker addTaskMarker(IResource resource, ResolutionDto resolution, AbstractIssueDto issue) {
        assert (resource != null) : "Parameter 'resource' of method 'addTaskMarker' must not be null";
        assert (resolution != null) : "Parameter 'resolution' of method 'addTaskMarker' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'addTaskMarker' must not be null";
        int priority = this.convertPriority(resolution.getPriority());
        StringBuilder description = new StringBuilder();
        description.append(this.createDescriptionForTask(resolution, issue, true));
        int lineNumber = issue.getLineNumber();
        try {
            IMarker marker = this.createTaskMarkerType(resource, resolution.getKind(), issue);
            marker.setAttribute("message", (Object)description.toString());
            marker.setAttribute("priority", priority);
            marker.setAttribute("issueId", (Object)issue.getId().getStandardName());
            if (resource instanceof IFile) {
                marker.setAttribute("lineNumber", lineNumber < 1 ? 1 : lineNumber);
            }
            return marker;
        }
        catch (CoreException e) {
            LOGGER.error("Failed to create marker for resource '{}'", (Object)resource.getFullPath());
            return null;
        }
    }

    private IMarker addTaskMarkerForDuplicate(ResolutionDto resolution, DuplicateIssueDto duplicate, DuplicateCodeBlockOccurrenceDto occurrence, int resolutionCount) {
        assert (resolution != null) : "Parameter 'resolution' of method 'addTaskMarker' must not be null";
        assert (duplicate != null) : "Parameter 'duplicate' of method 'addTaskMarkerForDuplicate' must not be null";
        assert (occurrence != null) : "Parameter 'occurrence' of method 'addTaskMarkerForDuplicate' must not be null";
        int priority = this.convertPriority(resolution.getPriority());
        StringBuilder description = new StringBuilder();
        description.append(resolutionCount).append(". ").append(this.createDescriptionForTask(resolution, duplicate, false)).append(", ").append(duplicate.getResourceInfo().getSonargraphElementName()).append(" ").append(occurrence.getPresentationName());
        try {
            Optional<IFile> fileOpt = EclipseWorkspaceUtils.getLocationForFile(occurrence.getSourceFile());
            if (fileOpt.isPresent()) {
                IMarker marker = this.createTaskMarkerType((IResource)fileOpt.get(), resolution.getKind(), duplicate);
                marker.setAttribute("message", (Object)description.toString());
                marker.setAttribute("priority", priority);
                marker.setAttribute("issueId", (Object)duplicate.getId().getStandardName());
                marker.setAttribute("lineNumber", occurrence.getStartLine());
                return marker;
            }
        }
        catch (CoreException e) {
            LOGGER.error("Failed to create marker for file '{}'", (Object)occurrence.getSourceFile().getAbsolutePath());
        }
        return null;
    }

    private String createDescriptionForTask(ResolutionDto resolutionDto, AbstractIssueDto issueDto, boolean addIssueDescription) {
        assert (resolutionDto != null) : "Parameter 'resolution' of method 'createDescriptionForTask' must not be null";
        assert (issueDto != null) : "Parameter 'issue' of method 'createDescriptionForTask' must not be null";
        StringBuilder description = new StringBuilder();
        description.append(Iso8601DateFormat.formatDateAndTime((Date)resolutionDto.getResolution().getDate())).append(" ");
        if (resolutionDto.getChange() != null) {
            description.append("[").append(resolutionDto.getChange().getPresentationName()).append("] ");
        }
        description.append("[").append(resolutionDto.getKind().getPresentationName()).append("]");
        String assignee = resolutionDto.getAssignee();
        if (!assignee.trim().isEmpty()) {
            description.append(" [").append(resolutionDto.getAssignee()).append("]");
        }
        if (resolutionDto.getKind() == ResolutionKind.TODO) {
            description.append(" ").append(issueDto.getIssueDescription());
        } else {
            String desc = resolutionDto.getDescription();
            if (!desc.trim().isEmpty()) {
                description.append(" ").append(resolutionDto.getDescription());
            }
            if (addIssueDescription) {
                description.append(" ").append(issueDto.getIssueDescription());
            }
        }
        return description.toString();
    }

    private IMarker addProblemMarker(TFile sourceFile, IResource resource, AbstractIssueDto issueDto, Counter errors, Counter warnings) {
        assert (resource != null) : "Parameter 'resource' of method 'addProblemMarker' must not be null";
        assert (issueDto != null) : "Parameter 'issue' of method 'addProblemMarker' must not be null";
        assert (errors != null) : "Parameter 'errors' of method 'addProblemMarker' must not be null";
        assert (warnings != null) : "Parameter 'warnings' of method 'addProblemMarker' must not be null";
        int severity = this.convertSeverity(issueDto.getSeverity());
        try {
            IMarker marker = this.createProblemMarkerType(resource, issueDto);
            marker.setAttribute("message", (Object)(sourceFile == null ? issueDto.getIssueDescription() : issueDto.getIssueDescription(sourceFile)));
            marker.setAttribute("severity", severity);
            int lineNumber = issueDto.getLineNumber();
            if (lineNumber > 0) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            if (!this.excludeIssueFromCount(issueDto)) {
                if (severity == 2) {
                    errors.increment();
                } else if (severity == 1) {
                    warnings.increment();
                }
            }
            return marker;
        }
        catch (CoreException e) {
            LOGGER.error("Failed to create marker for resource " + String.valueOf(resource.getFullPath()), (Throwable)e);
            return null;
        }
    }

    protected boolean excludeIssueFromCount(AbstractIssueDto issueDto) {
        return false;
    }

    private IMarker addProblemMarkerForDuplicate(AbstractIssueDto duplicate, DuplicateCodeBlockOccurrenceDto occurrence, Counter errors, Counter warnings) {
        assert (duplicate != null) : "Parameter 'duplicate' of method 'addProblemMarkerForDuplicate' must not be null";
        assert (occurrence != null) : "Parameter 'occurrence' of method 'addProblemMarkerForDuplicate' must not be null";
        assert (errors != null) : "Parameter 'errors' of method 'addProblemMarkerForDuplicate' must not be null";
        assert (warnings != null) : "Parameter 'warnings' of method 'addProblemMarkerForDuplicate' must not be null";
        int severity = this.convertSeverity(duplicate.getSeverity());
        try {
            Optional<IFile> fileOpt = EclipseWorkspaceUtils.getLocationForFile(occurrence.getSourceFile());
            if (fileOpt.isPresent()) {
                IMarker marker = this.createProblemMarkerType((IResource)fileOpt.get(), duplicate);
                StringBuilder message = new StringBuilder();
                if (occurrence instanceof DuplicateCodeBlockOccurrenceDiffDto) {
                    DuplicateCodeBlockOccurrenceDiffDto diff = (DuplicateCodeBlockOccurrenceDiffDto)occurrence;
                    message.append("[").append(diff.getChange().getPresentationName()).append("] ");
                    message.append(duplicate.getResourceInfo().getSonargraphElementName());
                    message.append(" (");
                    if (diff.getChangeDescription() == null || diff.getChangeDescription().trim().length() == 0) {
                        message.append(diff.getPresentationName());
                    } else {
                        message.append(diff.getChangeDescription());
                    }
                    message.append(")");
                    if (diff.getChange() == IDiffElement.Change.UNMODIFIED) {
                        severity = 0;
                    }
                } else {
                    message.append(duplicate.getResourceInfo().getSonargraphElementName()).append(" (").append(occurrence.getPresentationName()).append(")");
                }
                marker.setAttribute("message", (Object)message.toString());
                marker.setAttribute("severity", severity);
                marker.setAttribute("lineNumber", occurrence.getStartLine());
                if (severity == 2) {
                    errors.increment();
                } else if (severity == 1) {
                    warnings.increment();
                }
                return marker;
            }
        }
        catch (CoreException e) {
            LOGGER.error("Failed to create marker for file '{}'", (Object)occurrence.getSourceFile().getAbsolutePath());
        }
        return null;
    }

    private IMarker createTaskMarkerType(IResource resource, ResolutionKind resolutionKind, AbstractIssueDto issue) throws CoreException {
        IMarker marker;
        assert (resource != null) : "Parameter 'resource' of method 'createMarkerType' must not be null";
        assert (resolutionKind != null) : "Parameter 'resolutionKind' of method 'createProblemMarkerType' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'createMarkerType' must not be null";
        IssueCategory category = issue.getId().getCategory();
        if (resolutionKind == ResolutionKind.REFACTORING) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.task.refactoring");
            marker.setAttribute("issueKey", (Object)(issue.getKey() + issue.getIssueDescription()));
        } else if (resolutionKind == ResolutionKind.FIX) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.task.fix");
        } else if (resolutionKind == ResolutionKind.TODO) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.task.todo");
        } else {
            LOGGER.error("Unsupported ResolutionKind '{}'. Using Todo marker type.", (Object)resolutionKind.getStandardName());
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.task.todo");
        }
        if (category == IssueCategory.CYCLE_GROUP) {
            marker.setAttribute("cycleName", (Object)issue.getResourceInfo().getSonargraphElementName());
        }
        return marker;
    }

    private IMarker createProblemMarkerType(IResource resource, AbstractIssueDto issue) throws CoreException {
        IMarker marker;
        assert (resource != null) : "Parameter 'resource' of method 'createMarkerType' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'createMarkerType' must not be null";
        IssueCategory category = issue.getId().getCategory();
        if (category == IssueCategory.DUPLICATE_CODE) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.duplicate");
        } else if (category == IssueCategory.ARCHITECTURE_VIOLATION) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.architecture");
        } else if (category == IssueCategory.SCRIPT_BASED) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.script");
        } else if (category == IssueCategory.THRESHOLD_VIOLATION) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.threshold");
        } else if (category == IssueCategory.CYCLE_GROUP) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.cycle");
            marker.setAttribute("cycleName", (Object)issue.getResourceInfo().getSonargraphElementName());
        } else {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.generic");
        }
        return marker;
    }

    protected abstract List<AbstractIssueDto> convertIssues(Collection<Issue> var1, IProgressMonitor var2);

    protected abstract List<ResolutionDto> convertResolutions(Collection<Issue> var1, IProgressMonitor var2);

    private static final class Counter {
        private int count = 0;

        private Counter() {
        }

        public void increment() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

