/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs.diff;

import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionWithResult;
import com.hello2morrow.sonargraph.core.command.system.diff.DeactivateBaselineCommand;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipseWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.JobsCommandResultConsumer;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;

public class DeactivateBaselineJob
extends AbstractSonargraphEclipseJob {
    private final ISonargraphEclipsePlugin m_plugin;

    public DeactivateBaselineJob(IEventBroker eventBroker, ISonargraphEclipsePlugin plugin) {
        super(eventBroker, plugin.getSoftwareSystemProvider(), "Deactivate Baseline", JobType.PROVIDES_PROGESS, 40);
        this.m_plugin = plugin;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        final OperationResult detachResult = new OperationResult("Deactivate baseline");
        DeactivateBaselineCommand command = new DeactivateBaselineCommand(this.getProvider(), new ICommandInteractionWithResult(){

            public void processResult(OperationResult result) {
                detachResult.addMessagesFrom(result);
            }
        });
        try {
            EclipseWorkerContext workerContext = new EclipseWorkerContext(monitor);
            JobsCommandResultConsumer consumer = new JobsCommandResultConsumer();
            command.runSynchronouslyAndConsumeDirectly((IWorkerContext)workerContext, (CommandResultConsumer)consumer);
            if (consumer.getException().isPresent()) {
                throw consumer.getException().get();
            }
            if (detachResult.isFailure()) {
                Status status = new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", detachResult.toString());
                return status;
            }
            Status status = new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "Successfully detached from system diff");
            return status;
        }
        finally {
            this.m_plugin.determineSystemDiffStatus();
        }
    }
}

