/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphDeltaVisitor;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.CheckRelevantDeltaVisitor;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import java.net.URI;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphResourceDeltaVisitor
extends AbstractSonargraphDeltaVisitor
implements IResourceDeltaVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphResourceDeltaVisitor.class);
    private final FileRegistry m_fileRegistry;
    private final IProgressMonitor m_monitor;
    private String m_currentRootAbsolutePath;

    public SonargraphResourceDeltaVisitor(ISoftwareSystemProvider systemProvider, FileRegistry fileRegistry, JavaModule module, IProgressMonitor monitor) {
        super(systemProvider, module);
        assert (fileRegistry != null) : "Parameter 'fileRegistry' of method 'SonargraphResourceDeltaVisitor' must not be null";
        this.m_fileRegistry = fileRegistry;
        this.m_monitor = monitor;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        assert (delta != null) : "Parameter 'delta' of method 'visit' must not be null";
        if (this.m_monitor.isCanceled()) {
            return false;
        }
        IResource resource = delta.getResource();
        if (resource.getLocation() == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resource '" + resource.toString() + "' has no location");
            }
            return true;
        }
        if (resource.getType() == 4) {
            return resource instanceof IProject;
        }
        if (resource.getType() == 2) {
            Optional<TFile> fileOpt = EclipseWorkspaceUtils.getFileOfResource(resource);
            if (!fileOpt.isPresent()) {
                return false;
            }
            String absolutePath = FileUtility.getIdentifyingPath((TFile)fileOpt.get());
            this.m_currentRootAbsolutePath = this.isRoot(absolutePath) ? absolutePath : null;
            return this.m_currentRootAbsolutePath != null || this.isParentOfRoots(absolutePath);
        }
        if (resource.getType() == 1) {
            if (this.m_currentRootAbsolutePath == null) {
                return false;
            }
            Optional<JavaFileType> fileTypeOpt = this.getFileType(resource);
            if (!fileTypeOpt.isPresent()) {
                return false;
            }
            JavaFileType fileType = fileTypeOpt.get();
            switch (delta.getKind()) {
                case 1: {
                    URI added = resource.getLocationURI();
                    if (added == null) break;
                    TFile file = new TFile(added);
                    if (file.exists()) {
                        RootDirectoryPath currentRoot = this.determineCurrentRoot(this.m_currentRootAbsolutePath, fileType);
                        if (currentRoot != null) {
                            this.getDelta().added(currentRoot, (IFileType)fileType, file);
                            break;
                        }
                        LOGGER.error("No sonargraph root directory found for: " + file.getAbsolutePath());
                        break;
                    }
                    LOGGER.warn("Added file not found for: " + FileUtility.getIdentifyingPath((TFile)file));
                    break;
                }
                case 2: {
                    URI removed = resource.getLocationURI();
                    if (removed == null) break;
                    String identifyingPathToBeRemoved = FileUtility.getIdentifyingPath((TFile)new TFile(removed));
                    FilePath toBeRemovedFilePath = this.m_fileRegistry.getFilePath(identifyingPathToBeRemoved);
                    if (toBeRemovedFilePath != null) {
                        if (toBeRemovedFilePath.isValid()) {
                            this.getDelta().deleted(toBeRemovedFilePath);
                            break;
                        }
                        LOGGER.warn("Deleted file not valid: " + identifyingPathToBeRemoved);
                        break;
                    }
                    LOGGER.warn("Deleted file not found for: " + identifyingPathToBeRemoved);
                    break;
                }
                case 4: {
                    if (CheckRelevantDeltaVisitor.isRelevantChange(delta)) {
                        URI modified = resource.getLocationURI();
                        if (modified == null) break;
                        TFile modifiedFile = new TFile(modified);
                        String identifyingPathToBeModified = FileUtility.getIdentifyingPath((TFile)modifiedFile);
                        FilePath toBeModifiedFilePath = this.m_fileRegistry.getFilePath(identifyingPathToBeModified);
                        if (toBeModifiedFilePath != null) {
                            if (toBeModifiedFilePath.isValid()) {
                                if (modifiedFile.exists()) {
                                    this.getDelta().modified(toBeModifiedFilePath);
                                    break;
                                }
                                this.getDelta().deleted(toBeModifiedFilePath);
                                break;
                            }
                            LOGGER.warn("Modified file not valid: " + identifyingPathToBeModified);
                            break;
                        }
                        LOGGER.warn("Modified file not found for: " + identifyingPathToBeModified);
                        break;
                    }
                    if (!LOGGER.isTraceEnabled()) break;
                    LOGGER.trace("Not a relevant change for {}", (Object)delta.getResource());
                }
            }
        }
        return false;
    }

    @Override
    public ModuleDelta finishDeltaCreation() {
        ModuleDelta delta = this.getDelta();
        delta.finishCreation();
        return delta;
    }
}

