/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.ElementMapper;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionChangedJob
extends AbstractSonargraphEclipseJob {
    private static final String FAMILY = "com.hello2morrow.sonargraph.ide.eclipse.jobs.selectionChanged";
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionChangedJob.class);
    private final ISonargraphEclipsePlugin m_plugin;
    private final Object m_element;
    private final IEclipseContext m_eclipseContext;

    public SelectionChangedJob(ISonargraphEclipsePlugin plugin, IEclipseContext eclipseContext, Object element) {
        super(plugin.getSoftwareSystemProvider(), "Selection Changed", JobType.BACKGROUND, 20);
        this.m_plugin = plugin;
        this.m_element = element;
        this.m_eclipseContext = eclipseContext;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        JavaModule namedElement;
        if (this.m_element instanceof IProject) {
            IJavaProject javaProject = EclipseWorkspaceUtils.getJavaProject((IProject)this.m_element);
            if (javaProject != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Single IJavaProject selected: {}", (Object)javaProject);
                }
                namedElement = ElementMapper.getSonargraphElement(javaProject, this.m_plugin);
            } else {
                namedElement = null;
            }
        } else if (this.m_element instanceof IJavaProject) {
            namedElement = ElementMapper.getSonargraphElement((IJavaProject)this.m_element, this.m_plugin);
        } else if (this.m_element instanceof IPackageFragmentRoot) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Single IPackageFragmentRoot selected: {}", this.m_element);
            }
            namedElement = ElementMapper.getSonargraphElement((IPackageFragmentRoot)this.m_element, this.m_plugin);
        } else if (this.m_element instanceof IJavaElement) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Single IJavaElement selected: {}", this.m_element);
            }
            namedElement = ElementMapper.getSonargraphElement((IJavaElement)this.m_element, this.m_plugin);
        } else {
            namedElement = null;
        }
        if (namedElement != null) {
            for (IWorkbenchView next : RcpUtility.getWorkbenchViews((IEclipseContext)this.m_eclipseContext)) {
                UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> SelectionChangedJob.lambda$0(next, (NamedElement)namedElement));
            }
        } else {
            UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> SelectionChangedJob.selectDefault(this.m_eclipseContext));
        }
        return Status.OK_STATUS;
    }

    public static void selectDefault(IEclipseContext eclipseContext) {
        List<Element> noSelection = Arrays.asList(new Element[1]);
        for (IWorkbenchView next : RcpUtility.getWorkbenchViews((IEclipseContext)eclipseContext)) {
            if (!next.isActive()) continue;
            next.viewSelectionChanged(null, noSelection);
        }
    }

    public static void cancelAll() {
        SelectionChangedJob.cancelAllByFamily(FAMILY);
    }

    @Override
    public boolean belongsTo(Object family) {
        return family instanceof SelectionChangedJob || super.belongsTo(family) || family == FAMILY;
    }

    private static /* synthetic */ void lambda$0(IWorkbenchView iWorkbenchView, NamedElement namedElement) {
        if (iWorkbenchView.isActive()) {
            iWorkbenchView.viewSelectionChanged(null, Arrays.asList(namedElement));
        }
    }
}

