/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.system.remoting.RemoteSelectionRequestCommand;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipseWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.ElementMapper;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectInSonargraphArchitectJob
extends AbstractSonargraphEclipseJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectInSonargraphArchitectJob.class);
    private final List<Object> m_elementsToSelect;
    private final ISonargraphEclipsePlugin m_plugin;

    public SelectInSonargraphArchitectJob(ISonargraphEclipsePlugin plugin, List<Object> elementsToSelect) {
        super(plugin.getSoftwareSystemProvider(), "Select In Sonargraph Architect", JobType.BACKGROUND, 10);
        assert (elementsToSelect != null && !elementsToSelect.isEmpty()) : "Parameter 'elementsToSelect' of method 'SelectInSonargraphArchitectJob' must not be empty";
        this.m_plugin = plugin;
        this.m_elementsToSelect = elementsToSelect;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        final List<NamedElement> elements = this.extractElements(this.m_elementsToSelect);
        if (elements.isEmpty()) {
            return new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", "Current selection does not include any Sonargraph elements.");
        }
        final OperationResult selectionResult = new OperationResult("Sending selection request to Sonargraph");
        RemoteSelectionRequestCommand command = new RemoteSelectionRequestCommand(this.getProvider(), new RemoteSelectionRequestCommand.IInteraction(){

            public boolean collect(RemoteSelectionRequestCommand.InteractionData data) {
                data.setElement(elements);
                return true;
            }

            public void processResult(OperationResult result) {
                selectionResult.addMessagesFrom(result);
            }
        });
        command.runSynchronously((IWorkerContext)new EclipseWorkerContext(monitor));
        if (selectionResult.containsWarning()) {
            String warnings = selectionResult.getWarningMessages().stream().collect(Collectors.joining("\n"));
            UserInterfaceAdapter.getInstance().process(selectionResult);
            return new Status(2, "com.hello2morrow.sonargraph.ide.eclipse", "Sonargraph application returned the following warnings for selection request: \n" + warnings);
        }
        if (selectionResult.isSuccess()) {
            return new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "Selection request was sent successfully to Sonargraph application.");
        }
        String errors = selectionResult.getErrorMessages().stream().collect(Collectors.joining("\n"));
        return new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", "Sending selection request to Sonargraph application failed: \n" + errors);
    }

    private List<NamedElement> extractElements(List<Object> elementsToSelect) {
        ArrayList<NamedElement> elements = new ArrayList<NamedElement>();
        for (Object next : elementsToSelect) {
            IJavaElement elementToMap = null;
            if (next instanceof IMarker) {
                IResource resource = ((IMarker)next).getResource();
                this.processResource(elements, resource);
                continue;
            }
            if (next instanceof IResource) {
                this.processResource(elements, (IResource)next);
                continue;
            }
            if (next instanceof IJavaProject) {
                JavaModule module = ElementMapper.getSonargraphElement((IJavaProject)next, this.m_plugin);
                if (module == null) continue;
                elements.add((NamedElement)module);
                continue;
            }
            elementToMap = ElementMapper.getEclipseElementFromSelection(next);
            if (elementToMap == null || !(elementToMap instanceof IJavaElement)) continue;
            IJavaElement javaElement = elementToMap;
            NamedElement namedElement = ElementMapper.getSonargraphElement(javaElement, this.m_plugin);
            if (namedElement != null) {
                if (namedElement.isValid()) {
                    elements.add(namedElement);
                    continue;
                }
                LOGGER.warn("Sonargraph element no longer valid: {}", (Object)javaElement.getPath());
                continue;
            }
            LOGGER.debug("Not a Sonargraph element: {}", (Object)javaElement.getPath());
        }
        return elements;
    }

    private void processResource(List<NamedElement> elements, IResource resource) {
        TFile file = EclipseWorkspaceUtils.getFileOfResource(resource).orElseGet(null);
        if (file != null) {
            FilePath filePath = this.m_plugin.getFileRegistry().getFilePath(FileUtility.getIdentifyingPath((TFile)file));
            if (filePath != null) {
                elements.add(this.getSourceFile((NamedElement)filePath));
            } else {
                LOGGER.debug("Not a Sonargraph file: {}", (Object)file.getNormalizedAbsolutePath());
            }
        } else {
            LOGGER.debug("Failed to determine file of resource: {}", (Object)resource.getRawLocation());
        }
    }

    private NamedElement getSourceFile(NamedElement element) {
        SourceFile sourceFile;
        assert (element != null) : "Parameter 'element' of method 'getSourceFile' must not be null";
        if (!(element instanceof SourceFile) && (sourceFile = (SourceFile)element.getParent(SourceFile.class, new Class[0])) != null) {
            return sourceFile;
        }
        return element;
    }
}

