/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.ClearSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.IDynamicSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.EclipseProjectFilesVisitor;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphCompleteModelModifyingJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.JobsCommandResultConsumer;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.RefreshSoftwareSystemTask;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseClassRootProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReparseSystemJob
extends AbstractSonargraphEclipseJob
implements ISonargraphCompleteModelModifyingJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReparseSystemJob.class);
    private static final String FAMILY = "com.hello2morrow.sonargraph.ide.eclipse.jobs.reparse";
    private final FileRegistry m_fileRegistry;

    public ReparseSystemJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, FileRegistry fileRegistry) {
        super(eventBroker, provider, "Clean and full refresh of the Sonargraph workspace", JobType.PROVIDES_PROGESS, 40);
        assert (fileRegistry != null) : "Parameter 'fileRegistry' of method 'FullSoftwareSystemRefreshJob' must not be null";
        this.m_fileRegistry = fileRegistry;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    static final IStatus executeFullRefresh(ISoftwareSystemProvider provider, FileRegistry registry, IProgressMonitor monitor) throws Exception {
        assert (provider != null) : "Parameter 'provider' of method 'executeFullRefresh' must not be null";
        assert (registry != null) : "Parameter 'registry' of method 'executeFullRefresh' must not be null";
        assert (monitor != null) : "Parameter 'monitor' of method 'run' must not be null";
        if (!provider.hasSoftwareSystem()) {
            return new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", "Full Refresh not possible without SoftwareSystem");
        }
        if (provider.getSoftwareSystem().isClearable()) {
            ClearSoftwareSystemCommand clear = new ClearSoftwareSystemCommand(provider, new ClearSoftwareSystemCommand.IClearSoftwareSystemInteraction(){

                public void processClearSoftwareSystemResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processClearSoftwareSystemResult' must not be null");
                    }
                }
            });
            JobsCommandResultConsumer consumer = new JobsCommandResultConsumer();
            clear.runSynchronouslyAndConsumeDirectly((IWorkerContext)DefaultWorkerContext.INSTANCE, (CommandResultConsumer)consumer);
            if (consumer.getException().isPresent()) {
                throw consumer.getException().get();
            }
            registry.clear();
        } else assert (registry.isEmpty()) : "File registry not empty: " + String.valueOf(registry);
        ArrayList<ModuleDelta> moduleDeltas = new ArrayList<ModuleDelta>();
        for (IProject project : EclipseWorkspaceUtils.getActiveSonargraphProjects()) {
            ModuleInfo projectInfo;
            if (monitor.isCanceled()) {
                LOGGER.debug("Cancelled full refresh!");
                return Status.CANCEL_STATUS;
            }
            if (!EclipseWorkspaceUtils.isSonargraphResource((IResource)project)) {
                LOGGER.debug("Project '{}' is not monitored by Sonargraph", (Object)project.getName());
                continue;
            }
            try {
                projectInfo = EclipseWorkspaceUtils.convertToModuleInfo(project);
            }
            catch (CoreException ex) {
                LOGGER.error("Failed to process project '{}'", (Object)project.getName(), (Object)ex);
                continue;
            }
            IDynamicSystemProvider assignmentProvider = (IDynamicSystemProvider)provider.getInstallation().getExtension(IDynamicSystemProvider.class);
            Optional moduleOpt = assignmentProvider.mapModule(projectInfo, (IDynamicSystemProvider.ISourceToClassRootProvider)new EclipseClassRootProvider(), provider.getSoftwareSystem());
            if (!moduleOpt.isPresent()) continue;
            ModuleInfo moduleInfo = (ModuleInfo)moduleOpt.get();
            JavaModule module = (JavaModule)((Workspace)provider.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new NameFilter(moduleInfo.getName()), JavaModule.class);
            if (module == null) {
                LOGGER.error("Failed to determine Sonargraph module '" + moduleInfo.getName() + "' for project '" + projectInfo.getName() + "'");
                continue;
            }
            EclipseProjectFilesVisitor visitor = new EclipseProjectFilesVisitor(provider, module, monitor);
            try {
                project.accept((IResourceVisitor)visitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ModuleDelta delta = visitor.finishDeltaCreation();
                if (delta.isEmpty()) continue;
                moduleDeltas.add(delta);
            }
            catch (CoreException ex) {
                LOGGER.error("Failed to determine files of project '{}'", (Object)project.getName(), (Object)ex);
            }
        }
        if (moduleDeltas.isEmpty()) {
            LOGGER.warn("No delta determined");
            return new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "No delta determined");
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        RefreshSoftwareSystemTask deltaRefresh = new RefreshSoftwareSystemTask(provider, registry, moduleDeltas);
        deltaRefresh.execute(monitor);
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        IStatus result = ReparseSystemJob.executeFullRefresh(this.getProvider(), this.m_fileRegistry, monitor);
        return result.isOK() ? this.statusOK("System reparse successful") : result;
    }

    public static boolean isRunning() {
        return Job.getJobManager().find((Object)FAMILY).length > 0;
    }

    public static void doCancel() {
        Job[] jobs;
        Job[] jobArray = jobs = Job.getJobManager().find((Object)FAMILY);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            job.cancel();
            ++n2;
        }
    }

    @Override
    public boolean belongsTo(Object family) {
        return family instanceof ReparseSystemJob || super.belongsTo(family) || family == FAMILY;
    }
}

