/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.model.system.IDynamicSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemInfoMessageCause;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphEclipsePluginTask;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseClassRootProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReloadSoftwareSystemTask
implements ISonargraphEclipsePluginTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadSoftwareSystemTask.class);
    private final TFile m_systemDirectory;
    private final ISoftwareSystemProvider m_provider;
    private SystemMappingInfo m_mappedInfo;
    private DynamicSystemInfo m_systemInfo;

    public ReloadSoftwareSystemTask(ISoftwareSystemProvider provider, TFile systemDirectory) {
        assert (provider != null) : "Parameter 'provider' of method 'ReloadSystemTask' must not be null";
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'ReloadSystemTask' must not be null";
        this.m_provider = provider;
        this.m_systemDirectory = systemDirectory;
    }

    @Override
    public OperationResult execute(IProgressMonitor monitor) throws CommandException {
        List<IProject> allJavaProjects = EclipseWorkspaceUtils.getJavaProjects();
        OperationResult result = new OperationResult("Load system info");
        if (!allJavaProjects.isEmpty()) {
            try {
                IDynamicSystemProvider dynamicSystemProvider = (IDynamicSystemProvider)this.m_provider.getInstallation().getExtension(IDynamicSystemProvider.class);
                OperationResultWithOutcome loadSystemInfoResult = dynamicSystemProvider.loadSystemInfo((IWorkerContext)DefaultWorkerContext.INSTANCE, this.m_systemDirectory);
                if (loadSystemInfoResult.isFailure()) {
                    return loadSystemInfoResult;
                }
                List<ModuleInfo> eclipseProjectModuleInfos = this.convertProjectsToModuleInfos(allJavaProjects);
                OperationResultWithOutcome mappingResult = dynamicSystemProvider.mapSystemInfo(this.m_provider, (DynamicSystemInfo)loadSystemInfoResult.getOutcome(), eclipseProjectModuleInfos, (IDynamicSystemProvider.ISourceToClassRootProvider)new EclipseClassRootProvider(), IDynamicSystemProvider.MappingType.MATCHED_ONLY);
                if (mappingResult.isSuccess()) {
                    this.m_mappedInfo = (SystemMappingInfo)mappingResult.getOutcome();
                    this.m_systemInfo = EclipseWorkspaceUtils.convertToDynamicInfo(this.m_mappedInfo);
                }
                result.addMessagesFrom((OperationResult)loadSystemInfoResult);
            }
            catch (CoreException ex) {
                String title = "Failed to determine Sonargraph projects in workspace";
                LOGGER.error("Failed to determine Sonargraph projects in workspace", (Throwable)ex);
                result.addError((OperationResult.IMessageCause)SystemInfoMessageCause.PROJECT_COULD_NOT_BE_MAPPED, (Throwable)ex);
            }
        } else {
            result.addError((OperationResult.IMessageCause)SystemInfoMessageCause.NO_MATCHING_MODULE_FOUND);
        }
        return result;
    }

    public SystemMappingInfo getMappedInfo() {
        return this.m_mappedInfo;
    }

    public DynamicSystemInfo getSystemInfo() {
        return this.m_systemInfo;
    }

    private List<ModuleInfo> convertProjectsToModuleInfos(List<IProject> eclipseProjects) throws CoreException {
        assert (eclipseProjects != null) : "Parameter 'eclipseProjects' of method 'convertProjectsToModuleInfos' must not be null";
        ArrayList<ModuleInfo> modules = new ArrayList<ModuleInfo>();
        for (IProject project : eclipseProjects) {
            modules.add(EclipseWorkspaceUtils.convertToModuleInfo(project));
        }
        return modules;
    }
}

