/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractOpenSoftwareSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphCompleteModelModifyingJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ReloadSoftwareSystemTask;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;

public class ReloadSoftwareSystemJob
extends AbstractOpenSoftwareSystemJob
implements ISonargraphCompleteModelModifyingJob {
    private final TFile m_systemDirectory;
    private final ISonargraphEclipsePlugin m_plugin;
    private final FileRegistry m_fileRegistry;

    public ReloadSoftwareSystemJob(IEventBroker eventBroker, ISonargraphEclipsePlugin plugin, ISoftwareSystemProvider provider, FileRegistry fileRegistry, TFile systemDir, JobType jobType) {
        super(eventBroker, provider, "Reload Sonargraph Software System", jobType, 40);
        assert (plugin != null) : "Parameter 'plugin' of method 'ReloadSoftwareSystemJob' must not be null";
        assert (fileRegistry != null) : "Parameter 'fileRegistry' of method 'ReloadSoftwareSystemJob' must not be null";
        assert (systemDir != null) : "Parameter 'systemDir' of method 'ReloadSoftwareSystemJob' must not be null";
        this.m_plugin = plugin;
        this.m_fileRegistry = fileRegistry;
        this.m_systemDirectory = systemDir;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.NONE;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        ReloadSoftwareSystemTask reloadTask = new ReloadSoftwareSystemTask(this.getProvider(), this.m_systemDirectory);
        try {
            OperationResult result = reloadTask.execute((IProgressMonitor)new NullProgressMonitor());
            if (result.isFailure()) {
                UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> UserInterfaceAdapter.getInstance().process(result));
                return Status.CANCEL_STATUS;
            }
        }
        catch (CommandException ex) {
            UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> UserInterfaceAdapter.getInstance().error("Failed to Load Sonargraph System", "Failed to map Sonargraph workspace to Eclipse projects.\nException: " + ex.getLocalizedMessage()));
            return Status.CANCEL_STATUS;
        }
        SystemMappingInfo systemMappingInfo = reloadTask.getMappedInfo();
        OperationResult addedNatures = EclipseWorkspaceUtils.addSonargraphNature(this.m_systemDirectory, systemMappingInfo);
        if (addedNatures.isFailure()) {
            UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> UserInterfaceAdapter.getInstance().process(addedNatures));
            return Status.CANCEL_STATUS;
        }
        this.m_plugin.setSystemMapping(systemMappingInfo);
        return this.openSoftwareSystem(monitor, this.m_systemDirectory, this.m_fileRegistry, reloadTask.getSystemInfo(), systemMappingInfo);
    }
}

