/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshSoftwareSystemParserModelWithDeltaCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipseWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphEclipsePluginTask;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.JobsCommandResultConsumer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RefreshSoftwareSystemTask
implements ISonargraphEclipsePluginTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshSoftwareSystemTask.class);
    private final ISoftwareSystemProvider m_provider;
    private final IFilePathListener m_filePathListener;
    private final List<ModuleDelta> m_moduleDeltas;

    public RefreshSoftwareSystemTask(ISoftwareSystemProvider provider, IFilePathListener filePathListener, List<ModuleDelta> moduleDeltas) {
        assert (provider != null) : "Parameter 'provider' of method 'SonargraphRefreshTask' must not be null";
        assert (filePathListener != null) : "Parameter 'filePathListener' of method 'RefreshSoftwareSystemTask' must not be null";
        assert (moduleDeltas != null) : "Parameter 'moduleDeltas' of method 'SonargraphRefreshTask' must not be null";
        assert (moduleDeltas.size() > 0) : "Parameter 'moduleDeltas' of method 'SonargraphRefreshTask' must not be empty";
        this.m_provider = provider;
        this.m_filePathListener = filePathListener;
        this.m_moduleDeltas = moduleDeltas;
        LOGGER.debug("Refresh system task created with " + moduleDeltas.size() + " delta(s):");
        for (ModuleDelta nextModuledelta : moduleDeltas) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(nextModuledelta.toString());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(nextModuledelta.toShortString());
            }
            assert (!nextModuledelta.isEmpty()) : "Module delta is empty: " + String.valueOf(nextModuledelta);
        }
    }

    @Override
    public OperationResult execute(IProgressMonitor monitor) throws CommandException {
        assert (monitor != null) : "Parameter 'monitor' of method 'deltaRefresh' must not be null";
        long start = System.currentTimeMillis();
        final OperationResult refreshResult = new OperationResult("Refresh Software System");
        RefreshSoftwareSystemParserModelWithDeltaCommand refresh = new RefreshSoftwareSystemParserModelWithDeltaCommand(this.m_provider, new RefreshSoftwareSystemParserModelWithDeltaCommand.IRefreshSoftwareSystemParserModelWithDeltaInteraction(){

            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                return true;
            }

            public boolean collect(RefreshSoftwareSystemParserModelWithDeltaCommand.RefreshSoftwareSystemParserModelWithDeltaData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.addModuleDeltas(RefreshSoftwareSystemTask.this.m_moduleDeltas);
                data.addOptions(new ISoftwareSystemProvider.RefreshOption[]{ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT});
                data.setListener(RefreshSoftwareSystemTask.this.m_filePathListener);
                return true;
            }

            public void processOpenResult(OperationResult result) {
                LOGGER.error("Not expected to be called: " + ExceptionUtility.collectFirstAndLast((Throwable)new Exception()));
            }

            public boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean hasUndoHistory) {
                LOGGER.error("Not expected to be called: " + ExceptionUtility.collectFirstAndLast((Throwable)new Exception()));
                return true;
            }

            public void processSaveResultDueToExternalFileChangesOnOpen(OperationResult saveResult) {
                LOGGER.error("Not expected to be called: " + ExceptionUtility.collectFirstAndLast((Throwable)new Exception()));
            }

            public boolean closeSoftwareSystem() {
                LOGGER.error("Not expected to be called: " + ExceptionUtility.collectFirstAndLast((Throwable)new Exception()));
                return false;
            }

            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                LOGGER.error("Not expected to be called: " + ExceptionUtility.collectFirstAndLast((Throwable)new Exception()));
                return true;
            }

            public boolean processSaveResult(OperationResult result) {
                LOGGER.error("Not expected to be called: " + ExceptionUtility.collectFirstAndLast((Throwable)new Exception()));
                return true;
            }

            public void processRefreshResult(OperationResult result) {
                refreshResult.addMessagesFrom(result);
            }
        });
        EclipseWorkerContext workerContext = new EclipseWorkerContext(monitor);
        JobsCommandResultConsumer consumer = new JobsCommandResultConsumer();
        refresh.runSynchronouslyAndConsumeDirectly((IWorkerContext)workerContext, (CommandResultConsumer)consumer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Needed {} ms to execute refresh containing {} module deltas.", (Object)(System.currentTimeMillis() - start), (Object)this.m_moduleDeltas.size());
        }
        if (consumer.getException().isPresent()) {
            throw consumer.getException().get();
        }
        if (refreshResult.isFailure()) {
            LOGGER.error("Failed to refresh system: " + refreshResult.toString());
            if (refreshResult.getErrorCauses().contains(SoftwareSystemMessageCause.USED_LANGUAGE_SIZE_IS_GREATER_THAN_LICENSED_LIMIT)) {
                UserInterfaceAdapter.getInstance().error("Suspending Sonargraph Monitoring", refreshResult.toString());
                CloseSoftwareSystemCommand close = new CloseSoftwareSystemCommand(this.m_provider, new CloseSoftwareSystemCommand.ICloseInteraction(){

                    public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                        if (!$assertionsDisabled && system == null) {
                            throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                        }
                        if (!$assertionsDisabled && toBeSaved == null) {
                            throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                        }
                        return Collections.emptyMap();
                    }

                    public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                        if (!$assertionsDisabled && data == null) {
                            throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                        }
                        return true;
                    }

                    public boolean closeSoftwareSystem() {
                        return true;
                    }
                });
                close.runSynchronously();
            } else {
                UserInterfaceAdapter.getInstance().process(refreshResult);
            }
            monitor.setCanceled(true);
        }
        return refreshResult;
    }
}

