/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.OpenSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemInfoMessageCause;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipseWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphEclipsePluginTask;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.JobsCommandResultConsumer;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

final class OpenSoftwareSystemTask
implements ISonargraphEclipsePluginTask {
    private final ISoftwareSystemProvider m_provider;
    private final TFile m_systemDirectory;
    private final DynamicSystemInfo m_dynamicSystem;
    private final SystemMappingInfo m_reducedMappingInfo;
    private final IFilePathListener m_filePathListener;

    public OpenSoftwareSystemTask(ISoftwareSystemProvider provider, IFilePathListener filePathListener, TFile systemDirectory, DynamicSystemInfo dynamicSystem, SystemMappingInfo reducedMappingInfo) {
        assert (provider != null) : "Parameter 'provider' of method 'OpenTask' must not be null";
        assert (filePathListener != null) : "Parameter 'filePathListener' of method 'OpenSoftwareSystemTask' must not be null";
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'OpenTask' must not be null";
        assert (dynamicSystem != null) : "Parameter 'dynamicSystem' of method 'OpenTask' must not be null";
        assert (reducedMappingInfo != null) : "Parameter 'reducedMappingInfo' of method 'OpenSoftwareSystemTask' must not be null";
        this.m_provider = provider;
        this.m_filePathListener = filePathListener;
        this.m_systemDirectory = systemDirectory;
        this.m_dynamicSystem = dynamicSystem;
        this.m_reducedMappingInfo = reducedMappingInfo;
    }

    @Override
    public OperationResult execute(IProgressMonitor monitor) throws CommandException {
        assert (monitor != null) : "Parameter 'monitor' of method 'execute' must not be null";
        EclipseWorkspaceUtils.clearSonargraphResourceProperties((IResource)ResourcesPlugin.getWorkspace().getRoot());
        final OperationResult openResult = new OperationResult("Opening system '" + this.m_dynamicSystem.getName() + "'");
        if (this.m_dynamicSystem.getModules().isEmpty()) {
            openResult.addWarning((OperationResult.IMessageCause)SystemInfoMessageCause.NO_MATCHING_MODULE_FOUND, "System does not contain any modules", new Object[0]);
            return openResult;
        }
        EclipseWorkspaceUtils.addSonargraphResourceProperty(this.m_reducedMappingInfo);
        AbstractOpenCommand.IOpenInteraction interaction = new AbstractOpenCommand.IOpenInteraction(){

            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            public boolean closeSoftwareSystem() {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Run CloseSoftwareSystemJob before opening a new system to ensure that all resource properties and markers are correctly cleared");
                }
                return true;
            }

            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                return true;
            }

            public boolean processSaveResult(OperationResult result) {
                return true;
            }

            public INavigationState getNavigationState() {
                return null;
            }

            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setLocation(OpenSoftwareSystemTask.this.m_systemDirectory);
                data.setDynamicSystemInfo(OpenSoftwareSystemTask.this.m_dynamicSystem);
                data.setFlags(EnumSet.of(ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT, ISoftwareSystemProvider.OpenOption.DISABLE_WORKSPACE_FILTER));
                data.setListener(OpenSoftwareSystemTask.this.m_filePathListener);
                return true;
            }

            public void processOpenResult(OperationResult result) {
                openResult.addMessagesFrom(result);
                openResult.setIsSuccess(result.isSuccess());
            }

            public boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean hasUndoHistory) {
                return false;
            }

            public void processSaveResultDueToExternalFileChangesOnOpen(OperationResult saveResult) {
            }
        };
        OpenSoftwareSystemCommand open = new OpenSoftwareSystemCommand(this.m_provider, interaction, false);
        JobsCommandResultConsumer consumer = new JobsCommandResultConsumer();
        open.runSynchronouslyAndConsumeDirectly((IWorkerContext)new EclipseWorkerContext(monitor), (CommandResultConsumer)consumer);
        if (consumer.getException().isPresent()) {
            throw consumer.getException().get();
        }
        if (openResult.isFailure() && !this.m_provider.hasSoftwareSystem()) {
            EclipseWorkspaceUtils.clearSonargraphResourceProperties((IResource)ResourcesPlugin.getWorkspace().getRoot());
        }
        return openResult;
    }
}

