/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipseWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphCompleteModelModifyingJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.JobsCommandResultConsumer;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ide.eclipse.view.EclipsePreferenceUtils;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloseSoftwareSystemJob
extends AbstractSonargraphEclipseJob
implements ISonargraphCompleteModelModifyingJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseSoftwareSystemJob.class);
    private String m_notification;

    public CloseSoftwareSystemJob(IEventBroker eventBroker, ISoftwareSystemProvider provider) {
        super(eventBroker, provider, "Close Software System", JobType.PROVIDES_PROGESS, 40);
    }

    public CloseSoftwareSystemJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, String notification) {
        super(eventBroker, provider, "Close Software System", JobType.PROVIDES_PROGESS, 40);
        assert (notification != null && notification.length() > 0) : "Parameter 'notification' of method 'CloseSoftwareSystemJob' must not be empty";
        this.m_notification = notification;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected ISonargraphStatusProvider.SonargraphStatus getJobStartedStatus() {
        return ISonargraphStatusProvider.SonargraphStatus.SUSPENDED;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws CommandException {
        if (!this.getProvider().hasSoftwareSystem()) {
            LOGGER.info("No software system available");
            return this.statusCancel("No software system available");
        }
        EclipsePreferenceUtils.storeLastUsedSystemInPreferences(((Files)this.getProvider().getSoftwareSystem().getUniqueExistingChild(Files.class)).getSystemDirectory().getFile().getNormalizedAbsolutePath());
        CloseSoftwareSystemCommand close = new CloseSoftwareSystemCommand(this.getProvider(), new CloseSoftwareSystemCommand.ICloseInteraction(){

            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setToBeSaved(Collections.emptyList());
                return true;
            }

            public boolean closeSoftwareSystem() {
                if (CloseSoftwareSystemJob.this.m_notification != null) {
                    UserInterfaceAdapter.getInstance().information("Suspending Sonargraph Analysis", CloseSoftwareSystemJob.this.m_notification);
                }
                return true;
            }
        });
        JobsCommandResultConsumer consumer = new JobsCommandResultConsumer();
        close.runSynchronouslyAndConsumeDirectly((IWorkerContext)new EclipseWorkerContext(monitor), (CommandResultConsumer)consumer);
        if (consumer.getException().isPresent()) {
            throw consumer.getException().get();
        }
        return this.statusOK("Software system closed successfully.");
    }
}

