/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.Counter;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.Mutex;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ui.progress.IProgressConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSonargraphEclipseJob
extends WorkspaceJob {
    private static final int COUNTER_MAX = 999;
    private static Counter s_counter = new Counter(999, Counter.Count.DOWN, 3);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSonargraphEclipseJob.class);
    private final ISoftwareSystemProvider m_provider;
    private IEventBroker m_eventBroker;

    private static String getPrefixedName(String name) {
        return s_counter.get() + " " + name;
    }

    protected abstract Precondition getPrecondition();

    protected static void cancelAllByFamily(String family) {
        Job[] jobs;
        assert (family != null && family.length() > 0) : "Parameter 'family' of method 'cancelAllByFamily' must not be empty";
        Job[] jobArray = jobs = Job.getJobManager().find((Object)family);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            job.cancel();
            ++n2;
        }
    }

    public static void cancelAllJobsByClass(Class<? extends AbstractSonargraphEclipseJob> jobClassToCancel) {
        Job[] jobArray = Job.getJobManager().find(null);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job nextJob = jobArray[n2];
            if (jobClassToCancel.isAssignableFrom(nextJob.getClass())) {
                boolean cancelled = nextJob.cancel();
                LOGGER.info("Cancelling job {} was successful? {}", (Object)nextJob, (Object)cancelled);
            }
            ++n2;
        }
    }

    public AbstractSonargraphEclipseJob(ISoftwareSystemProvider provider, String name, JobType jobType, int priority) {
        this(provider, name, jobType, priority, Scheduling.SEQUENTIALLY);
    }

    public AbstractSonargraphEclipseJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, String name, JobType jobType, int priority) {
        this(eventBroker, provider, name, jobType, priority, Scheduling.SEQUENTIALLY);
    }

    public AbstractSonargraphEclipseJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, String name, JobType jobType, int priority, Scheduling scheduling) {
        this(provider, name, jobType, priority, scheduling);
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'AbstractSonargraphEclipseJob' must not be null";
        this.m_eventBroker = eventBroker;
    }

    private AbstractSonargraphEclipseJob(ISoftwareSystemProvider provider, String name, JobType jobType, int priority, Scheduling scheduling) {
        super(AbstractSonargraphEclipseJob.isDebugMode() ? AbstractSonargraphEclipseJob.getPrefixedName(name) : name);
        assert (jobType != null) : "Parameter 'jobType' of method 'AbstractSonargraphEclipseJob' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'AbstractSonargraphEclipseJob' must not be null";
        assert (scheduling != null) : "Parameter 'scheduling' of method 'AbstractSonargraphEclipseJob' must not be null";
        this.m_provider = provider;
        JobType jobType2 = jobType = AbstractSonargraphEclipseJob.isDebugMode() ? JobType.PROVIDES_PROGESS : jobType;
        if (jobType == JobType.PROVIDES_PROGESS || priority == 40) {
            s_counter.step();
        }
        if (scheduling == Scheduling.SEQUENTIALLY) {
            this.setRule(Mutex.INSTANCE);
        }
        if (jobType == JobType.PROVIDES_PROGESS) {
            this.setUser(true);
        } else if (jobType == JobType.BACKGROUND) {
            this.setSystem(true);
        }
        this.setPriority(priority);
        if (AbstractSonargraphEclipseJob.isDebugMode()) {
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
        }
        if (this.hasResult()) {
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    AbstractSonargraphEclipseJob.this.showResult(event);
                }
            });
        }
    }

    public static boolean isDebugMode() {
        return LOGGER.isDebugEnabled();
    }

    public final IStatus runInWorkspace(IProgressMonitor monitor) {
        Status status;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing job '{}'", (Object)this.getName());
        }
        long start = System.currentTimeMillis();
        if (monitor.isCanceled()) {
            return new Status(8, "com.hello2morrow.sonargraph.ide.eclipse", "Cancelled");
        }
        if (this.getPrecondition() == Precondition.OPENED_SOFTWARE_SYSTEM && !this.m_provider.hasSoftwareSystem()) {
            return new Status(8, "com.hello2morrow.sonargraph.ide.eclipse", "Software System has been closed.");
        }
        ISonargraphStatusProvider.SonargraphStatus jobStartedStatus = this.getJobStartedStatus();
        try {
            Job pendingJob = null;
            for (Class<?> nextPendingJobClass : this.getJobClassesThatMakeThisObsolete()) {
                pendingJob = this.getPendingJobOfClass(nextPendingJobClass);
                if (pendingJob == null) continue;
                LOGGER.info("Cancelling job {} because of scheduled/running job {} which will make the result of this job obsolete", (Object)this, (Object)pendingJob);
                return new Status(8, "com.hello2morrow.sonargraph.ide.eclipse", "Cancelled, because result will be rendered obsolete by scheduled job " + String.valueOf(pendingJob));
            }
            if (monitor.isCanceled()) {
                status = new Status(8, "com.hello2morrow.sonargraph.ide.eclipse", "Cancelled");
            } else {
                if (jobStartedStatus != null && this.supportsSonargraphStatus()) {
                    this.postStatusEvent(jobStartedStatus);
                }
                status = this.runInWorkspaceInternal(monitor);
            }
        }
        catch (Exception ex) {
            status = new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", "Failed to execute job '" + this.getName() + "'", (Throwable)ex);
        }
        if (AbstractSonargraphEclipseJob.isDebugMode()) {
            long executionTime = System.currentTimeMillis() - start;
            LOGGER.debug("Needed {} ms to execute job '{}'", (Object)executionTime, (Object)this.getName());
            return this.appendExecutionTime((IStatus)status, executionTime);
        }
        if (!status.isOK()) {
            this.postStatusEvent(ISonargraphStatusProvider.SonargraphStatus.CANCELLED);
        }
        return status;
    }

    protected boolean supportsSonargraphStatus() {
        return true;
    }

    protected List<Class<?>> getJobClassesThatMakeThisObsolete() {
        return Collections.emptyList();
    }

    private Job getPendingJobOfClass(Class<?> jobClassToCheck) {
        Job[] jobArray = Job.getJobManager().find(null);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job nextJob = jobArray[n2];
            if (nextJob != this && jobClassToCheck.isAssignableFrom(nextJob.getClass())) {
                return nextJob;
            }
            ++n2;
        }
        return null;
    }

    protected ISonargraphStatusProvider.SonargraphStatus getJobStartedStatus() {
        return ISonargraphStatusProvider.SonargraphStatus.ANALYZING;
    }

    protected final void postStatusEvent(ISonargraphStatusProvider.SonargraphStatus status) {
        this.postStatusEvent(status, new HashMap<String, Object>());
    }

    protected final void postStatusEvent(ISonargraphStatusProvider.SonargraphStatus status, Map<String, Object> data) {
        assert (status != null) : "Parameter 'status' of method 'postStatusEvent' must not be null";
        assert (data != null) : "Parameter 'data' of method 'postStatusEvent' must not be null";
        if (this.m_eventBroker != null) {
            data.put(ISonargraphStatusProvider.Property.STATUS.name(), (Object)status);
            data.put(ISonargraphStatusProvider.Property.SENDER.name(), ((Object)((Object)this)).getClass().getSimpleName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Posting status: {}, sender: {}", (Object)status, (Object)((Object)((Object)this)).getClass().getSimpleName());
            }
            this.m_eventBroker.post(ISonargraphStatusProvider.Topic.SONARGRAPH_STATUS.getName(), data);
        }
    }

    private IStatus appendExecutionTime(IStatus status, long executionTime) {
        String newMessage = String.format("%s (took %d ms)", status.getMessage(), executionTime);
        Status newStatus = new Status(status.getSeverity(), status.getPlugin(), newMessage);
        return newStatus;
    }

    protected abstract IStatus runInWorkspaceInternal(IProgressMonitor var1) throws Exception;

    protected void showResult() {
    }

    protected boolean hasResult() {
        return false;
    }

    protected final ISoftwareSystemProvider getProvider() {
        return this.m_provider;
    }

    public boolean belongsTo(Object family) {
        return family == "com.hello2morrow.sonargraph.ide.eclipse.jobs";
    }

    private final void showResult(IJobChangeEvent event) {
        if (UserInterfaceAdapter.hasInstance()) {
            int severity = event.getResult().getSeverity();
            if (severity == 8) {
                return;
            }
            String name = event.getJob().getName();
            String message = event.getJob().getResult().getMessage();
            if (severity == 0 || severity == 1) {
                UserInterfaceAdapter.getInstance().information(name, message);
            } else if (severity == 2) {
                UserInterfaceAdapter.getInstance().warning(name, message);
            } else {
                UserInterfaceAdapter.getInstance().error(name, message);
            }
        }
    }

    protected IStatus statusCancel(String message) {
        assert (message != null) : "Parameter 'message' of method 'statusCancel' must not be null";
        return new Status(8, "com.hello2morrow.sonargraph.ide.eclipse", "Cancel " + message);
    }

    protected IStatus statusOK(String message) {
        assert (message != null) : "Parameter 'message' of method 'statusOK' must not be null";
        return new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "OK " + message);
    }

    public static class DebuggingJobChangeListener
    implements IJobChangeListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(DebuggingJobChangeListener.class);
        private final Job m_job;

        public DebuggingJobChangeListener(Job job) {
            this.m_job = job;
        }

        public void sleeping(IJobChangeEvent event) {
            LOGGER.debug("Sleeping [{}], currentJob: {}", (Object)this.m_job, (Object)Job.getJobManager().currentJob());
        }

        public void scheduled(IJobChangeEvent event) {
            LOGGER.debug("Scheduled [{}], currentJob: {}", (Object)this.m_job, (Object)Job.getJobManager().currentJob());
        }

        public void running(IJobChangeEvent event) {
            LOGGER.debug("Running: [{}]", (Object)this.m_job);
        }

        public void done(IJobChangeEvent event) {
            LOGGER.debug("Done: [{}], currentJob: {}", (Object)this.m_job, (Object)Job.getJobManager().currentJob());
        }

        public void awake(IJobChangeEvent event) {
            LOGGER.debug("Awake: [{}], currentJob: {}", (Object)this.m_job, (Object)Job.getJobManager().currentJob());
        }

        public void aboutToRun(IJobChangeEvent event) {
            LOGGER.debug("AboutToRun:[{}], currentJob: {}", (Object)this.m_job, (Object)Job.getJobManager().currentJob());
        }
    }

    protected static enum Precondition {
        OPENED_SOFTWARE_SYSTEM,
        NONE;

    }

    public static enum Scheduling {
        PARALLEL,
        SEQUENTIALLY;

    }
}

