/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSonargraphDeltaVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSonargraphDeltaVisitor.class);
    private final ISoftwareSystemProvider m_provider;
    private final Module m_module;
    private final Map<String, JavaClassRootDirectoryPath> m_classRoots;
    private final Map<String, JavaSourceRootDirectoryPath> m_sourceRoots;
    private final ModuleDelta m_delta;

    public AbstractSonargraphDeltaVisitor(ISoftwareSystemProvider provider, JavaModule module) {
        assert (provider != null) : "Parameter 'provider' of method 'AbstractSonargraphDeltaVisitor' must not be null";
        assert (module != null) : "Parameter 'module' of method 'AbstractSonargraphDeltaVisitor' must not be null";
        assert (provider.hasSoftwareSystem()) : "No system available";
        this.m_provider = provider;
        this.m_module = module;
        this.m_classRoots = this.m_module.getChildren((NamedElement.IFilter)new ActiveRootDirectoryFilter(), JavaClassRootDirectoryPath.class).stream().map(r -> (JavaClassRootDirectoryPath)r.getOriginal()).collect(Collectors.toMap(r -> FileUtility.getIdentifyingPath((TFile)r.getFile()), r -> r));
        this.m_sourceRoots = this.m_module.getChildren((NamedElement.IFilter)new ActiveRootDirectoryFilter(), JavaSourceRootDirectoryPath.class).stream().map(r -> (JavaSourceRootDirectoryPath)r.getOriginal()).collect(Collectors.toMap(r -> FileUtility.getIdentifyingPath((TFile)r.getFile()), r -> r));
        WorkspaceFilter filter = ((Workspace)this.m_provider.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getWorkspaceFilter();
        this.m_delta = new ModuleDelta(provider.getLanguageProvider(module.getLanguage()), (IWorkspaceFilter)filter, this.m_module);
    }

    protected final ISoftwareSystemProvider getProvider() {
        return this.m_provider;
    }

    protected final boolean isRoot(String absolutePath) {
        assert (absolutePath != null && absolutePath.length() > 0) : "Parameter 'absolutePath' of method 'determineCurrentRoot' must not be empty";
        for (Map.Entry<String, JavaClassRootDirectoryPath> entry : this.m_classRoots.entrySet()) {
            if (!absolutePath.equals(entry.getKey()) && !absolutePath.startsWith(entry.getKey() + "/")) continue;
            return true;
        }
        for (Map.Entry<String, JavaClassRootDirectoryPath> entry : this.m_sourceRoots.entrySet()) {
            if (!absolutePath.equals(entry.getKey()) && !absolutePath.startsWith(entry.getKey() + "/")) continue;
            return true;
        }
        return false;
    }

    protected final RootDirectoryPath determineCurrentRoot(String absolutePath, JavaFileType type) {
        assert (absolutePath != null && absolutePath.length() > 0) : "Parameter 'absolutePath' of method 'determineCurrentRoot' must not be empty";
        assert (type != null) : "Parameter 'type' of method 'determineCurrentRoot' must not be null";
        if (JavaFileType.CLASS_FILE.equals((Object)type)) {
            for (Map.Entry<String, JavaClassRootDirectoryPath> root : this.m_classRoots.entrySet()) {
                if (!absolutePath.equals(root.getKey()) && !absolutePath.startsWith(root.getKey() + "/")) continue;
                return (RootDirectoryPath)root.getValue();
            }
        } else {
            for (Map.Entry<String, JavaSourceRootDirectoryPath> root : this.m_sourceRoots.entrySet()) {
                if (!absolutePath.equals(root.getKey()) && !absolutePath.startsWith(root.getKey() + "/")) continue;
                return (RootDirectoryPath)root.getValue();
            }
        }
        return null;
    }

    protected final boolean isParentOfRoots(String absolutePath) {
        assert (absolutePath != null && absolutePath.length() > 0) : "Parameter 'absolutePath' of method 'isParentOfRoots' must not be empty";
        boolean isSourceRoot = this.m_sourceRoots.keySet().stream().anyMatch(root -> root.startsWith(absolutePath));
        if (isSourceRoot) {
            return true;
        }
        return this.m_classRoots.keySet().stream().anyMatch(root -> root.startsWith(absolutePath));
    }

    abstract ModuleDelta finishDeltaCreation();

    protected final Module getModule() {
        return this.m_module;
    }

    protected final ModuleDelta getDelta() {
        return this.m_delta;
    }

    protected final Optional<JavaFileType> getFileType(IResource resource) {
        assert (resource != null) : "Parameter 'resource' of method 'getFileType' must not be null";
        String fileExtension = "." + resource.getFileExtension();
        JavaFileType fileType = JavaFileType.determine((String)fileExtension);
        if (fileType == null && LOGGER.isTraceEnabled()) {
            LOGGER.trace("Skipping file " + String.valueOf(resource.getLocationURI()) + ", unsupported extension '" + fileExtension + "'");
        }
        return Optional.ofNullable(fileType);
    }

    private static final class ActiveRootDirectoryFilter
    implements NamedElement.IFilter {
        private ActiveRootDirectoryFilter() {
        }

        public boolean accept(NamedElement namedElement) {
            if (!(namedElement instanceof RootDirectoryPath)) {
                return false;
            }
            RootDirectoryPath root = (RootDirectoryPath)namedElement;
            return root.isEnabled();
        }
    }
}

