/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.foundation.common;

import com.hello2morrow.sonargraph.foundation.activity.Activity;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.WorkerContext;
import org.eclipse.core.runtime.IProgressMonitor;

public final class EclipseWorkerContext
extends WorkerContext {
    private static final String RUNNING = "...";
    private final IProgressMonitor m_monitor;
    private int m_currentWorked;

    public EclipseWorkerContext(IProgressMonitor monitor) {
        assert (monitor != null) : "Parameter 'monitor' of method 'EclipseWorkerContext' must not be null";
        this.m_monitor = monitor;
    }

    private void reset() {
        try {
            this.m_monitor.done();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_currentWorked = 0;
    }

    protected void activityUpdated(Activity activity) {
        block16: {
            assert (activity != null) : "Parameter 'activity' of method 'activityUpdated' must not be null";
            if (activity.isRunning()) {
                if (activity.hasJustBeenStarted()) {
                    try {
                        if (activity.providesProgress()) {
                            this.m_monitor.beginTask(activity.getCurrentMessage(), activity.getTotal());
                            break block16;
                        }
                        this.m_monitor.beginTask(activity.getCurrentMessage(), -1);
                    }
                    catch (Exception exception) {}
                } else {
                    boolean isCanceled = false;
                    ActivityMode activityMode = activity.getMode();
                    if (activityMode == ActivityMode.MODAL_CANCELABLE) {
                        try {
                            isCanceled = this.m_monitor.isCanceled();
                        }
                        catch (Exception e) {
                            isCanceled = true;
                        }
                    }
                    if (isCanceled) {
                        this.reset();
                        this.cancel();
                    } else {
                        int workIncrement = activity.getWorkedInPercent() - this.m_currentWorked;
                        try {
                            this.m_monitor.worked(workIncrement);
                            this.m_currentWorked = activity.getWorkedInPercent();
                            if (activity.isMainStep()) {
                                this.m_monitor.setTaskName("");
                                this.m_monitor.subTask(activity.getCurrentMessage() + RUNNING);
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                this.reset();
            }
        }
    }
}

