/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler.remoting;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.MPartUtility;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.SelectInSonargraphArchitectJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import jakarta.inject.Named;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SendSelectRequestToStandaloneHandler
extends CommandHandlerWithCorrespondingCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendSelectRequestToStandaloneHandler.class);

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.REQUEST_SELECTION_IN_STANDALONE;
    }

    @Execute
    public Object execute(ISonargraphEclipsePlugin plugin, @Named(value="org.eclipse.ui.selection") @Optional Object selection, @Named(value="e4ActivePart") MPart part) {
        assert (plugin != null) : "Parameter 'plugin' of method 'execute' must not be null";
        if (selection == null) {
            UserInterfaceAdapter.getInstance().information("Missing Selection", "Nothing selected, not sending any request to Sonargraph");
            return null;
        }
        LOGGER.debug("--------- Selection ----- ");
        ArrayList<Object> selected = new ArrayList<Object>();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            if (structuredSelection.isEmpty()) {
                UserInterfaceAdapter.getInstance().information("Missing Selection", "Nothing selected, not sending any request to Sonargraph");
                return null;
            }
            for (Object next : structuredSelection.toList()) {
                LOGGER.debug("Selected: " + next.getClass().getCanonicalName());
                IMarker marker = this.getMarker(next);
                if (marker != null) {
                    selected.add(marker);
                    continue;
                }
                selected.add(next);
            }
        } else if (selection instanceof TextSelection) {
            Object select = MPartUtility.getJavaFileOfEditor(part);
            if (select != null) {
                selected.add(select);
            } else {
                LOGGER.warn("Unhandled selection: " + selection.getClass().getCanonicalName());
            }
        } else {
            LOGGER.warn("Unhandled selection: " + selection.getClass().getCanonicalName());
        }
        if (selected.isEmpty()) {
            UserInterfaceAdapter.getInstance().information("Missing Selection", "Selected elements are not suitable for sending request to Sonargraph.");
            return null;
        }
        SelectInSonargraphArchitectJob job = new SelectInSonargraphArchitectJob(plugin, selected);
        job.schedule();
        return null;
    }

    private IMarker getMarker(Object object) {
        IMarker marker;
        assert (object != null) : "Parameter 'object' of method 'isMarker' must not be null";
        if (object instanceof IAdaptable && (marker = (IMarker)((IAdaptable)object).getAdapter(IMarker.class)) != null) {
            return marker;
        }
        return null;
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin, @Optional SonargraphLicenseHandler licenseHandler) {
        return plugin != null && plugin.getSoftwareSystemProvider() != null && plugin.getSoftwareSystemProvider().hasSoftwareSystem() && plugin.getSoftwareSystemProvider().getSoftwareSystem().getState() == SoftwareSystemState.MODEL_LOADED;
    }
}

