/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler;

import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.view.EclipsePreferenceUtils;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class SuspendResumeSonargraphAnalysisHandler
extends CommandHandler {
    private static final String ICON_URI_SUSPEND = "platform:/plugin/com.hello2morrow.sonargraph.ide.eclipse/images/Suspend.gif";
    private static final String ICON_URI_RESUME = "platform:/plugin/com.hello2morrow.sonargraph.ide.eclipse/images/Resume.gif";

    @Execute
    public void execute(MMenuItem menuItem, ISonargraphEclipsePlugin plugin) {
        ISonargraphEclipsePlugin.AnalysisStatus newStatus = plugin.getSoftwareSystemProvider().hasSoftwareSystem() ? ISonargraphEclipsePlugin.AnalysisStatus.SUSPENDED : ISonargraphEclipsePlugin.AnalysisStatus.ACTIVE;
        plugin.updateSonargraphAnalysisStatus(newStatus);
        SuspendResumeSonargraphAnalysisHandler.updateMenuItem(menuItem, plugin);
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin, @Optional MMenuItem menuItem) {
        if (plugin == null) {
            return false;
        }
        if (menuItem != null) {
            SuspendResumeSonargraphAnalysisHandler.updateMenuItem(menuItem, plugin);
        }
        return plugin.isInitialized() && !EclipseWorkspaceUtils.getJavaWorkspaceProjectsAsModuleInfos().isEmpty() && (plugin.getSoftwareSystemProvider().hasSoftwareSystem() || EclipsePreferenceUtils.getLastUsedSoftwareSystemPath() != null);
    }

    private static void updateMenuItem(MMenuItem menuItem, ISonargraphEclipsePlugin plugin) {
        if (plugin == null || !plugin.isInitialized()) {
            return;
        }
        boolean isSuspend = plugin.getSoftwareSystemProvider().hasSoftwareSystem();
        if (isSuspend) {
            menuItem.setLabel("Suspend Analysis");
            menuItem.setIconURI(ICON_URI_SUSPEND);
        } else {
            menuItem.setLabel("Resume Analysis");
            menuItem.setIconURI(ICON_URI_RESUME);
        }
    }
}

