/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler;

import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphStatusHandler
extends CommandHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphStatusHandler.class);

    @Execute
    public void execute(MHandledToolItem toolItem, ISonargraphEclipsePlugin plugin, @Named(value="activeShell") Shell shell) {
        if (UserInterfaceAdapter.hasInstance()) {
            UserInterfaceAdapter.getInstance().information("Sonargraph Status", "The toolbar icon only signals the current state of the Sonargraph analysis and is not actionable.\nAdditional info is provided by its tooltip, currently \"" + toolItem.getTooltip() + "\"");
        }
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin, @Optional MHandledToolItem toolItem, ISonargraphStatusProvider statusProvider) {
        if (plugin == null) {
            return false;
        }
        Pair<ISonargraphStatusProvider.SonargraphStatus, StrictPair<Integer, Integer>> statusInfo = statusProvider.getStatus();
        ISonargraphStatusProvider.SonargraphStatus status = (ISonargraphStatusProvider.SonargraphStatus)((Object)statusInfo.getFirst());
        StrictPair errorsWarningsPair = (StrictPair)statusInfo.getSecond();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Status: {}", (Object)status.name());
        }
        if (toolItem != null) {
            SonargraphStatusHandler.updateToolItem(toolItem, status, (StrictPair<Integer, Integer>)errorsWarningsPair);
            return true;
        }
        return false;
    }

    private static void updateToolItem(MHandledToolItem toolItem, ISonargraphStatusProvider.SonargraphStatus status, StrictPair<Integer, Integer> errorsWarningsPair) {
        assert (toolItem != null) : "Parameter 'toolItem' of method 'updateToolItem' must not be null";
        assert (status != null) : "Parameter 'status' of method 'updateToolItem' must not be null";
        StringBuilder tooltip = new StringBuilder(status.getTooltip());
        if (errorsWarningsPair != null) {
            int errors = (Integer)errorsWarningsPair.getFirst();
            int warnings = (Integer)errorsWarningsPair.getSecond();
            if (errors > 0 || warnings > 0) {
                tooltip.append(" [");
            }
            if (errors > 0) {
                tooltip.append(errors).append(" Errors");
            }
            if (warnings > 0) {
                if (errors > 0) {
                    tooltip.append(", ");
                }
                tooltip.append(warnings).append(" Warnings");
            }
            if (errors > 0 || warnings > 0) {
                tooltip.append("]");
            }
        }
        toolItem.setTooltip(tooltip.toString());
        if (!status.getIconUri().isEmpty() && !toolItem.getIconURI().equals(status.getIconUri())) {
            toolItem.setIconURI(status.getIconUri());
        }
    }
}

