/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler;

import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.RefreshSystemFilesJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ReparseSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import java.util.Optional;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;

public class RefreshSystemFilesHandler
extends CommandHandler {
    @Execute
    public void execute(IEventBroker eventBroker, final ISonargraphEclipsePlugin plugin) {
        final RefreshSystemFilesJob refreshJob = new RefreshSystemFilesJob(eventBroker, plugin.getSoftwareSystemProvider(), plugin);
        refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Optional<ModifiableFileDelta> delta = refreshJob.getSystemFilesDelta();
                if (!delta.isPresent() || delta.get().isEmpty()) {
                    if (plugin.isSystemDiffActive()) {
                        plugin.getMarkerProvider().refreshForSystemDiff(plugin.getSoftwareSystemProvider(), plugin.getEventBroker());
                    } else {
                        plugin.getMarkerProvider().refresh(plugin.getSoftwareSystemProvider(), plugin.getEventBroker());
                    }
                }
            }
        });
        refreshJob.schedule();
    }

    @CanExecute
    public boolean canExecute(@org.eclipse.e4.core.di.annotations.Optional ISonargraphEclipsePlugin plugin) {
        if (plugin == null) {
            return false;
        }
        return plugin.isInitialized() && plugin.getSoftwareSystemProvider().hasSoftwareSystem() && !RefreshSystemFilesJob.isRunning() && !ReparseSystemJob.isRunning();
    }
}

