/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler;

import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.CloseSoftwareSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.OpenSoftwareSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ReparseSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.view.OpenSonargraphSystemDialog;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Shell;

public final class OpenSonargraphSystemHandler
extends CommandHandler {
    @Execute
    public void execute(IEventBroker eventBroker, ISonargraphEclipsePlugin plugin, @Named(value="activeShell") Shell shell) {
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'execute' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'execute' must not be null";
        assert (shell != null) : "Parameter 'shell' of method 'execute' must not be null";
        List<ModuleInfo> workspaceProjects = EclipseWorkspaceUtils.getJavaWorkspaceProjectsAsModuleInfos();
        if (workspaceProjects.isEmpty()) {
            UserInterfaceAdapter.getInstance().warning("Empty Workspace", "Sonargraph system assignment requires existing projects in the Eclipse workspace.");
            return;
        }
        ISoftwareSystemProvider provider = plugin.getSoftwareSystemProvider();
        TFile currentSystemDirectory = provider.hasSoftwareSystem() ? ((Files)provider.getSoftwareSystem().getUniqueExistingChild(Files.class)).getSystemDirectory().getFile() : null;
        OpenSonargraphSystemDialog dialog = new OpenSonargraphSystemDialog(shell, workspaceProjects, SoftwareSystemDirectory.getValidator(), provider, currentSystemDirectory);
        if (dialog.open() != 0) {
            return;
        }
        boolean sameSystem = FileUtility.areEqual((TFile)currentSystemDirectory, (TFile)dialog.getSystemDirectory());
        if (sameSystem) {
            if (UserInterfaceAdapter.getInstance().question("Do you want to reload the currently opened system?", false) != UserInterfaceAdapter.Feedback.CONFIRMED) {
                return;
            }
        } else if (provider.hasSoftwareSystem()) {
            boolean close;
            boolean bl = close = UserInterfaceAdapter.getInstance().question("Do you want to close the currently opened system?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
            if (!close) {
                return;
            }
        }
        if (provider.hasSoftwareSystem()) {
            ReparseSystemJob.doCancel();
            CloseSoftwareSystemJob closeJob = new CloseSoftwareSystemJob(eventBroker, provider);
            closeJob.schedule();
        }
        SystemMappingInfo systemMappingInfo = dialog.getSystemMappingInfo();
        DynamicSystemInfo dynamicSystem = EclipseWorkspaceUtils.convertToDynamicInfo(systemMappingInfo);
        SystemMappingInfo reducedMappingInfo = EclipseWorkspaceUtils.reduceSystemMappingInfo(systemMappingInfo);
        OperationResult addedNatures = EclipseWorkspaceUtils.addSonargraphNature(dialog.getSystemDirectory(), reducedMappingInfo);
        if (addedNatures.isFailure()) {
            UserInterfaceAdapter.getInstance().process(addedNatures);
        } else {
            plugin.setSystemMapping(reducedMappingInfo);
            OpenSoftwareSystemJob openJob = new OpenSoftwareSystemJob(eventBroker, provider, plugin.getFileRegistry(), dialog.getSystemDirectory(), dynamicSystem, reducedMappingInfo, JobType.PROVIDES_PROGESS);
            openJob.schedule();
        }
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin) {
        if (plugin == null) {
            return false;
        }
        return plugin.isInitialized();
    }
}

