/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.EclipsePluginProxySettingsProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.view.EclipsePreferenceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.view.SonargraphEclipseDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionDialog;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import com.hello2morrow.sonargraph.ui.swt.license.LicenseDialog;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManageLicenseHandler
extends CommandHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageLicenseHandler.class);

    @Execute
    public Object execute(ISonargraphEclipsePlugin plugin, SonargraphLicenseHandler licenseHandler, @Named(value="activeShell") Shell shell) {
        ISonargraphEclipsePlugin.StartupOption option;
        EclipsePluginProxySettingsProvider proxySettingsProvider = new EclipsePluginProxySettingsProvider(SonargraphLicenseHandler.getHosts());
        ConnectionMode connectionMode = ConnectionDialog.getConnectionMode((IProxySettingsProvider)proxySettingsProvider);
        ISoftwareSystemProvider systemProvider = plugin.getSoftwareSystemProvider();
        boolean validLicenseBefore = licenseHandler.hasValidLicense();
        LicenseDialog licenseDialog = new LicenseDialog(shell, licenseHandler, systemProvider, connectionMode, (IDialogId)SonargraphEclipseDialogId.LICENSE_DIALOG, (IProxySettingsProvider)proxySettingsProvider);
        if (licenseDialog.open() != 0 || !licenseHandler.hasValidLicense()) {
            return null;
        }
        if (validLicenseBefore) {
            plugin.showInitializationWarningDialog("Eclipse Restart Needed", "Please restart Eclipse to use the new license.");
            return null;
        }
        String lastUsedSystemPath = EclipsePreferenceUtils.getLastUsedSoftwareSystemPath();
        boolean isReload = lastUsedSystemPath != null && lastUsedSystemPath.length() > 0 ? (plugin.isInitialized() ? UserInterfaceAdapter.Feedback.CONFIRMED == UserInterfaceAdapter.getInstance().question("Do you want to reload the last used system?", false) : true) : true;
        ISonargraphEclipsePlugin.StartupOption startupOption = option = isReload ? ISonargraphEclipsePlugin.StartupOption.LOAD_SYSTEM : ISonargraphEclipsePlugin.StartupOption.PLAIN;
        if (!plugin.initialize(option, JobType.PROVIDES_PROGESS)) {
            Object msg = "Failed to initialize license";
            if (isReload) {
                msg = (String)msg + " and load last used system";
            }
            LOGGER.error((String)msg);
            plugin.showInitializationWarningDialog("Initialization Failure", (String)msg);
        }
        return null;
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin, @Optional SonargraphLicenseHandler licenseHandler) {
        return plugin != null && licenseHandler != null;
    }
}

