/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.activator;

import com.hello2morrow.sonargraph.client.eclipse.application.EclipseRelease;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.foundation.logback.LogbackConfigurator;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.E44Compatibility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphEclipsePluginActivator
implements BundleActivator {
    private static final String COM_HELLO2MORROW = "com.hello2morrow";
    private static final String FRAGMENT_HOST = "Fragment-Host";
    private static BundleContext s_bundleContext;

    public void start(BundleContext context) throws Exception {
        assert (context != null) : "Parameter 'context' of method 'start' must not be null";
        long start = System.currentTimeMillis();
        s_bundleContext = context;
        LogbackConfigurator.configure((String)SonargraphProduct.SONARGRAPH_ECLIPSE.getDirectoryName(), null, SonargraphEclipsePluginActivator.class);
        Logger logger = LoggerFactory.getLogger(SonargraphEclipsePluginActivator.class);
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle nextBundle = bundleArray[n2];
            if (nextBundle.getSymbolicName().startsWith(COM_HELLO2MORROW)) {
                BundleWiring bundleWiring = (BundleWiring)nextBundle.adapt(BundleWiring.class);
                if (bundleWiring != null) {
                    ClassLoader classLoader = bundleWiring.getClassLoader();
                    if (classLoader != null) {
                        logger.info("Enable assertions for {}", (Object)nextBundle);
                        classLoader.setPackageAssertionStatus(COM_HELLO2MORROW, true);
                    } else if (nextBundle.getHeaders().get(FRAGMENT_HOST) == null) {
                        logger.warn("No classloader available for bundle {}. Assertions are disabled.", (Object)nextBundle);
                    }
                } else {
                    logger.warn("No wiring present for bundle {}. Assertions are disabled.", (Object)nextBundle);
                }
            }
            ++n2;
        }
        Version eclipseVersion = EclipseRelease.getEclipseVersion();
        E44Compatibility.getOsgiServiceContext(eclipseVersion, context);
        logger.info("Activated product '{}' in {} ms on Eclipse build '{}' with with installed features: {}", new Object[]{EclipseRelease.getProductInfo(), "" + (System.currentTimeMillis() - start), eclipseVersion, EclipseRelease.getInstalledFeaturesInfo()});
    }

    public void stop(BundleContext context) throws Exception {
        s_bundleContext = null;
    }

    public static BundleContext getBundleContext() {
        return s_bundleContext;
    }
}

