/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.treemap.ITreeMapProvider;
import com.hello2morrow.sonargraph.core.model.treemap.IssueCollectorValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.MetricValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.NoHeightValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.ScriptMetricValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapLeafElement;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapProperties;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapValueSource;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.treemap.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.treemap.TreeMapPersistenceMessageCause;
import com.hello2morrow.sonargraph.core.persistence.treemap.XsdIssueCollector;
import com.hello2morrow.sonargraph.core.persistence.treemap.XsdLeafElement;
import com.hello2morrow.sonargraph.core.persistence.treemap.XsdMetric;
import com.hello2morrow.sonargraph.core.persistence.treemap.XsdResolutionMode;
import com.hello2morrow.sonargraph.core.persistence.treemap.XsdSeverity;
import com.hello2morrow.sonargraph.core.persistence.treemap.XsdTreeMap;
import com.hello2morrow.sonargraph.core.persistence.treemap.XsdValueSource;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;

public final class TreeMapPersistence {
    private static final String XSD_PACKAGE_NAME = "com.hello2morrow.sonargraph.core.persistence.treemap";
    private static final String SCHEMA_URL = "com/hello2morrow/sonargraph/core/persistence/treemap/treeMap";
    private static final String ROOT_ELEMENT = "treeMap";
    private final XmlPersistenceContext m_persistenceContext;
    private final ObjectFactory m_xsdFactory;
    private final Version m_version;
    private final ITreeMapProvider m_provider;

    public TreeMapPersistence(Version version, ITreeMapProvider provider) {
        assert (version != null) : "Parameter 'version' of method 'TreeMapPersistence' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'TreeMapPersistence' must not be null";
        this.m_persistenceContext = new XmlPersistenceContext(XSD_PACKAGE_NAME, CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
        this.m_xsdFactory = new ObjectFactory();
        this.m_version = version;
        this.m_provider = provider;
    }

    private JaxbAdapter<JAXBElement<XsdTreeMap>> createJaxbAadpter() {
        ClassLoader classLoader = ObjectFactory.class.getClassLoader();
        return JaxbAccess.createJaxbAdapter(classLoader, this.m_persistenceContext);
    }

    public OperationResult save(TreeMapFile treeMapFile, TFile targetFile) {
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'save' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'save' must not be null";
        JAXBElement<XsdTreeMap> xsdTreeMap = this.createXsdTreeMap(treeMapFile);
        TFile modelsDir = targetFile.getParentFile();
        if (!modelsDir.exists() || !modelsDir.isDirectory()) {
            modelsDir.mkdir();
        }
        OperationResult result = new OperationResult("Persist treemap file '" + FileUtility.getFileNameWithoutExtension((TFile)targetFile) + "'");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TFileOutputStream outputStream = new TFileOutputStream((File)targetFile);){
                this.createJaxbAadpter().save(xsdTreeMap, (OutputStream)outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex, "Failed to save treemap file '" + targetFile.getNormalizedAbsolutePath() + "'", new Object[0]);
        }
        return result;
    }

    public OperationResult save(TreeMapFile treeMapFile) {
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'save' must not be null";
        TFile file = treeMapFile.getFile();
        return this.save(treeMapFile, file);
    }

    private XsdValueSource createXsdValueSource(TreeMapValueSource treeMapValueSource) {
        assert (treeMapValueSource != null) : "Parameter 'treeMapValueSource' of method 'createXsdValueSource' must not be null";
        if (treeMapValueSource instanceof MetricValueSource) {
            IProviderId metricProvider;
            XsdMetric xsdMetric = this.m_xsdFactory.createXsdMetric();
            IMetricId iMetricId = ((MetricValueSource)treeMapValueSource).getMetricDescriptor().getMetricId();
            String standardName = iMetricId.getStandardName();
            xsdMetric.setId(standardName.startsWith((metricProvider = iMetricId.getProvider()).getStandardName()) ? standardName.substring(metricProvider.getStandardName().length()) : standardName);
            xsdMetric.setProvider(metricProvider.getStandardName());
            return xsdMetric;
        }
        if (treeMapValueSource instanceof ScriptMetricValueSource) {
            XsdMetric xsdMetric = this.m_xsdFactory.createXsdMetric();
            xsdMetric.setId(((ScriptMetricValueSource)treeMapValueSource).getMetricId());
            xsdMetric.setProvider(((ScriptMetricValueSource)treeMapValueSource).getProvider());
            return xsdMetric;
        }
        if (treeMapValueSource instanceof IssueCollectorValueSource) {
            XsdIssueCollector xsdIssueCollector = this.m_xsdFactory.createXsdIssueCollector();
            block11: for (ResolutionMode resolutionMode : ((IssueCollectorValueSource)treeMapValueSource).getResolutionModes()) {
                switch (resolutionMode) {
                    case NONE: {
                        xsdIssueCollector.getResolutionMode().add(XsdResolutionMode.NONE);
                        break;
                    }
                    case IGNORE: {
                        xsdIssueCollector.getResolutionMode().add(XsdResolutionMode.IGNORE);
                        break;
                    }
                    case TASK: {
                        xsdIssueCollector.getResolutionMode().add(XsdResolutionMode.TASK);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled resolution mode: " + String.valueOf((Object)resolutionMode);
                        continue block11;
                    }
                }
            }
            block12: for (Severity severity : ((IssueCollectorValueSource)treeMapValueSource).getSeverities()) {
                switch (severity) {
                    case NONE: {
                        xsdIssueCollector.getSeverity().add(XsdSeverity.NONE);
                        break;
                    }
                    case ERROR: {
                        xsdIssueCollector.getSeverity().add(XsdSeverity.ERROR);
                        break;
                    }
                    case INFO: {
                        xsdIssueCollector.getSeverity().add(XsdSeverity.INFO);
                        break;
                    }
                    case WARNING: {
                        xsdIssueCollector.getSeverity().add(XsdSeverity.WARNING);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled severity: " + String.valueOf((Object)severity);
                        continue block12;
                    }
                }
            }
            return xsdIssueCollector;
        }
        assert (false) : "Unhandled value source: " + String.valueOf(treeMapValueSource);
        return null;
    }

    private JAXBElement<XsdTreeMap> createXsdTreeMap(TreeMapFile treeMapFile) {
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'createXsdTreeMap' must not be null";
        XsdTreeMap xsdTreeMap = this.m_xsdFactory.createXsdTreeMap();
        JAXBElement<XsdTreeMap> element = this.m_xsdFactory.createTreeMap(xsdTreeMap);
        xsdTreeMap.setVersion(this.m_version.toString());
        TreeMapProperties treeMapProperties = treeMapFile.getTreeMapProperties();
        String description = treeMapProperties.getDescription();
        if (description != null && !description.isEmpty()) {
            xsdTreeMap.setDescription(description);
        }
        TreeMapLeafElement leafElement = treeMapProperties.getLeafElement();
        switch (leafElement) {
            case PHYSICAL_COMPONENT: {
                xsdTreeMap.setLeafElement(XsdLeafElement.PHYSICAL_COMPONENT);
                break;
            }
            case PHYSICAL_SOURCE_FILE: {
                xsdTreeMap.setLeafElement(XsdLeafElement.PHYSICAL_SOURCE_FILE);
                break;
            }
            default: {
                assert (false) : "Unhandled leaf element: " + String.valueOf((Object)leafElement);
                break;
            }
        }
        if (treeMapProperties.getRedThreshold() != 0) {
            xsdTreeMap.setRedThreshold(treeMapProperties.getRedThreshold());
        }
        xsdTreeMap.setSizeSource(this.createXsdValueSource(treeMapProperties.getSizeSource()));
        xsdTreeMap.setColorSource(this.createXsdValueSource(treeMapProperties.getColorSource()));
        TreeMapValueSource heightValueSource = treeMapProperties.getHeightSource();
        if (!(heightValueSource instanceof NoHeightValueSource)) {
            xsdTreeMap.setHeightSource(this.createXsdValueSource(heightValueSource));
        }
        return element;
    }

    public void save(TreeMapFile treeMapFile, OutputStream outputStream, OperationResult result) {
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        try {
            JAXBElement<XsdTreeMap> xsdModel = this.createXsdTreeMap(treeMapFile);
            this.createJaxbAadpter().save(xsdModel, outputStream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    private OperationResultWithOutcome<XsdTreeMap> internLoadFromStream(InputStream inputStream, TreeMapFile treeMapFile) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadFromStream' must not be null";
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'internLoadFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading treemap '" + treeMapFile.getIdentifyingPath() + "' from stream");
        JaxbAdapter<JAXBElement<XsdTreeMap>> jaxbAdapter = this.createJaxbAadpter();
        String sourceInfo = "Treemap '" + treeMapFile.getIdentifyingPath() + "'";
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl((OperationResult)result, sourceInfo);
        JAXBElement xsdTreeMap = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)eventHandler);
        if (result.isSuccess()) {
            result.setOutcome((Object)((XsdTreeMap)xsdTreeMap.getValue()));
        }
        return result;
    }

    public OperationResult load(TFile file, TreeMapFile treeMapFile) {
        assert (file != null) : "Parameter 'file' of method 'load' must not be null";
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'load' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load treemap file from '" + file.getName() + "'");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileInputStream inputStream = new TFileInputStream((File)file);){
                OperationResultWithOutcome<XsdTreeMap> loadResult = this.internLoadFromStream((InputStream)inputStream, treeMapFile);
                result.addMessagesFrom(loadResult);
                result.setOutcome((Object)((XsdTreeMap)loadResult.getOutcome()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, (Throwable)ex, "Failed to load treemap from file '" + file.getNormalizedAbsolutePath() + "'", new Object[0]);
        }
        if (result.isSuccess()) {
            this.transferDataIntoModel((XsdTreeMap)result.getOutcome(), treeMapFile, (OperationResult)result);
        }
        return result;
    }

    public OperationResult load(InputStream inputStream, TreeMapFile treeMapFile) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadFromStream' must not be null";
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'load' must not be null";
        OperationResultWithOutcome<XsdTreeMap> result = this.internLoadFromStream(inputStream, treeMapFile);
        if (result.isSuccess()) {
            this.transferDataIntoModel((XsdTreeMap)result.getOutcome(), treeMapFile, (OperationResult)result);
        }
        return result;
    }

    private TreeMapValueSource getSizeValueSource(TreeMapFile treeMapFile, XsdValueSource xsdValueSource, TreeMapProperties properties, OperationResult result) {
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'getSizeValueSource' must not be null";
        assert (xsdValueSource != null) : "Parameter 'xsdValueSource' of method 'getSizeValueSource' must not be null";
        assert (result != null) : "Parameter 'result' of method 'getSizeValueSource' must not be null";
        assert (xsdValueSource instanceof XsdMetric) : "Unexpected 'xsdValueSource': " + String.valueOf(xsdValueSource);
        XsdMetric xsdMetric = (XsdMetric)xsdValueSource;
        String metricProvider = xsdMetric.getProvider();
        String standardMetricName = metricProvider + xsdMetric.getId();
        TreeMapValueSource found = null;
        if (metricProvider.equalsIgnoreCase("core")) {
            for (TreeMapValueSource nextAvailable : properties.getAvailableSizeSources()) {
                if (!(nextAvailable instanceof MetricValueSource) || !((MetricValueSource)nextAvailable).getMetricDescriptor().getMetricId().getStandardName().endsWith(standardMetricName)) continue;
                found = nextAvailable;
                break;
            }
        }
        if (found == null) {
            result.addError((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_VALUE_SOURCE_NOT_AVAILABLE, "'" + standardMetricName + "' in '" + treeMapFile.getIdentifyingPath() + "'.", new Object[0]);
        }
        return found;
    }

    /*
     * WARNING - void declaration
     */
    private TreeMapValueSource getColorOrHeightValueSource(TreeMapFile treeMapFile, XsdValueSource xsdValueSource, TreeMapProperties properties, List<TreeMapValueSource> availableValueSources, OperationResult result) {
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'getColorOrHeightValueSource' must not be null";
        assert (xsdValueSource != null) : "Parameter 'xsdValueSource' of method 'getColorOrHeightValueSource' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'getColgetColorOrHeightValueSourcerValueSource' must not be null";
        assert (availableValueSources != null && !availableValueSources.isEmpty()) : "Parameter 'availableValueSources' of method 'getColorOrHeightValueSource' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'getColorOrHeightValueSource' must not be null";
        if (xsdValueSource instanceof XsdMetric) {
            void var9_15;
            TreeMapLeafElement leafElement;
            XsdMetric xsdMetric = (XsdMetric)xsdValueSource;
            String metricProvider = xsdMetric.getProvider();
            String standardMetricName = metricProvider + xsdMetric.getId();
            Object var9_12 = null;
            if (metricProvider.equalsIgnoreCase("core")) {
                for (TreeMapValueSource nextAvailable : availableValueSources) {
                    if (!(nextAvailable instanceof MetricValueSource) || !((MetricValueSource)nextAvailable).getMetricDescriptor().getMetricId().getStandardName().endsWith(standardMetricName)) continue;
                    TreeMapValueSource treeMapValueSource = nextAvailable;
                    break;
                }
            } else if (metricProvider.startsWith("./") && (leafElement = properties.getLeafElement()) != null) {
                ScriptMetricValueSource scriptMetricValueSource = new ScriptMetricValueSource(metricProvider, xsdMetric.getId(), leafElement);
                properties.addScriptMetricValueColorSource(scriptMetricValueSource);
            }
            if (var9_15 == null) {
                result.addError((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_VALUE_SOURCE_NOT_AVAILABLE, "'" + standardMetricName + "' in '" + treeMapFile.getIdentifyingPath() + "'.", new Object[0]);
            }
            return var9_15;
        }
        if (xsdValueSource instanceof XsdIssueCollector) {
            Optional<TreeMapValueSource> found = availableValueSources.stream().filter(a -> a instanceof IssueCollectorValueSource).findFirst();
            if (!found.isPresent()) {
                result.addError((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_VALUE_PROVIDER_NOT_AVAILABLE, "'" + IssueCollectorValueSource.class.getSimpleName() + "' in '" + treeMapFile.getIdentifyingPath() + "'.", new Object[0]);
                return null;
            }
            IssueCollectorValueSource issueCollectorValueSource = (IssueCollectorValueSource)found.get();
            issueCollectorValueSource.clear();
            XsdIssueCollector xsdIssueCollector = (XsdIssueCollector)xsdValueSource;
            for (XsdResolutionMode xsdResolutionMode : xsdIssueCollector.getResolutionMode()) {
                try {
                    issueCollectorValueSource.addResolutionMode(ResolutionMode.fromStandardName(xsdResolutionMode.value()));
                }
                catch (IllegalArgumentException ex) {
                    result.addError((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_RESOLUTION_MODE_UNKNOWN, "'" + xsdResolutionMode.value() + "' in '" + treeMapFile.getIdentifyingPath() + "'.", new Object[0]);
                    return null;
                }
            }
            for (XsdSeverity xsdSeverity : xsdIssueCollector.getSeverity()) {
                try {
                    issueCollectorValueSource.addSeverity(Severity.fromStandardName(xsdSeverity.value()));
                }
                catch (IllegalArgumentException ex) {
                    result.addError((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_SEVERITY_UNKNOWN, "'" + xsdSeverity.value() + "' in '" + treeMapFile.getIdentifyingPath() + "'.", new Object[0]);
                    return null;
                }
            }
            return issueCollectorValueSource;
        }
        result.addError((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_VALUE_SOURCE_TYPE_UNKNOWN, "'" + xsdValueSource.getClass().getSimpleName() + "' in '" + treeMapFile.getIdentifyingPath() + "'.", new Object[0]);
        return null;
    }

    private void transferDataIntoModel(XsdTreeMap xsdTreeMap, TreeMapFile treeMapFile, OperationResult result) {
        int redThreshold;
        ValidationResult redThresholdValidationResult;
        assert (xsdTreeMap != null) : "Parameter 'xsdTreeMap' of method 'transferDataIntoModel' must not be null";
        assert (treeMapFile != null) : "Parameter 'treeMapFile' of method 'transferDataIntoModel' must not be null";
        assert (result != null) : "Parameter 'result' of method 'transferDataIntoModel' must not be null";
        String versionFromPersistenceAsString = xsdTreeMap.getVersion();
        Version versionFromPersistence = Version.create((String)versionFromPersistenceAsString);
        if (versionFromPersistence == null) {
            result.addWarning((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Version '" + versionFromPersistenceAsString + "' not recorgnized in '" + treeMapFile.getIdentifyingPath() + "'.", new Object[0]);
        }
        TreeMapProperties treeMapProperties = this.m_provider.getDefaultProperties();
        treeMapFile.setTreeMapProperties(treeMapProperties);
        treeMapProperties.setName(FileUtility.removeExtension((String)treeMapFile.getShortName()));
        String xsdDescription = xsdTreeMap.getDescription();
        if (xsdDescription != null && !xsdDescription.isEmpty()) {
            treeMapProperties.setDescription(xsdDescription);
        }
        TreeMapLeafElement leafElement = null;
        try {
            leafElement = TreeMapLeafElement.fromStandardName(xsdTreeMap.getLeafElement().value());
            treeMapProperties.setLeafElement(leafElement);
        }
        catch (IllegalArgumentException ex) {
            result.addError((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_LEAF_ELEMENT_UNKNOWN, "'" + xsdTreeMap.getLeafElement().name() + "' in '" + treeMapFile.getIdentifyingPath() + "'.", new Object[0]);
        }
        TreeMapValueSource sizeValueSource = this.getSizeValueSource(treeMapFile, xsdTreeMap.getSizeSource(), treeMapProperties, result);
        if (result.isSuccess()) {
            treeMapProperties.setSizeSource(sizeValueSource);
        }
        TreeMapValueSource colorValueSource = this.getColorOrHeightValueSource(treeMapFile, xsdTreeMap.getColorSource(), treeMapProperties, treeMapProperties.getAvailableColorSources(), result);
        if (result.isSuccess()) {
            treeMapProperties.setColorSource(colorValueSource);
        }
        if ((redThresholdValidationResult = TreeMapProperties.isRedThresholdValid(redThreshold = xsdTreeMap.getRedThreshold())).isSuccess()) {
            treeMapProperties.setRedThreshold(redThreshold);
        } else {
            result.addError((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_RED_THRESHOLD_NOT_VALID, "Red threshold must be 0 or a positive multiple of 2, '" + redThreshold + "' in '" + treeMapFile.getIdentifyingPath() + "'.", new Object[0]);
        }
        XsdValueSource xsdHeightSource = xsdTreeMap.getHeightSource();
        if (xsdHeightSource != null) {
            TreeMapValueSource heightValueSource = this.getColorOrHeightValueSource(treeMapFile, xsdHeightSource, treeMapProperties, treeMapProperties.getAvailableHeightSources(), result);
            if (result.isSuccess()) {
                treeMapProperties.setHeightSource(heightValueSource);
            }
        }
    }

    public static boolean isValidRootElement(String rootElement) {
        assert (rootElement != null && rootElement.length() > 0) : "Parameter 'rootElement' of method 'isValidRootElement' must not be empty";
        return ROOT_ELEMENT.equals(rootElement);
    }
}

