/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system.settings;

import com.hello2morrow.sonargraph.core.persistence.system.ModuleImportMessageCause;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.SmartReader;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public final class SolutionFileFilterParser {
    private static final OperationResult.IMessageCause CAUSE = ModuleImportMessageCause.SOLUTION_FILE_FILTER_PROCESSING_FAILED;

    public OperationResultWithOutcome<SolutionFilterFile> parse(TFile solutionFilterFile) {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Parsing solution filter file");
        JSONParser parser = new JSONParser();
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (SmartReader fileReader = new SmartReader((InputStream)new TFileInputStream((File)solutionFilterFile));){
                JSONObject jsonObject;
                Object solutionObject;
                Object object = parser.parse((Reader)fileReader);
                if (!(object instanceof JSONObject)) {
                    result.addError(CAUSE, "Invalid Solution Filter File (.slnf)", new Object[0]);
                }
                if ((solutionObject = (jsonObject = (JSONObject)object).get((Object)"solution")) == null) {
                    result.addError(CAUSE, "Failed to determine 'solution' element", new Object[0]);
                    return result;
                }
                JSONObject solution = (JSONObject)solutionObject;
                Object path = solution.get((Object)"path");
                if (path == null || !(path instanceof String)) {
                    result.addError(CAUSE, "No 'path' element found", new Object[0]);
                    return result;
                }
                TFile solutionFile = new TFile((File)solutionFilterFile.getParentFile(), path.toString()).getNormalizedAbsoluteFile();
                TFile baseDirectory = solutionFile.getParentFile();
                Object projects = solution.get((Object)"projects");
                if (projects == null || !(projects instanceof JSONArray)) {
                    result.addError(CAUSE, "No 'projects' element found", new Object[0]);
                    return result;
                }
                JSONArray projectPaths = (JSONArray)projects;
                ArrayList<TFile> projectFiles = new ArrayList<TFile>(projectPaths.size());
                for (Object next : projectPaths) {
                    projectFiles.add(new TFile((File)baseDirectory, next.toString()).getNormalizedAbsoluteFile());
                }
                SolutionFilterFile solutionFilter = new SolutionFilterFile(solutionFile, projectFiles);
                result.setOutcome((Object)solutionFilter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, (Throwable)e);
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e);
        }
        catch (ParseException e) {
            result.addError(CAUSE, (Throwable)e);
        }
        return result;
    }

    public static final class SolutionFilterFile {
        private final TFile m_solutionFile;
        private final List<TFile> m_projectFiles;
        private final Set<String> m_projectFilePaths;

        public SolutionFilterFile(TFile solutionFile, List<TFile> projectFiles) {
            assert (solutionFile != null) : "Parameter 'solutionFile' of method 'SolutionFileFilter' must not be null";
            assert (projectFiles != null) : "Parameter 'projectFiles' of method 'SolutionFileFilter' must not be null";
            this.m_solutionFile = solutionFile;
            this.m_projectFiles = projectFiles;
            this.m_projectFilePaths = projectFiles.stream().map(f -> FileUtility.getCanonicalFilePath((TFile)f)).collect(Collectors.toSet());
        }

        public TFile getSolutionFile() {
            return this.m_solutionFile;
        }

        public List<TFile> getProjectFiles() {
            return this.m_projectFiles;
        }

        public boolean accept(TFile projectFile) {
            assert (projectFile != null) : "Parameter 'projectFile' of method 'accept' must not be null";
            return this.m_projectFilePaths.contains(FileUtility.getCanonicalFilePath((TFile)projectFile));
        }
    }
}

