/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system;

import com.hello2morrow.sonargraph.core.persistence.system.PersistenceCause;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SoftwareSystemPropertiesReader {
    public static OperationResultWithOutcome<SoftwareSystemProperties> read(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'read' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Read software system properties");
        SoftwareSystemProperties properties = new SoftwareSystemProperties();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (TFileInputStream is = new TFileInputStream((File)file);){
                SAXParserFactory.newInstance().newSAXParser().parse((InputStream)is, (DefaultHandler)new ReadPropertiesHandler(properties, (OperationResult)result));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, ExceptionUtility.collectAll((Throwable)ioe), new Object[0]);
        }
        catch (Exception ex) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.UNABLE_TO_PARSE, ExceptionUtility.collectAll((Throwable)ex), new Object[0]);
        }
        if (result.isSuccess()) {
            result.setOutcome((Object)properties);
        }
        return result;
    }

    private SoftwareSystemPropertiesReader() {
    }

    private static final class ReadPropertiesHandler
    extends DefaultHandler {
        private static final Set<String> ELEMENT_NAMES = new HashSet<String>(Arrays.asList("module", "systemExtension"));
        private static final String ID_ATTRIBUTE_NAME = "id";
        private static final String SOFTWARE_SYSTEM_ELEMENT_NAME = "softwareSystem";
        private static final String LANGUAGE_ATTRIBUTE_NAME = "language";
        private final SoftwareSystemProperties m_properties;
        private final OperationResult m_result;
        private boolean m_rootElementDetected;

        ReadPropertiesHandler(SoftwareSystemProperties properties, OperationResult result) {
            assert (properties != null) : "Parameter 'properties' of method 'ReadPropertiesDefaultHandler' must not be null";
            assert (result != null) : "Parameter 'result' of method 'ReadPropertiesDefaultHandler' must not be null";
            this.m_properties = properties;
            this.m_result = result;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            assert (qName != null) : "Parameter 'qName' of method 'startElement' must not be null";
            assert (attributes != null) : "Parameter 'attributes' of method 'startElement' must not be null";
            if (this.m_result.isFailure()) {
                return;
            }
            if (!this.m_rootElementDetected) {
                this.m_rootElementDetected = true;
                if (qName.endsWith(SOFTWARE_SYSTEM_ELEMENT_NAME)) {
                    String id = attributes.getValue(ID_ATTRIBUTE_NAME);
                    if (id != null && id.length() > 0) {
                        this.m_properties.setId(id);
                    } else {
                        this.m_result.addError((OperationResult.IMessageCause)PersistenceCause.ID_NOT_VALID, "Missing 'id' attribute", new Object[0]);
                    }
                } else {
                    this.m_result.addError((OperationResult.IMessageCause)PersistenceCause.UNABLE_TO_PARSE, "Unexpected XML root element", new Object[0]);
                }
            } else if (ELEMENT_NAMES.contains(qName)) {
                if (attributes.getIndex(LANGUAGE_ATTRIBUTE_NAME) < 0) {
                    return;
                }
                String nextLanguageValue = attributes.getValue(LANGUAGE_ATTRIBUTE_NAME);
                if (nextLanguageValue != null && !nextLanguageValue.isEmpty()) {
                    this.m_properties.addLanguage(nextLanguageValue);
                }
            }
        }
    }

    public static final class SoftwareSystemProperties {
        private final Set<String> m_languages = new LinkedHashSet<String>();
        private String m_id;

        private SoftwareSystemProperties() {
        }

        void setId(String id) {
            assert (this.m_id == null) : "'m_id' already set'";
            assert (id != null && id.length() > 0) : "Parameter 'id' of method 'setId' must not be empty";
            this.m_id = id;
        }

        boolean addLanguage(String language) {
            assert (language != null && language.length() > 0) : "Parameter 'language' of method 'addLanguage' must not be empty";
            return this.m_languages.add(language);
        }

        public String getId() {
            assert (this.m_id != null && this.m_id.length() > 0) : "'m_id' of method 'getId' must not be empty";
            return this.m_id;
        }

        public Set<String> getLanguages() {
            return Collections.unmodifiableSet(this.m_languages);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Id: ").append(this.m_id).append("\n");
            builder.append("Language(s):");
            for (String next : this.m_languages) {
                builder.append(" ");
                builder.append(next);
            }
            return builder.toString();
        }
    }
}

