/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.diff;

import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class BaselineReader
extends DefaultHandler {
    private final SAXParser m_saxParser;
    private String m_description;
    private String m_timestamp;
    private String m_currentElement;
    private StringBuilder m_content;

    public BaselineReader() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.m_saxParser = factory.newSAXParser();
    }

    public OperationResultWithOutcome<BaselineInfo> read(TFile baseline) {
        assert (baseline != null) : "Parameter 'baseline' of method 'read' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Reading core baseline info from report");
        boolean finishedAsExpected = false;
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (TFileInputStream in = new TFileInputStream((File)baseline);){
                this.m_timestamp = null;
                this.m_description = null;
                this.m_saxParser.parse((InputStream)in, (DefaultHandler)this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FinishedException e) {
            finishedAsExpected = true;
            if (this.m_timestamp == null) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Missing 'timestamp' attribute", new Object[0]);
            } else if (this.m_description == null) {
                this.m_description = "";
            }
            if (this.m_timestamp != null) {
                try {
                    XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(this.m_timestamp);
                    Date dateTime = xmlCalendar.toGregorianCalendar().getTime();
                    BaselineInfo info = new BaselineInfo(baseline, this.m_description, dateTime);
                    result.setOutcome((Object)info);
                }
                catch (DatatypeConfigurationException e1) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Failed to parse date/time '" + this.m_timestamp + "'", new Object[0]);
                }
            }
        }
        catch (SAXException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Failed to parse report file", new Object[]{e});
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e);
        }
        if (result.isSuccess() && !finishedAsExpected) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Report '" + String.valueOf(baseline) + "' does not have the expected format.", new Object[0]);
        }
        return result;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.m_currentElement = qName;
        if (qName.endsWith("report")) {
            int i = 0;
            while (i < attributes.getLength()) {
                String attributeName = attributes.getQName(i);
                if (attributeName.equals("timestamp")) {
                    this.m_timestamp = attributes.getValue(i);
                    break;
                }
                ++i;
            }
        } else if (qName.equals("reportContextInfo")) {
            this.m_content = new StringBuilder();
        } else if (qName.equals("metaData")) {
            throw new FinishedException();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_currentElement.equals("reportContextInfo")) {
            this.m_description = this.m_content.toString();
            throw new FinishedException();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_content != null) {
            this.m_content.append(ch, start, length);
        }
    }

    private static class FinishedException
    extends SAXException {
        private static final long serialVersionUID = -5984804081936315523L;

        private FinishedException() {
        }
    }
}

