/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.workspace;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IModelRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.filter.IssueFilter;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.IWorkspace;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotComponentContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class Workspace
extends NamedElementContainer
implements IWorkspace,
IModelRoot {
    public static final String NAME = "Workspace";
    private boolean m_externalConfigurationChanged;

    public Workspace(NamedElement parent) {
        super(parent);
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Filter, Modules and Parser Model";
    }

    private void createFiltersIfNecessary() {
        if (this.getUniqueChild(WorkspaceFilter.class) == null) {
            this.addChild(new WorkspaceFilter(this));
        }
        if (this.getUniqueChild(ProductionCodeFilter.class) == null) {
            this.addChild(new ProductionCodeFilter(this));
        }
        if (this.getUniqueChild(IssueFilter.class) == null) {
            this.addChild(new IssueFilter(this));
        }
    }

    public ProductionCodeFilter getProductionCodeFilter() {
        this.createFiltersIfNecessary();
        return this.getUniqueExistingChild(ProductionCodeFilter.class);
    }

    public IssueFilter getIssueFilter() {
        this.createFiltersIfNecessary();
        return this.getUniqueExistingChild(IssueFilter.class);
    }

    public WorkspaceFilter getWorkspaceFilter() {
        this.createFiltersIfNecessary();
        return this.getUniqueExistingChild(WorkspaceFilter.class);
    }

    @Override
    public Set<Language> getUsedLanguages() {
        List<IModule> modules = this.getChildren(IModule.class);
        if (modules.isEmpty()) {
            return Collections.emptySet();
        }
        THashSet languages = new THashSet();
        for (IModule nextModule : modules) {
            languages.add(nextModule.getLanguage());
        }
        return languages;
    }

    public void setExternalConfigurationChanged(boolean changed) {
        this.m_externalConfigurationChanged = changed;
    }

    public boolean isExternalConfigurationChanged() {
        return this.m_externalConfigurationChanged;
    }

    @Override
    public List<? extends ISnapshotComponentContainer> getComponentContainer() {
        return this.getChildren(ISnapshotComponentContainer.class);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitWorkspace(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitWorkspace(Workspace var1);
    }
}

