/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.file.SearchPath;
import de.schlichtherle.truezip.file.TFile;

public abstract class InstallationSearchPath
extends NamedElement {
    protected final String m_name;
    protected SearchPath m_searchPath;
    protected TFile m_instSpecDir;

    public InstallationSearchPath(NamedElement parent, String name, TFile instSpecificDirectory) {
        super(parent);
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'InstallationSearchPath' must not be empty";
        this.m_name = name;
        this.m_searchPath = new SearchPath();
        this.m_instSpecDir = instSpecificDirectory;
    }

    @Override
    public String getShortName() {
        return this.m_name;
    }

    public SearchPath getSearchPath() {
        return this.m_searchPath;
    }

    public void setSearchPath(SearchPath searchPath) {
        assert (searchPath != null) : "Parameter 'searchPath' of method 'setSearchPath' must not be null";
        this.m_searchPath = searchPath;
    }

    public void setInstSpecificDir(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'setInstSpecificDir' must not be null";
        this.m_instSpecDir = dir.getNormalizedAbsoluteFile();
    }

    public TFile getInstSpecificDir() {
        return this.m_instSpecDir;
    }

    public TFile locateFile(String nameWithoutExtension) {
        return this.createEffectiveSearchPath().locateFile(nameWithoutExtension + this.getFileExtension());
    }

    protected abstract String getFileExtension();

    public SearchPath createEffectiveSearchPath() {
        SearchPath searchPath = new SearchPath();
        searchPath.add(this.m_instSpecDir);
        for (TFile dir : this.getSearchPath().getDirectories()) {
            searchPath.add(dir);
        }
        return searchPath;
    }

    @Override
    public final String getImageResourceName() {
        return InstallationSearchPath.class.getSimpleName();
    }
}

