/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractCurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.List;

public final class ThresholdIssueQualityGateCondition
extends AbstractCurrentIssueQualityGateCondition {
    private final String m_metricId;

    public ThresholdIssueQualityGateCondition(NamedElement parent, String issueType, List<String> severities, List<String> resolutions, String metricId, Operator operator, int limit) {
        super(parent, issueType, severities, resolutions, operator, limit);
        assert (metricId != null && metricId.length() > 0) : "Parameter 'metricId' of method 'ThresholdIssueQualityGateCondition' must not be empty";
        this.m_metricId = metricId;
    }

    @Property
    public String getMetricId() {
        return this.m_metricId;
    }

    @Override
    public String getIssueType() {
        return super.getIssueType();
    }

    @Override
    public String getDebugInfo() {
        return super.getDebugInfo() + '|' + Element.escapeSpecialCharacters(this.m_metricId);
    }

    @Override
    public String getPresentationName(boolean shortName) {
        if (shortName) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append('|');
            builder.append(this.getIssueType()).append('|');
            builder.append(ThresholdIssueQualityGateCondition.getSeverityAsString(this.getSeverityList())).append('|');
            builder.append(ThresholdIssueQualityGateCondition.getResolutionsAsString(this.getResolutionList())).append('|');
            builder.append(this.m_metricId).append('|');
            builder.append(this.getOperator().getStandardName()).append('|');
            builder.append(this.getLimit());
            return builder.toString();
        }
        return ThresholdIssueQualityGateCondition.createPresentationNameLong(this.getIssueType(), this.getSeverityList(), this.getResolutionList(), this.getOperator(), this.getLimit(), this.getMetricId());
    }

    public static String createPresentationNameLong(String issueType, List<String> severities, List<String> resolutions, Operator operator, int limit, String metricId) {
        StringBuilder builder = new StringBuilder();
        builder.append(operator.getPresentationName()).append(" ").append(limit);
        builder.append(" threshold violations for metric '").append(metricId).append("'");
        builder.append(" with severity '").append(ThresholdIssueQualityGateCondition.getSeverityAsString(severities)).append("'");
        builder.append(" and resolution '").append(ThresholdIssueQualityGateCondition.getResolutionsAsString(resolutions)).append("'");
        return builder.toString();
    }
}

