/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.issue;

import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;

public interface IIssueDiff
extends IDiffElement {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$hello2morrow$sonargraph$integration$access$model$ResolutionType;

    static {
        $SWITCH_TABLE$com$hello2morrow$sonargraph$integration$access$model$ResolutionType = IIssueDiff.$SWITCH_TABLE$com$hello2morrow$sonargraph$integration$access$model$ResolutionType();
    }

    public IIssue getBaseline();

    public Issue getCurrent();

    @Override
    default public Element getSourceElement() {
        return this.getCurrent();
    }

    public Severity getSeverity();

    public String getIssueCategoryPresentationName();

    public String getIssueCategoryStandardName();

    public String getProviderPresentationName();

    public String getAffectedElementPresentationName(boolean var1);

    public static ResolutionKind convertResolutionType(ResolutionType type) {
        assert (type != null) : "Parameter 'type' of method 'convertResolutionType' must not be null";
        switch (type) {
            case FIX: {
                return ResolutionKind.FIX;
            }
            case IGNORE: {
                return ResolutionKind.IGNORE;
            }
            case NONE: {
                assert (false) : "Unexpected type: " + String.valueOf(type);
                break;
            }
            case REFACTORING: {
                return ResolutionKind.REFACTORING;
            }
            case TODO: {
                return ResolutionKind.TODO;
            }
            default: {
                assert (false) : "Unsupported type: " + String.valueOf(type);
                break;
            }
        }
        return null;
    }

    default public ResolutionKind getBaselineResolutionKind() {
        if (this.getBaseline() == null || !this.getBaseline().hasResolution()) {
            return null;
        }
        return IIssueDiff.convertResolutionType(this.getBaseline().getResolutionType());
    }

    default public boolean hasUnchangedResolutionKind() {
        ResolutionKind baselineResolutionKind = this.getBaselineResolutionKind();
        ResolutionKind currentResolutionKind = this.getCurrentResolutionKind();
        boolean resolutionsPresent = baselineResolutionKind != null && currentResolutionKind != null;
        boolean unchangedResolutionKind = resolutionsPresent && baselineResolutionKind == currentResolutionKind;
        return unchangedResolutionKind;
    }

    default public ResolutionKind getCurrentResolutionKind() {
        if (this.getCurrent() == null || this.getCurrent().getResolution() == null) {
            return null;
        }
        assert (this.getCurrent().getResolution() != null && this.getCurrent().getResolution() instanceof Resolution) : "Unexpected class in method 'getCurrentResolutionKind': " + String.valueOf(this.getCurrent().getResolution());
        return ((Resolution)this.getCurrent().getResolution()).getKind();
    }

    @Property
    default public String getResolutionKind() {
        if (this.getCurrent() != null) {
            ResolutionKind resolutionKind = this.getCurrentResolutionKind();
            if (resolutionKind != null) {
                return resolutionKind.getPresentationName();
            }
            return null;
        }
        ResolutionKind resolutionKind = this.getBaselineResolutionKind();
        if (resolutionKind != null) {
            return resolutionKind.getPresentationName();
        }
        return null;
    }
}

