/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class StructureInfo {
    private final LinkedList<StructureItem> m_itemList;

    public StructureInfo(List<StructureItem> items) {
        assert (items != null && items.size() > 0) : "Parameter 'items' of method 'Structure' must not be null";
        this.m_itemList = new LinkedList<StructureItem>(items);
    }

    public StructureItem getPrevious(StructureItem current) {
        try {
            return this.getIteratorAtItem(current).previous();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public StructureItem getNext(StructureItem current) {
        assert (current != null) : "Parameter 'current' of method 'getNext' must not be null";
        try {
            ListIterator<StructureItem> it = this.getIteratorAtItem(current);
            it.next();
            return (StructureItem)((Object)it.next());
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private ListIterator<StructureItem> getIteratorAtItem(StructureItem current) {
        assert (current != null) : "Parameter 'current' of method 'getPrevious' must not be null";
        int index = this.m_itemList.indexOf((Object)current);
        assert (index > -1) : "Element not contained in the registry: " + String.valueOf((Object)current);
        ListIterator<StructureItem> iterator = this.m_itemList.listIterator(index);
        return iterator;
    }

    public boolean isLastElementInStructure(StructureItem item) {
        assert (item != null) : "Parameter 'item' of method 'isLastElementInStructure' must not be null";
        return this.getPositionInStructure(item) == this.m_itemList.size() - 1;
    }

    public int getPositionInStructure(StructureItem item) {
        assert (item != null) : "Parameter 'item' of method 'getPositionInLanguage' must not be null";
        int position = this.m_itemList.indexOf((Object)item);
        if (position == -1) assert (false) : "'" + String.valueOf((Object)item) + "' is not in the language structure item registry";
        return position;
    }

    public int compare(StructureItem item1, StructureItem item2) {
        assert (item1 != null) : "Parameter 'item1' of method 'compare' must not be null";
        assert (item2 != null) : "Parameter 'item2' of method 'compare' must not be null";
        assert (this.isInStructure(item1)) : String.valueOf((Object)item1) + " not in structure " + String.valueOf(this);
        assert (this.isInStructure(item2)) : String.valueOf((Object)item2) + " not in structure " + String.valueOf(this);
        return Integer.compare(this.getPositionInStructure(item1), this.getPositionInStructure(item2));
    }

    public boolean isInStructure(StructureItem item) {
        assert (item != null) : "Parameter 'item' of method 'isInStructure' must not be null";
        return this.m_itemList.contains((Object)item);
    }

    public List<StructureItem> getItemList() {
        return Collections.unmodifiableList(this.m_itemList);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (StructureItem item : this.m_itemList) {
            builder.append(item.toString());
            builder.append(StringUtility.LINE_SEPARATOR);
        }
        return builder.toString();
    }
}

