/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.FileComparator;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModuleDelta {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDelta.class);
    private static SortOrder s_sortOrder = SortOrder.NONE;
    private final Map<RootDirectoryPath, Map<IFileType, List<TFile>>> m_rootDirectoryPathToAddedFiles = new LinkedHashMap<RootDirectoryPath, Map<IFileType, List<TFile>>>();
    private final Set<FilePath> m_deleted = new LinkedHashSet<FilePath>();
    private final Set<FilePath> m_modified = new LinkedHashSet<FilePath>();
    private final ILanguageProvider m_languageProvider;
    private final Module m_module;
    private final IWorkspaceFilter m_filter;

    public static void setSortOrder(SortOrder sortOrder) {
        assert (sortOrder != null) : "Parameter 'sortOrder' of method 'setSortOrder' must not be null";
        s_sortOrder = sortOrder;
    }

    public static SortOrder getSortOrder() {
        return s_sortOrder;
    }

    public ModuleDelta(ILanguageProvider languageProvider, IWorkspaceFilter filter, Module module) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'ModuleDelta' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'ModuleDelta' must not be null";
        assert (module != null) : "Parameter 'module' of method 'ModuleDelta' must not be null";
        this.m_languageProvider = languageProvider;
        this.m_module = module;
        this.m_filter = filter;
    }

    public ILanguageProvider getLanguageProvider() {
        return this.m_languageProvider;
    }

    public Module getModule() {
        return this.m_module;
    }

    public boolean isEmpty() {
        return this.m_deleted.isEmpty() && this.m_modified.isEmpty() && this.m_rootDirectoryPathToAddedFiles.isEmpty();
    }

    public void added(RootDirectoryPath root, IFileType fileType, TFile file) {
        List<TFile> addedFiles;
        assert (root != null) : "Parameter 'root' of method 'added' must not be null";
        assert (fileType != null) : "Parameter 'fileType' of method 'added' must not be null";
        assert (file != null) : "Parameter 'file' of method 'added' must not be null";
        if (!this.m_filter.includeFile(() -> FileUtility.calculateRelativePath((TFile)file, (TFile)root.getBaseDirectory().getDirectoryFile()))) {
            return;
        }
        Map<IFileType, List<TFile>> fileTypeToAddedFiles = this.m_rootDirectoryPathToAddedFiles.get(root);
        if (fileTypeToAddedFiles == null) {
            fileTypeToAddedFiles = new HashMap<IFileType, List<TFile>>();
            this.m_rootDirectoryPathToAddedFiles.put(root, fileTypeToAddedFiles);
        }
        if ((addedFiles = fileTypeToAddedFiles.get(fileType)) == null) {
            addedFiles = new ArrayList<TFile>();
            fileTypeToAddedFiles.put(fileType, addedFiles);
        }
        addedFiles.add(file);
    }

    public void modified(FilePath filePath) {
        assert (filePath != null) : "Parameter 'filePath' of method 'modified' must not be null";
        assert (filePath.isValid()) : "'filePath' of method 'modified' must be valid: " + FileUtility.getIdentifyingPath((TFile)filePath.getFile());
        this.m_modified.add(filePath);
    }

    public boolean isModified(FilePath filePath) {
        return this.m_modified.contains(filePath);
    }

    public void deleted(FilePath filePath) {
        assert (filePath != null) : "Parameter 'filePath' of method 'deleted' must not be null";
        assert (filePath.isValid()) : "'filePath' of method 'deleted' must be valid: " + FileUtility.getIdentifyingPath((TFile)filePath.getFile());
        this.m_deleted.add(filePath);
    }

    public boolean isDeleted(FilePath filePath) {
        return this.m_deleted.contains(filePath);
    }

    private int getNumberOfAddedFiles() {
        int added = 0;
        for (Map<IFileType, List<TFile>> next : this.m_rootDirectoryPathToAddedFiles.values()) {
            for (List<TFile> nextAdded : next.values()) {
                added += nextAdded.size();
            }
        }
        return added;
    }

    public int getNumberOfAddedAndModifiedFiles() {
        return this.getNumberOfAddedFiles() + this.m_modified.size();
    }

    public void visitDeleted(IVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visitDeleted' must not be null";
        for (FilePath nextDeleted : this.m_deleted) {
            visitor.deleted(this, nextDeleted);
        }
    }

    public void visitModified(IVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visitDeleted' must not be null";
        for (FilePath nextModified : this.m_modified) {
            visitor.modified(this, nextModified);
        }
    }

    public void visitAdded(IVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visitAdded' must not be null";
        for (Map.Entry<RootDirectoryPath, Map<IFileType, List<TFile>>> nextRootToAddedFiles : this.m_rootDirectoryPathToAddedFiles.entrySet()) {
            RootDirectoryPath nextRoot = nextRootToAddedFiles.getKey();
            for (Map.Entry<IFileType, List<TFile>> nextFileTypeToFile : nextRootToAddedFiles.getValue().entrySet()) {
                IFileType nextFileType = nextFileTypeToFile.getKey();
                for (TFile nextFile : nextFileTypeToFile.getValue()) {
                    visitor.added(nextRoot, nextFileType, nextFile);
                }
            }
        }
    }

    public void sortAddedFiles() {
        if (s_sortOrder != SortOrder.NONE && !this.m_rootDirectoryPathToAddedFiles.isEmpty()) {
            FileComparator comparator = new FileComparator(s_sortOrder == SortOrder.ASCENDING);
            for (Map.Entry<RootDirectoryPath, Map<IFileType, List<TFile>>> nextRootToAddedFiles : this.m_rootDirectoryPathToAddedFiles.entrySet()) {
                for (Map.Entry<IFileType, List<TFile>> nextFileTypeToFile : nextRootToAddedFiles.getValue().entrySet()) {
                    List<TFile> files = nextFileTypeToFile.getValue();
                    Collections.sort(files, comparator);
                }
            }
        }
    }

    public void removeFromModified(FilePath file) {
        this.m_modified.remove(file);
    }

    public void finishCreation() {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            ArrayList<TFile> added = new ArrayList<TFile>();
            for (Map.Entry<RootDirectoryPath, Map<IFileType, List<TFile>>> entry : this.m_rootDirectoryPathToAddedFiles.entrySet()) {
                Map<IFileType, List<TFile>> map = entry.getValue();
                for (List<TFile> files : map.values()) {
                    added.addAll(files);
                }
            }
            for (FilePath next : this.m_deleted) {
                if (this.m_modified.contains(next)) {
                    builder.append("Modified path also recorded as deleted: ").append(next.getAbsolutePath()).append("\n");
                }
                if (added.stream().anyMatch(f -> FileUtility.areEqual((TFile)f, (TFile)next.getFile()))) {
                    builder.append("Added path also recorded as deleted: ").append(next.getAbsolutePath()).append("\n");
                }
                if (next.isValid()) continue;
                builder.append("Deleted file not valid: ").append(next.getAbsolutePath()).append("\n");
            }
            for (FilePath next : this.m_modified) {
                if (added.stream().anyMatch(f -> FileUtility.areEqual((TFile)f, (TFile)next.getFile()))) {
                    builder.append("Added path also recorded as modified: ").append(next.getAbsolutePath()).append("\n");
                }
                if (next.isValid()) continue;
                builder.append("Modified file not valid: ").append(next.getAbsolutePath()).append("\n");
            }
            assert (builder.length() == 0) : "Delta not consistent: " + builder.toString();
        }
    }

    private boolean isAdded(FilePath filePath, boolean remove) {
        List<TFile> addedFilesAsList;
        Map<IFileType, List<TFile>> fileTypeMap;
        assert (filePath != null) : "Parameter 'filePath' of method 'isAdded' must not be null";
        RootDirectoryPath root = filePath.getParent(RootDirectoryPath.class, new Class[0]);
        if (root != null && (fileTypeMap = this.m_rootDirectoryPathToAddedFiles.get(root)) != null && (addedFilesAsList = fileTypeMap.get(filePath.getFileType())) != null) {
            Iterator<TFile> iterator = addedFilesAsList.iterator();
            while (iterator.hasNext()) {
                TFile nextAlreadyAdded = iterator.next();
                if (!FileUtility.areEqual((TFile)nextAlreadyAdded, (TFile)filePath.getFile())) continue;
                if (remove) {
                    iterator.remove();
                }
                return true;
            }
        }
        return false;
    }

    private FilePath removeMatchingPath(IFileType fileType, TFile file, Set<FilePath> existingFilePaths) {
        assert (fileType != null) : "Parameter 'fileType' of method 'removeMatchingPath' must not be null";
        assert (file != null) : "Parameter 'file' of method 'removeMatchingPath' must not be null";
        assert (existingFilePaths != null) : "Parameter 'existingFilePaths' of method 'removeMatchingPath' must not be null";
        List previousFiles = existingFilePaths.stream().filter(m -> m.getFileType() == fileType).filter(m -> FileUtility.areEqual((TFile)m.getFile(), (TFile)file)).collect(Collectors.toList());
        assert (previousFiles.size() <= 1) : "Unexpected number of files for " + String.valueOf(file);
        if (previousFiles.size() == 1) {
            boolean removed = existingFilePaths.remove(previousFiles.get(0));
            assert (removed) : "Not removed from previous files: " + String.valueOf(previousFiles.get(0));
            return (FilePath)previousFiles.get(0);
        }
        return null;
    }

    private boolean replaceAddedIfAlreadyExists(RootDirectoryPath rootDirectoryPath, IFileType fileType, TFile added) {
        List<TFile> alreadyAdded;
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'getAdded' must not be null";
        assert (fileType != null) : "Parameter 'fileType' of method 'getAdded' must not be null";
        Map<IFileType, List<TFile>> fileTypeToFile = this.m_rootDirectoryPathToAddedFiles.get(rootDirectoryPath);
        if (fileTypeToFile != null && (alreadyAdded = fileTypeToFile.get(fileType)) != null) {
            boolean replace = false;
            int i = 0;
            while (i < alreadyAdded.size()) {
                if (FileUtility.areEqual((TFile)alreadyAdded.get(0), (TFile)added)) {
                    replace = true;
                    break;
                }
                ++i;
            }
            if (replace) {
                alreadyAdded.set(i, added);
                return true;
            }
        }
        return false;
    }

    public void integrate(ModuleDelta deltaToIntegrate) {
        boolean added;
        assert (deltaToIntegrate != null) : "Parameter 'delta' of method 'integrate' must not be null";
        for (FilePath filePath : deltaToIntegrate.m_deleted) {
            added = this.isAdded(filePath, true);
            this.m_modified.remove(filePath);
            if (added) continue;
            this.m_deleted.add(filePath);
        }
        for (FilePath filePath : deltaToIntegrate.m_modified) {
            added = this.isAdded(filePath, false);
            this.m_deleted.remove(filePath);
            if (added) continue;
            this.m_modified.add(filePath);
        }
        for (Map.Entry entry : deltaToIntegrate.m_rootDirectoryPathToAddedFiles.entrySet()) {
            for (Map.Entry nextTypeMap : ((Map)entry.getValue()).entrySet()) {
                IFileType fileType = (IFileType)nextTypeMap.getKey();
                List files = (List)nextTypeMap.getValue();
                for (TFile nextAdded : files) {
                    FilePath previousModified = this.removeMatchingPath(fileType, nextAdded, this.m_modified);
                    FilePath previousDeleted = this.removeMatchingPath(fileType, nextAdded, this.m_deleted);
                    if (previousModified == null && previousDeleted == null) {
                        if (this.replaceAddedIfAlreadyExists((RootDirectoryPath)entry.getKey(), fileType, nextAdded)) continue;
                        this.added((RootDirectoryPath)entry.getKey(), fileType, nextAdded);
                        continue;
                    }
                    if (previousModified != null) {
                        this.m_modified.add(previousModified);
                        continue;
                    }
                    if (previousDeleted == null) continue;
                    this.m_modified.add(previousDeleted);
                }
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_module.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleDelta other = (ModuleDelta)obj;
        return this.m_module == other.m_module;
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder("Delta of module '");
        builder.append(this.m_module.getName()).append("' ");
        if (this.isEmpty()) {
            builder.append("<<empty>>");
        } else {
            builder.append("[").append(this.m_deleted.size()).append(" deleted, ").append(this.m_modified.size()).append(" modified, ").append(this.getNumberOfAddedFiles()).append(" added").append("]");
        }
        return builder.toString();
    }

    public String toString() {
        final StringBuilder builder = new StringBuilder();
        if (this.isEmpty()) {
            builder.append("<<empty>>");
        } else {
            builder.append("[").append(this.m_deleted.size()).append(" deleted, ").append(this.m_modified.size()).append(" modified, ").append(this.getNumberOfAddedFiles()).append(" added").append("]");
            builder.append(StringUtility.LINE_SEPARATOR);
            IVisitor visitor = new IVisitor(){

                @Override
                public void modified(ModuleDelta delta, FilePath filePath) {
                    builder.append("Modified: ");
                    builder.append(filePath);
                    builder.append(StringUtility.LINE_SEPARATOR);
                }

                @Override
                public void deleted(ModuleDelta delta, FilePath filePath) {
                    builder.append("Deleted: ");
                    builder.append(filePath);
                    builder.append(StringUtility.LINE_SEPARATOR);
                }

                @Override
                public void added(RootDirectoryPath root, IFileType fileType, TFile file) {
                    builder.append("Added: ");
                    builder.append(file.getAbsolutePath());
                    builder.append(" (");
                    builder.append(root);
                    builder.append(")");
                    builder.append(StringUtility.LINE_SEPARATOR);
                }
            };
            this.visitDeleted(visitor);
            this.visitModified(visitor);
            this.visitAdded(visitor);
        }
        return builder.toString();
    }

    public static interface IVisitor {
        public void deleted(ModuleDelta var1, FilePath var2);

        public void modified(ModuleDelta var1, FilePath var2);

        public void added(RootDirectoryPath var1, IFileType var2, TFile var3);
    }

    public static enum SortOrder {
        NONE,
        ASCENDING,
        DESCENDING;

    }
}

