/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.DynamicIssueId;
import com.hello2morrow.sonargraph.core.model.script.ScriptProviderId;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.Collections;
import java.util.List;

public final class ScriptIssueId
extends DynamicIssueId {
    public static final String ISSUE_TYPE_CLASS = "Script";
    private final String m_id;
    private final Severity m_severity;
    private final ScriptProviderId m_providerId;

    public ScriptIssueId(String id, Severity severity, ScriptProviderId providerId) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'ScriptIssueId' must not be empty";
        assert (severity != null) : "Parameter 'severity' of method 'ScriptIssueId' must not be null";
        assert (providerId != null) : "Parameter 'providerId' of method 'ScriptIssueId' must not be null";
        this.m_id = id;
        this.m_severity = severity;
        this.m_providerId = providerId;
    }

    @Override
    public IIssueId.PatternEditMode getPatternEditMode() {
        return IIssueId.PatternEditMode.UNEDITABLE;
    }

    public String getStandardName() {
        return this.m_id;
    }

    public String getPresentationName() {
        return this.m_id;
    }

    public ScriptProviderId getProvider() {
        return this.m_providerId;
    }

    @Override
    public String getProviderName() {
        return this.m_providerId.getStandardName();
    }

    @Override
    @Property
    public String getInformation() {
        return this.m_providerId.getIdentifier();
    }

    @Override
    public IssueCategory getCategory() {
        return IssueCategory.SCRIPT_BASED;
    }

    @Override
    public List<Severity> getSupportedSeverities() {
        return Collections.singletonList(this.m_severity);
    }

    @Override
    public boolean isParserModelIssue() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_id.hashCode();
        result = 31 * result + this.m_severity.hashCode();
        result = 31 * result + this.m_providerId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptIssueId other = (ScriptIssueId)obj;
        return this.m_id.equals(other.m_id) && this.m_severity.equals((Object)other.m_severity) && this.m_providerId.equals(other.m_providerId);
    }

    public String toString() {
        return this.m_id + "/" + this.m_severity.getStandardName() + "/" + String.valueOf(this.m_providerId);
    }

    @Override
    public String getDebugInfo() {
        return super.getDebugInfo() + " defined in '" + this.m_providerId.getIdentifier() + "'";
    }
}

