/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.report;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.LastScriptRunnerExecutionStatus;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.IssueList;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.MetricValue;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.report.CycleGroupIssueComparator;
import com.hello2morrow.sonargraph.core.model.report.IBasicReport;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.report.MetricLevelComparator;
import com.hello2morrow.sonargraph.core.model.report.MetricRow;
import com.hello2morrow.sonargraph.core.model.report.MetricRowComparator;
import com.hello2morrow.sonargraph.core.model.report.MetricValueComparator;
import com.hello2morrow.sonargraph.core.model.report.ReportComparator;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfileProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultStatus;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Report
implements IReport {
    private final long m_timestamp;
    private final Version m_version;
    private final SoftwareSystem m_system;
    private final String m_currentVirtualModel;
    private final AnalyzerExecutionLevel m_analyzerExecutionLevel;
    private final String m_activeProfile;
    private final String m_qualityModelPath;
    private String m_baselinePath;
    private final Map<IMetricCategory, Map<IMetricDescriptor, IMetricValue>> m_systemLevelMetrics = new TreeMap<IMetricCategory, Map<IMetricDescriptor, IMetricValue>>(ReportComparator.createMetricCategoryComparator());
    private final Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>> m_systemElementMetrics = new LinkedHashMap<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>>();
    private final Map<Module, Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>>> m_moduleLevelMetrics = new LinkedHashMap<Module, Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>>>();
    private final Set<NamedElement> m_systemElements = new LinkedHashSet<NamedElement>();
    private final Map<Module, Set<NamedElement>> m_moduleElements = new TreeMap<Module, Set<NamedElement>>(Comparator.comparing(Module::getName));
    private final Map<External, Set<NamedElement>> m_externalSystemScopeElements = new TreeMap<External, Set<NamedElement>>(Comparator.comparing(NamedElement::getName));
    private final Map<External, Set<NamedElement>> m_externalModuleScopeElements = new TreeMap<External, Set<NamedElement>>(Comparator.comparing(NamedElement::getName));
    private final Map<IMetricId, Set<IMetricLevel>> m_metricIdToLevel = new LinkedHashMap<IMetricId, Set<IMetricLevel>>();
    private final Set<IIssueId> m_issueIds = new LinkedHashSet<IIssueId>();
    private final Set<IssueCategory> m_issueCategories = new LinkedHashSet<IssueCategory>();
    private final Set<IProviderId> m_issueProviderIds = new LinkedHashSet<IProviderId>();
    private final Map<IMetricThreshold, List<ThresholdViolationIssue>> m_thresholdToIssues = new LinkedHashMap<IMetricThreshold, List<ThresholdViolationIssue>>();
    private final List<NamedElementIssue> m_namedElementIssues = new ArrayList<NamedElementIssue>();
    private final List<DuplicateCodeBlockIssue> m_duplicateIssues = new ArrayList<DuplicateCodeBlockIssue>();
    private final List<DependencyIssue> m_dependencyIssues = new ArrayList<DependencyIssue>();
    private final Map<IAnalyzerId, List<CycleGroupIssue>> m_cycleAnalyzersToIssues = new HashMap<IAnalyzerId, List<CycleGroupIssue>>();
    private final List<Resolution> m_resolutions = new ArrayList<Resolution>();
    private final List<SonargraphFeature> m_unavailableFeatures = new ArrayList<SonargraphFeature>();
    private final List<SonargraphFeature> m_availableFeatures = new ArrayList<SonargraphFeature>();
    private final List<IAnalyzerId> m_unlicensedAnalyzers = new ArrayList<IAnalyzerId>();
    private final List<IAnalyzerId> m_licensedAnalyzers = new ArrayList<IAnalyzerId>();
    private final List<Pair<SonargraphPlugin, IAnalyzerId>> m_analyzerPlugins = new ArrayList<Pair<SonargraphPlugin, IAnalyzerId>>();
    private final List<SonargraphPlugin> m_modelPlugins = new ArrayList<SonargraphPlugin>();
    private final Map<SonargraphPlugin, Pair<PluginConfigurationFile, List<Pair<SonargraphPluginAttribute, String>>>> m_pluginToConfigurationMap = new TreeMap<SonargraphPlugin, Pair<PluginConfigurationFile, List<Pair<SonargraphPluginAttribute, String>>>>(ReportComparator.createPluginComparator());
    private final List<String> m_duplicateCodeConfigurationEntries = new ArrayList<String>();
    private final List<String> m_architectureCheckConfigurationEntries = new ArrayList<String>();
    private final List<StrictPair<ArchitectureFile, String>> m_checkedArchitectureAndHashPairs = new ArrayList<StrictPair<ArchitectureFile, String>>();
    private Map<IAnalyzerId, List<CycleGroupIssue>> m_calculatedCycleIssues;
    private Map<IAnalyzerId, List<CycleGroupIssue>> m_unresolvedCycleIssues;
    private List<Issue> m_unresolvedIssues;
    private List<DuplicateCodeBlockIssue> m_calculatedDuplicateIssues;
    private List<DuplicateCodeBlockIssue> m_unresolvedDuplicateIssues;
    private LastScriptRunnerExecutionStatus m_lastScriptRunnerExecutionStatus;
    private ScriptRunnerConfiguration m_scriptRunnerConfiguration;
    private final List<CycleAnalyzerConfiguration> m_cycleAnalyzerConfigurations = new ArrayList<CycleAnalyzerConfiguration>();
    private List<String> m_checkedQualityGateFiles;
    private final Map<QualityGate, QualityGateResult> m_qualityGateToResultMap = new LinkedHashMap<QualityGate, QualityGateResult>();
    private TFile m_targetFile;
    private final String m_reportContextInfo;
    private Set<Element> m_issuesAffectingQualityGates;
    private Set<Element> m_metricValuesAffectingQualityGates;
    private List<IssueRank> m_issueRankings = Collections.emptyList();

    public Report(Version version, SoftwareSystem system, List<SonargraphFeature> availableFeatures, List<SonargraphFeature> unavailableFeatures, AnalyzerExecutionLevel analyzerExecutionLevel, String reportContextInfo, long timestamp) {
        assert (version != null) : "Parameter 'version' of method 'Report' must not be null";
        assert (system != null) : "Parameter 'system' of method 'Report' must not be null";
        assert (availableFeatures != null) : "Parameter 'availableFeatures' of method 'Report' must not be null";
        assert (unavailableFeatures != null) : "Parameter 'unavailableFeatures' of method 'Report' must not be null";
        assert (analyzerExecutionLevel != null) : "Parameter 'analyzerExecutionLevel' of method 'Report' must not be null";
        this.m_version = version;
        this.m_system = system;
        this.m_availableFeatures.addAll(availableFeatures);
        this.m_unavailableFeatures.addAll(unavailableFeatures);
        this.m_timestamp = timestamp;
        this.m_currentVirtualModel = this.m_system.getCurrentModel().getPresentationName(true);
        this.m_systemElements.add(this.m_system);
        WorkspaceProfile workspaceProfile = this.m_system.getExtension(IWorkspaceProfileProvider.class).getWorkspaceProfile();
        this.m_activeProfile = workspaceProfile != null ? workspaceProfile.getPresentationName(true) : "";
        TFile externalQualityModel = system.getExternalQualityModel();
        this.m_qualityModelPath = externalQualityModel != null ? externalQualityModel.getNormalizedAbsolutePath() : "";
        this.m_analyzerExecutionLevel = analyzerExecutionLevel;
        this.m_reportContextInfo = reportContextInfo;
    }

    @Override
    public String getQualityModelPath() {
        return this.m_qualityModelPath;
    }

    @Override
    public long getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public Version getVersion() {
        return this.m_version;
    }

    @Override
    public String getCurrentVirtualModel() {
        return this.m_currentVirtualModel;
    }

    @Override
    public List<Language> getUsedLanguages() {
        return new ArrayList<Language>(this.m_system.getUsedLanguages());
    }

    @Override
    public String getActiveProfile() {
        return this.m_activeProfile;
    }

    @Override
    public List<IMetricId> getMetricIds() {
        return Collections.unmodifiableList(this.m_metricIdToLevel.keySet().stream().sorted(Comparator.comparing(IStandardEnumeration::getPresentationName)).collect(Collectors.toList()));
    }

    @Override
    public Map<IMetricId, List<IMetricLevel>> getMetricIdsAsMap() {
        TreeMap result = new TreeMap(Comparator.comparing(IStandardEnumeration::getPresentationName));
        this.m_metricIdToLevel.entrySet().stream().forEach(e -> {
            ArrayList arrayList = result.put((IMetricId)e.getKey(), new ArrayList((Collection)e.getValue()));
        });
        return Collections.unmodifiableMap(result);
    }

    public void addSystemLevelMetricAndValue(IMetricDescriptor descriptor, IMetricValue value) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'addValueForLevelAndMetric' must not be null";
        assert (value != null) : "Parameter 'value' of method 'addValueForLevelAndMetric' must not be null";
        this.addMetricIdAndLevel(descriptor.getMetricId(), CoreMetricLevel.SYSTEM);
        IMetricCategory mainCategory = descriptor.getMetricId().getCategories().get(0);
        if (!this.m_systemLevelMetrics.containsKey(mainCategory)) {
            TreeMap<IMetricDescriptor, IMetricValue> valueMap = new TreeMap<IMetricDescriptor, IMetricValue>(ReportComparator.createMetricDescriptorComparator());
            valueMap.put(descriptor, value);
            this.m_systemLevelMetrics.put(mainCategory, valueMap);
        }
        this.m_systemLevelMetrics.get(mainCategory).put(descriptor, value);
    }

    private void addMetricIdAndLevel(IMetricId metricId, IMetricLevel level) {
        assert (metricId != null) : "Parameter 'metricId' of method 'addMetricId' must not be null";
        assert (level != null) : "Parameter 'level' of method 'addMetricId' must not be null";
        Set<IMetricLevel> levels = this.m_metricIdToLevel.get(metricId);
        if (levels == null) {
            levels = new TreeSet<IMetricLevel>(new IMetricLevel.MetricLevelComparator());
            this.m_metricIdToLevel.put(metricId, levels);
        }
        levels.add(level);
    }

    public void addSystemElementMetricAndValue(IMetricDescriptor descriptor, IMetricLevel level, IMetricValue value, NamedElement associatedElement) {
        List<IMetricValue> values;
        Map descriptorMap;
        IMetricCategory mainCategory;
        Map<IMetricCategory, Object> levelMap;
        assert (descriptor != null) : "Parameter 'descriptor' of method 'addValueForLevelAndMetric' must not be null";
        assert (level != null) : "Parameter 'level' of method 'addLogicalSystemElementMetricAndValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'addValueForLevelAndMetric' must not be null";
        assert (associatedElement != null) : "Parameter 'associatedElement' of method 'addModuleLevelMetricAndValue' must not be null";
        this.m_systemElements.add(associatedElement);
        this.addMetricIdAndLevel(descriptor.getMetricId(), level);
        if (!this.m_systemElementMetrics.containsKey(level)) {
            levelMap = new TreeMap(ReportComparator.createMetricCategoryComparator());
            this.m_systemElementMetrics.put(level, levelMap);
        }
        if (!(levelMap = this.m_systemElementMetrics.get(level)).containsKey(mainCategory = descriptor.getMetricId().getCategories().get(0))) {
            descriptorMap = new TreeMap(ReportComparator.createMetricDescriptorComparator());
            levelMap.put(mainCategory, descriptorMap);
        }
        if (!(descriptorMap = (Map)levelMap.get(mainCategory)).containsKey(descriptor)) {
            values = new ArrayList();
            descriptorMap.put(descriptor, values);
        }
        values = (List)descriptorMap.get(descriptor);
        values.add(value);
    }

    public void addModuleLevelMetricAndValue(Module module, IMetricLevel level, IMetricDescriptor descriptor, IMetricValue value, NamedElement element) {
        assert (module != null) : "Parameter 'module' of method 'addModuleLevelMetricAndValue' must not be null";
        assert (level != null) : "Parameter 'level' of method 'addValueForLevelAndMetric' must not be null";
        assert (level != CoreMetricLevel.SYSTEM) : "Parameter 'level' must not be 'CoreMetricLevel.SYSTEM'";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'addValueForLevelAndMetric' must not be null";
        assert (value != null) : "Parameter 'value' of method 'addValueForLevelAndMetric' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addModuleLevelMetricAndValue' must not be null";
        this.addMetricIdAndLevel(descriptor.getMetricId(), level);
        this.getOrCreateModuleMetricLevel(module, level, descriptor).add(value);
        this.addModuleElement(module, element);
    }

    public void addModuleElement(Module module, NamedElement element) {
        assert (module != null) : "Parameter 'module' of method 'addModuleElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addModuleElement' must not be null";
        Set<NamedElement> moduleElements = this.m_moduleElements.get(module);
        if (moduleElements == null) {
            moduleElements = new LinkedHashSet<NamedElement>();
            this.m_moduleElements.put(module, moduleElements);
        }
        moduleElements.add(element);
    }

    public void addExternalSystemScopeElement(External external, NamedElement element) {
        assert (external != null) : "Parameter 'external' of method 'addExternalSystemScopeElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addExternalSystemScopeElement' must not be null";
        Set<NamedElement> externalElements = this.m_externalSystemScopeElements.get(external);
        if (externalElements == null) {
            externalElements = new LinkedHashSet<NamedElement>();
            this.m_externalSystemScopeElements.put(external, externalElements);
        }
        externalElements.add(element);
    }

    public void addExternalModuleScopeElement(External external, NamedElement element) {
        assert (external != null) : "Parameter 'external' of method 'addExternalModuleScopeElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addExternalModuleScopeElement' must not be null";
        Set<NamedElement> externalElements = this.m_externalModuleScopeElements.get(external);
        if (externalElements == null) {
            externalElements = new LinkedHashSet<NamedElement>();
            this.m_externalModuleScopeElements.put(external, externalElements);
        }
        externalElements.add(element);
    }

    private List<IMetricValue> getOrCreateModuleMetricLevel(Module module, IMetricLevel level, IMetricDescriptor descriptor) {
        List<IMetricValue> metricValues;
        IMetricCategory category;
        Map<IMetricDescriptor, List<IMetricValue>> categoryMetrics;
        Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>> levelMetricCategories;
        Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>> moduleLevels = this.m_moduleLevelMetrics.get(module);
        if (moduleLevels == null) {
            moduleLevels = new LinkedHashMap<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>>();
            this.m_moduleLevelMetrics.put(module, moduleLevels);
        }
        if ((levelMetricCategories = moduleLevels.get(level)) == null) {
            levelMetricCategories = new TreeMap<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>(ReportComparator.createMetricCategoryComparator());
            moduleLevels.put(level, levelMetricCategories);
        }
        if ((categoryMetrics = levelMetricCategories.get(category = descriptor.getMetricId().getCategories().get(0))) == null) {
            categoryMetrics = new TreeMap<IMetricDescriptor, List<IMetricValue>>(ReportComparator.createMetricDescriptorComparator());
            levelMetricCategories.put(category, categoryMetrics);
        }
        if ((metricValues = categoryMetrics.get(descriptor)) == null) {
            metricValues = new ArrayList<IMetricValue>();
            categoryMetrics.put(descriptor, metricValues);
        }
        return metricValues;
    }

    @Override
    public List<IMetricLevel> getLevels() {
        List levels = this.m_metricIdToLevel.values().stream().flatMap(list -> list.stream()).distinct().sorted(Comparator.comparing(IMetricLevel::getOrderNumber)).collect(Collectors.toList());
        return Collections.unmodifiableList(new ArrayList(levels));
    }

    @Override
    public Map<IMetricCategory, Map<IMetricDescriptor, IMetricValue>> getSystemLevelMetrics() {
        return Collections.unmodifiableMap(this.m_systemLevelMetrics);
    }

    @Override
    public Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>> getSystemElementMetrics() {
        return Collections.unmodifiableMap(this.m_systemElementMetrics);
    }

    @Override
    public SoftwareSystem getSoftwareSystem() {
        return this.m_system;
    }

    @Override
    public String getSystemDirectoryPath() {
        return this.m_system.getUniqueExistingChild(Files.class).getSystemDirectory().getFile().getNormalizedAbsolutePath();
    }

    @Override
    public List<WildcardPattern> getWorkspaceFilters() {
        return this.m_system.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().getChildren(WildcardPattern.class);
    }

    @Override
    public List<WildcardPattern> getProductionCodeFilters() {
        return this.m_system.getUniqueExistingChild(Workspace.class).getProductionCodeFilter().getChildren(WildcardPattern.class);
    }

    @Override
    public List<WildcardPattern> getIssueFilters() {
        return this.m_system.getUniqueExistingChild(Workspace.class).getIssueFilter().getChildren(WildcardPattern.class);
    }

    @Override
    public Map<Module, Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>>> getModuleMetrics() {
        return Collections.unmodifiableMap(this.m_moduleLevelMetrics);
    }

    @Override
    public Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, Collection<MetricRow>>>> getElementMetricsForPrint(int maxMetricValueRowCountPerMetric) {
        MetricValueComparator valueComparator = new MetricValueComparator();
        MetricRowComparator metricRowComparator = new MetricRowComparator(valueComparator);
        TreeMap<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, Collection<MetricRow>>>> tableMap = new TreeMap<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, Collection<MetricRow>>>>(new MetricLevelComparator());
        this.addLevelsForPrint(metricRowComparator, tableMap, this.m_systemElementMetrics.entrySet());
        for (Map.Entry<Module, Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>>> entry : this.m_moduleLevelMetrics.entrySet()) {
            this.addLevelsForPrint(metricRowComparator, tableMap, entry.getValue().entrySet());
        }
        for (Map.Entry<Module, Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>>> entry : tableMap.entrySet()) {
            if (entry.getKey() == CoreMetricLevel.SYSTEM) continue;
            this.reduceMetricValues(entry.getValue(), maxMetricValueRowCountPerMetric);
        }
        return tableMap;
    }

    private void reduceMetricValues(Map<IMetricCategory, Map<IMetricDescriptor, Collection<MetricRow>>> categoryMap, int maxMetricValueRowCountPerMetric) {
        for (Map<IMetricDescriptor, Collection<MetricRow>> nextDescriptorMap : categoryMap.values()) {
            for (Map.Entry<IMetricDescriptor, Collection<MetricRow>> nextEntry : nextDescriptorMap.entrySet()) {
                nextEntry.setValue(nextEntry.getValue().stream().limit(maxMetricValueRowCountPerMetric).collect(Collectors.toList()));
            }
        }
    }

    private void addLevelsForPrint(Comparator<MetricRow> metricRowComparator, Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, Collection<MetricRow>>>> tableMap, Set<Map.Entry<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>>> valuesSet) {
        for (Map.Entry<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>> nextLevel : valuesSet) {
            Map<IMetricCategory, Map<IMetricDescriptor, Collection<MetricRow>>> table = tableMap.get(nextLevel.getKey());
            if (table == null) {
                table = new TreeMap<IMetricCategory, Map<IMetricDescriptor, Collection<MetricRow>>>(ReportComparator.createMetricCategoryComparator());
                tableMap.put(nextLevel.getKey(), table);
            }
            for (Map.Entry<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>> nextCategory : nextLevel.getValue().entrySet()) {
                Map<IMetricDescriptor, Collection<MetricRow>> rows = table.get(nextCategory.getKey());
                if (rows == null) {
                    rows = new TreeMap<IMetricDescriptor, Collection<MetricRow>>(ReportComparator.createMetricDescriptorComparator());
                    table.put(nextCategory.getKey(), rows);
                }
                for (Map.Entry<IMetricDescriptor, List<IMetricValue>> nextMetrics : nextCategory.getValue().entrySet()) {
                    Collection<MetricRow> descriptorRows = rows.get(nextMetrics.getKey());
                    if (descriptorRows == null) {
                        descriptorRows = new TreeSet<MetricRow>(metricRowComparator);
                        rows.put(nextMetrics.getKey(), descriptorRows);
                    }
                    for (IMetricValue nextMetricValue : nextMetrics.getValue()) {
                        if (nextMetricValue.getValue() == null) continue;
                        MetricRow row = new MetricRow(nextMetrics.getKey().getMetricId(), nextLevel.getKey(), nextMetricValue);
                        descriptorRows.add(row);
                    }
                }
            }
        }
    }

    @Override
    public Set<NamedElement> getSystemElements() {
        return new LinkedHashSet<NamedElement>(this.m_systemElements);
    }

    @Override
    public Map<Module, Set<NamedElement>> getModuleElements() {
        return Collections.unmodifiableMap(this.m_moduleElements);
    }

    @Override
    public Map<External, Set<NamedElement>> getExternalSystemScopeElements() {
        return Collections.unmodifiableMap(this.m_externalSystemScopeElements);
    }

    @Override
    public Map<External, Set<NamedElement>> getExternalModuleScopeElements() {
        return Collections.unmodifiableMap(this.m_externalModuleScopeElements);
    }

    public void addElementIssue(NamedElementIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addIssue' must not be null";
        this.m_issueIds.add(issue.getId());
        this.m_issueProviderIds.add(issue.getProvider());
        if (issue instanceof ThresholdViolationIssue) {
            ThresholdViolationIssue thIssue = (ThresholdViolationIssue)issue;
            IMetricThreshold threshold = thIssue.getThreshold();
            List<ThresholdViolationIssue> thresholdIssues = this.m_thresholdToIssues.get(threshold);
            if (thresholdIssues == null) {
                thresholdIssues = new ArrayList<ThresholdViolationIssue>();
                this.m_thresholdToIssues.put(threshold, thresholdIssues);
            }
            thresholdIssues.add(thIssue);
            NamedElement affectedElement = thIssue.getAffectedElement();
            this.addAffectedElement(affectedElement);
        } else if (issue instanceof DuplicateCodeBlockIssue) {
            DuplicateCodeBlockIssue duplicateIssue = (DuplicateCodeBlockIssue)issue;
            this.m_duplicateIssues.add(duplicateIssue);
            DuplicateCodeBlock block = (DuplicateCodeBlock)duplicateIssue.getAffectedElement();
            for (DuplicateCodeBlockOccurrence occurrence : block.getChildren(DuplicateCodeBlockOccurrence.class)) {
                SourceFile sourceFile = occurrence.getSourceFile();
                Module module = sourceFile.getParent(Module.class, new Class[0]);
                this.addModuleElement(module, sourceFile);
            }
        } else if (issue instanceof CycleGroupIssue) {
            CycleGroupIssue cycleIssue = (CycleGroupIssue)issue;
            AnalyzerCycleGroup affectedElement = cycleIssue.getAffectedElement();
            Analyzer analyzer = affectedElement.getParent(Analyzer.class, new Class[0]);
            assert (analyzer != null) : "no analyzer as parent present of '" + affectedElement.getDebugInfo() + "'";
            List<CycleGroupIssue> cycleIssuesForAnalyzer = this.m_cycleAnalyzersToIssues.get(analyzer.getId());
            if (cycleIssuesForAnalyzer == null) {
                cycleIssuesForAnalyzer = new ArrayList<CycleGroupIssue>();
                this.m_cycleAnalyzersToIssues.put(analyzer.getId(), cycleIssuesForAnalyzer);
            }
            cycleIssuesForAnalyzer.add(cycleIssue);
            for (NamedElement element : ((CycleGroup)affectedElement).getCyclicNamedElements()) {
                this.addAffectedElement(element);
            }
        } else if (!issue.previewOnly()) {
            this.m_namedElementIssues.add(issue);
            NamedElementIssue namedElementIssue = issue;
            NamedElement affectedElement = namedElementIssue.getAffectedElement();
            this.addAffectedElement(affectedElement);
        }
    }

    private void addAffectedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'addAffectedElement' must not be null";
        if (element instanceof SoftwareSystem || element instanceof Module || element instanceof External || element instanceof RootDirectoryPath || element instanceof IQualityGateElement) {
            return;
        }
        Module module = null;
        ModuleBasedLogicalNamespaceRoot moduleBasedLogicalNamespaceRoot = element.getParent(ModuleBasedLogicalNamespaceRoot.class, ParentMode.SELF_OR_FIRST_PARENT);
        module = moduleBasedLogicalNamespaceRoot != null ? moduleBasedLogicalNamespaceRoot.getPhysicalElement() : element.getParent(Module.class, new Class[0]);
        if (module != null) {
            this.addModuleElement(module, element);
            return;
        }
        External external = null;
        ExternalLogicalNamespaceRoot externalLogicalNamespaceRoot = element.getParent(ExternalLogicalNamespaceRoot.class, ParentMode.SELF_OR_FIRST_PARENT);
        if (externalLogicalNamespaceRoot != null) {
            Language language = externalLogicalNamespaceRoot.getLanguage();
            assert (language != null) : "'language' of method 'addElement' must not be null";
            for (External nextExternal : this.getSoftwareSystem().getUniqueChild(Workspace.class).getChildren(External.class)) {
                Language nextLanguage = nextExternal.getLanguage();
                assert (nextLanguage != null) : "'nextLanguage' of method 'addElement' must not be null";
                if (!language.equals(nextLanguage)) continue;
                external = nextExternal;
                break;
            }
            assert (external != null) : "'external' of method 'addElement' must not be null";
        } else {
            external = element.getParent(External.class, new Class[0]);
        }
        if (external != null) {
            IDomainRoot.Domain domain = element.getDomain();
            if (domain != null && domain.equals((Object)IDomainRoot.Domain.LOGICAL_MODULE_SCOPE)) {
                this.addExternalModuleScopeElement(external, element);
            } else {
                this.addExternalSystemScopeElement(external, element);
            }
            return;
        }
        this.m_systemElements.add(element);
    }

    @Override
    public int getTotalNumberOfIssues() {
        return this.m_namedElementIssues.size() + this.m_dependencyIssues.size() + this.m_duplicateIssues.size() + this.getNumberOfThresholdViolations() + this.getNumberOfElements(this.m_calculatedCycleIssues);
    }

    @Override
    public List<Issue> getUnresolvedIssues() {
        assert (this.m_unresolvedIssues != null) : "call performCalculations() first!";
        return this.m_unresolvedIssues;
    }

    @Override
    public List<NamedElementIssue> getNamedElementIssues() {
        return Collections.unmodifiableList(this.m_namedElementIssues);
    }

    private List<DuplicateCodeBlockIssue> calculateDuplicateIssues() {
        List sorted = this.m_duplicateIssues.stream().sorted((d1, d2) -> -1 * Integer.compare(((DuplicateCodeBlock)d1.getAffectedElement()).getBlockSize(), ((DuplicateCodeBlock)d2.getAffectedElement()).getBlockSize())).collect(Collectors.toList());
        return Collections.unmodifiableList(sorted);
    }

    private List<DuplicateCodeBlockIssue> calculateUnresolvedDuplicateIssues() {
        List sorted = this.m_duplicateIssues.stream().filter(d -> d.getResolution() == null).sorted((d1, d2) -> -1 * Integer.compare(((DuplicateCodeBlock)d1.getAffectedElement()).getBlockSize(), ((DuplicateCodeBlock)d2.getAffectedElement()).getBlockSize())).collect(Collectors.toList());
        return Collections.unmodifiableList(sorted);
    }

    private Map<IAnalyzerId, List<CycleGroupIssue>> calculateCycleIssues() {
        CycleGroupIssueComparator comparator = new CycleGroupIssueComparator();
        this.m_cycleAnalyzersToIssues.values().forEach(i -> i.sort(comparator));
        return Collections.unmodifiableMap(this.m_cycleAnalyzersToIssues);
    }

    @Override
    public Map<IAnalyzerId, List<CycleGroupIssue>> getCycleIssues() {
        assert (this.m_calculatedCycleIssues != null) : "call performCalculations() first!";
        return this.m_calculatedCycleIssues;
    }

    @Override
    public Map<IAnalyzerId, List<CycleGroupIssue>> getUnresolvedCycleIssues() {
        assert (this.m_unresolvedCycleIssues != null) : "call performCalculations() first!";
        return this.m_unresolvedCycleIssues;
    }

    private Map<IAnalyzerId, List<CycleGroupIssue>> calculateUnresolvedCycleIssues() {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<IAnalyzerId, List<CycleGroupIssue>> next : this.m_cycleAnalyzersToIssues.entrySet()) {
            List sorted = next.getValue().stream().filter(c -> c.getResolution() == null).sorted((c1, c2) -> Integer.compare(c1.getAffectedElement().getNumberOfCyclicElements(), c2.getAffectedElement().getNumberOfCyclicElements()) * -1).collect(Collectors.toList());
            result.put(next.getKey(), sorted);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Set<IProviderId> getIssueProviderIds() {
        return Collections.unmodifiableSet(this.m_issueProviderIds);
    }

    public void setIssueCategories(Collection<IssueCategory> categories) {
        assert (categories != null && categories.size() > 0) : "Parameter 'categories' of method 'setIssueCategories' must not be empty";
        this.m_issueCategories.addAll(categories);
    }

    @Override
    public Set<IssueCategory> getIssueCategories() {
        return Collections.unmodifiableSet(this.m_issueCategories);
    }

    @Override
    public Set<IIssueId> getIssueIds() {
        return Collections.unmodifiableSet(this.m_issueIds);
    }

    public void addDependencyIssue(DependencyIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addDependencyIssue' must not be null";
        this.m_issueIds.add(issue.getId());
        this.m_issueProviderIds.add(issue.getProvider());
        Dependency dependency = issue.getAffectedElement();
        this.addAffectedElement(dependency.getUnderlyingFrom());
        this.addAffectedElement(dependency.getUnderlyingTo());
        this.m_dependencyIssues.add(issue);
    }

    @Override
    public List<DependencyIssue> getDependencyIssues() {
        return Collections.unmodifiableList(this.m_dependencyIssues);
    }

    public void addResolution(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'addResolution' must not be null";
        this.m_resolutions.add(resolution);
    }

    @Override
    public int getNumberOfResolutions() {
        return this.m_resolutions.size();
    }

    @Override
    public List<Resolution> getResolutions() {
        return Collections.unmodifiableList(this.m_resolutions);
    }

    protected List<Issue> calculateUnresolvedIssues() {
        IssueList list = this.m_system.getCurrentModel().getIssueList(new IssueFilter((IStandardEnumeration[])new ResolutionMode[]{ResolutionMode.NONE}));
        ArrayList<Issue> issues = new ArrayList<Issue>(list.getIssues());
        issues.sort(ReportComparator.createIssueComparator());
        return Collections.unmodifiableList(issues);
    }

    @Override
    public void setTargetFile(TFile targetFile) {
        this.m_targetFile = targetFile;
    }

    @Override
    public TFile getTargetFile() {
        return this.m_targetFile;
    }

    @Override
    public String getTimestampString() {
        return Iso8601DateFormat.formatDateAndTime((Date)new Date(this.getTimestamp()));
    }

    @Override
    public List<Module> getModules() {
        return Collections.unmodifiableList(this.getSoftwareSystem().getUniqueChild(Workspace.class).getChildren(Module.class));
    }

    @Override
    public List<Module> getModulesSorted() {
        return Collections.unmodifiableList(this.getSoftwareSystem().getUniqueChild(Workspace.class).getChildren(Module.class).stream().sorted((m1, m2) -> m1.getName().compareToIgnoreCase(m2.getName())).collect(Collectors.toList()));
    }

    @Override
    public List<External> getExternal() {
        return Collections.unmodifiableList(this.getSoftwareSystem().getUniqueChild(Workspace.class).getChildren(External.class).stream().sorted((m1, m2) -> m1.getName().compareToIgnoreCase(m2.getName())).collect(Collectors.toList()));
    }

    public void setScriptRunnerConfiguration(ScriptRunnerConfiguration configuration) {
        this.m_scriptRunnerConfiguration = configuration;
    }

    public void setDuplicateCodeConfigurationEntries(List<String> entries) {
        assert (entries != null) : "Parameter 'entries' of method 'setDuplicateCodeConfigurationEntries' must not be null";
        this.m_duplicateCodeConfigurationEntries.clear();
        this.m_duplicateCodeConfigurationEntries.addAll(entries);
    }

    @Override
    public List<String> getDuplicateCodeConfigurationEntries() {
        return Collections.unmodifiableList(this.m_duplicateCodeConfigurationEntries);
    }

    public void setArchitectureCheckConfigurationEntries(List<String> entries) {
        assert (entries != null) : "Parameter 'entries' of method 'setArchitectureCheckConfigurationEntries' must not be null";
        this.m_architectureCheckConfigurationEntries.clear();
        this.m_architectureCheckConfigurationEntries.addAll(entries);
    }

    @Override
    public List<String> getArchitectureCheckConfigurationEntries() {
        return Collections.unmodifiableList(this.m_architectureCheckConfigurationEntries);
    }

    @Override
    public List<String> getScriptRunnerConfigurationEntries() {
        if (this.m_scriptRunnerConfiguration != null) {
            List<ScriptRunnerData> scriptRunnerData = this.m_scriptRunnerConfiguration.getScriptRunnerData();
            ArrayList<String> info = new ArrayList<String>(scriptRunnerData.size());
            for (ScriptRunnerData next : scriptRunnerData) {
                info.add(next.getIdentifyingScriptPath() + ":" + next.getRunConfigurationName());
            }
            return info;
        }
        return Collections.emptyList();
    }

    @Override
    public ScriptRunnerConfiguration getScriptRunnerConfiguration() {
        return this.m_scriptRunnerConfiguration;
    }

    @Override
    public List<ScriptRunnerData> getAutomatedScriptConfigurations() {
        if (this.m_scriptRunnerConfiguration == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_scriptRunnerConfiguration.getScriptRunnerData());
    }

    @Override
    public String getDate(Date date) {
        assert (date != null) : "Parameter 'date' of method 'getDate' must not be null";
        return Iso8601DateFormat.formatDateAndTime((Date)date);
    }

    @Override
    public int getNumberOfUnresolvedCycleGroups() {
        return this.getNumberOfElements(this.m_unresolvedCycleIssues);
    }

    private int getNumberOfElements(Map<IAnalyzerId, List<CycleGroupIssue>> issueMapOfList) {
        assert (issueMapOfList != null) : "call performCalculations() first!";
        return issueMapOfList.values().stream().mapToInt(issues -> issues.size()).sum();
    }

    @Override
    public String getElementOrFrom(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getElementOrFrom' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        if (issue instanceof NamedElementIssue) {
            return issue.getAffectedElement().getPresentationName(false);
        }
        if (issue instanceof DependencyIssue) {
            Dependency dependency = (Dependency)issue.getAffectedElement();
            return dependency.getUnderlyingFrom().getPresentationName(false);
        }
        assert (false) : "Unexpected class: " + issue.getClass().getName();
        return null;
    }

    @Override
    public String getTo(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getTo' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        if (issue instanceof NamedElementIssue) {
            return "n/a";
        }
        if (issue instanceof DependencyIssue) {
            Dependency dependency = (Dependency)issue.getAffectedElement();
            return dependency.getUnderlyingTo().getPresentationName(false);
        }
        assert (false) : "Unexpected class: " + issue.getClass().getName();
        return null;
    }

    @Override
    public LastScriptRunnerExecutionStatus getScriptRunnerStatus() {
        return this.m_lastScriptRunnerExecutionStatus;
    }

    public void addScriptRunnerStatus(LastScriptRunnerExecutionStatus status) {
        this.m_lastScriptRunnerExecutionStatus = status;
    }

    public void performCalculations() {
        assert (this.m_unresolvedIssues == null) : "Method performCalculations() must only be called once";
        this.m_calculatedCycleIssues = this.calculateCycleIssues();
        this.m_unresolvedCycleIssues = this.calculateUnresolvedCycleIssues();
        this.m_calculatedDuplicateIssues = this.calculateDuplicateIssues();
        this.m_unresolvedDuplicateIssues = this.calculateUnresolvedDuplicateIssues();
        this.m_unresolvedIssues = this.calculateUnresolvedIssues();
    }

    @Override
    public List<DuplicateCodeBlockIssue> getUnresolvedDuplicateIssues() {
        assert (this.m_unresolvedDuplicateIssues != null) : "call performCalculations() first!";
        return this.m_unresolvedDuplicateIssues;
    }

    @Override
    public List<DuplicateCodeBlockIssue> getDuplicateIssues() {
        assert (this.m_calculatedDuplicateIssues != null) : "call performCalculations() first!";
        return this.m_calculatedDuplicateIssues;
    }

    @Override
    public List<SonargraphFeature> getAvailableFeatures() {
        Collections.sort(this.m_availableFeatures, ReportComparator.createFeatureComparator());
        return Collections.unmodifiableList(this.m_availableFeatures);
    }

    @Override
    public List<SonargraphFeature> getUnavailableFeatures() {
        Collections.sort(this.m_unavailableFeatures, ReportComparator.createFeatureComparator());
        return Collections.unmodifiableList(this.m_unavailableFeatures);
    }

    public void addUnlicensedAnalyzer(IAnalyzerId id) {
        assert (id != null) : "Parameter 'id' of method 'addDisabledAnalyzer' must not be null";
        this.m_unlicensedAnalyzers.add(id);
    }

    public void addLicensedAnalyzer(IAnalyzerId id) {
        assert (id != null) : "Parameter 'id' of method 'addEnabledAnalyzer' must not be null";
        assert (!this.m_unlicensedAnalyzers.contains(id)) : "'" + id.getStandardName() + "' has already been added as disabled";
        this.m_licensedAnalyzers.add(id);
    }

    @Override
    public List<IAnalyzerId> getUnlicensedAnalyzers() {
        Collections.sort(this.m_unlicensedAnalyzers, ReportComparator.createAnalyzerComparator());
        return Collections.unmodifiableList(this.m_unlicensedAnalyzers);
    }

    @Override
    public List<IAnalyzerId> getLicensedAnalyzers() {
        Collections.sort(this.m_licensedAnalyzers, ReportComparator.createAnalyzerComparator());
        return Collections.unmodifiableList(this.m_licensedAnalyzers);
    }

    @Override
    public List<IAnalyzerId> getAnalyzers(boolean executed) {
        LinkedHashSet<IAnalyzerId> filteredAnalyzers;
        List inactiveAnalyzerPlugins = this.getAnalyzerPlugins().stream().filter(pair -> !((SonargraphPlugin)pair.getFirst()).isEnabled()).map(pair -> (IAnalyzerId)pair.getSecond()).filter(id -> id != null).collect(Collectors.toList());
        Set<Language> usedLanguages = this.m_system.getUsedLanguages();
        Predicate<IAnalyzerId> predicate = analyzer -> analyzer.getExecutionLevel().matchesOrIsLowerThan(this.m_analyzerExecutionLevel) && (analyzer.getLanguage() == null || usedLanguages.contains(analyzer.getLanguage()));
        if (!executed) {
            predicate = predicate.negate();
            filteredAnalyzers = new LinkedHashSet<IAnalyzerId>(this.m_licensedAnalyzers.stream().filter(predicate).collect(Collectors.toList()));
            filteredAnalyzers.addAll(this.m_unlicensedAnalyzers);
            filteredAnalyzers.addAll(inactiveAnalyzerPlugins);
        } else {
            filteredAnalyzers = (LinkedHashSet<IAnalyzerId>)((Object)this.m_licensedAnalyzers.stream().filter(predicate).collect(Collectors.toList()));
            filteredAnalyzers.removeAll(inactiveAnalyzerPlugins);
        }
        return new ArrayList<IAnalyzerId>(filteredAnalyzers);
    }

    public void addAnalyzerPlugin(SonargraphPlugin plugin, IAnalyzerId pluginAnalyzerId) {
        assert (plugin != null) : "Parameter 'plugin' of method 'addAnalyzerPlugin' must not be null";
        assert (!this.m_analyzerPlugins.stream().map(p -> (SonargraphPlugin)p.getFirst()).filter(p -> p == plugin).findFirst().isPresent()) : "Plugin '" + plugin.getId() + "' has already been added";
        this.m_analyzerPlugins.add((Pair<SonargraphPlugin, IAnalyzerId>)new Pair((Object)plugin, (Object)pluginAnalyzerId));
    }

    public void addModelPlugin(SonargraphPlugin plugin) {
        assert (plugin != null) : "Parameter 'plugin' of method 'addModelPlugin' must not be null";
        assert (!this.m_modelPlugins.contains(plugin)) : "Plugin '" + plugin.getId() + "' has already been added";
        this.m_modelPlugins.add(plugin);
    }

    @Override
    public List<Pair<SonargraphPlugin, IAnalyzerId>> getAnalyzerPlugins() {
        Collections.sort(this.m_analyzerPlugins, ReportComparator.createLicensedPluginComparator());
        return Collections.unmodifiableList(this.m_analyzerPlugins);
    }

    @Override
    public List<SonargraphPlugin> getModelPlugins() {
        Collections.sort(this.m_modelPlugins, ReportComparator.createPluginComparator());
        return Collections.unmodifiableList(this.m_modelPlugins);
    }

    @Override
    public List<IMetricThreshold> getThresholds() {
        return Collections.unmodifiableList(new ArrayList<IMetricThreshold>(this.m_thresholdToIssues.keySet()));
    }

    public void addThreshold(IMetricThreshold threshold) {
        assert (threshold != null) : "Parameter 'threshold' of method 'addThreshold' must not be null";
        if (!this.m_thresholdToIssues.containsKey(threshold)) {
            this.m_thresholdToIssues.put(threshold, new ArrayList(5));
        }
        IMetricDescriptor descriptor = threshold.getMetricDescriptor();
        this.addMetricIdAndLevel(descriptor.getMetricId(), descriptor.getLevel());
    }

    @Override
    public Map<IMetricThreshold, List<ThresholdViolationIssue>> getThresholdViolationIssues() {
        return Collections.unmodifiableMap(this.m_thresholdToIssues);
    }

    @Override
    public int getNumberOfThresholdViolations() {
        return this.m_thresholdToIssues.values().stream().mapToInt(list -> list.size()).sum();
    }

    @Override
    public IBasicReport.Focus getFocus() {
        return IBasicReport.Focus.COMPLETE_REPORT;
    }

    @Override
    public String getTitle() {
        return "System '" + this.m_system.getName() + "'";
    }

    @Override
    public String getElementName() {
        return this.m_system.getName();
    }

    @Override
    public int getNumberOfNamedElementIssues() {
        return this.m_namedElementIssues.size();
    }

    @Override
    public int getNumberOfThresholds() {
        return this.m_thresholdToIssues.keySet().size();
    }

    @Override
    public int getTotalNumberOfCycleIssues() {
        return this.m_calculatedCycleIssues.values().stream().mapToInt(list -> list.size()).sum();
    }

    @Override
    public List<IBasicReport> getModuleReports() {
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfUnresolvedIssues() {
        return this.getUnresolvedIssues().size();
    }

    @Override
    public AnalyzerExecutionLevel getAnalyzerExecutionLevel() {
        return this.m_analyzerExecutionLevel;
    }

    @Override
    public boolean isExecuted(AnalyzerExecutionLevel level) {
        return level.matchesOrIsLowerThan(this.m_analyzerExecutionLevel);
    }

    @Override
    public List<CycleAnalyzerConfiguration> getCycleGroupAnalyzerConfigurations() {
        return this.m_cycleAnalyzerConfigurations;
    }

    public void addCycleAnalyzerConfiguration(CycleAnalyzerConfiguration config) {
        assert (config != null) : "Parameter 'config' of method 'addCycleAnalyzerConfiguration' must not be null";
        this.m_cycleAnalyzerConfigurations.add(config);
    }

    public void addPluginConfiguration(SonargraphPlugin plugin, PluginConfigurationFile pluginConfiguration, List<Pair<SonargraphPluginAttribute, String>> attributesAndValues) {
        assert (plugin != null) : "Parameter 'plugin' of method 'addPluginConfiguration' must not be null";
        assert (pluginConfiguration != null) : "Parameter 'pluginConfiguration' of method 'addPluginConfiguration' must not be null";
        assert (attributesAndValues != null) : "Parameter 'attributesAndValues' of method 'addPluginConfiguration' must not be null";
        Pair<PluginConfigurationFile, List<Pair<SonargraphPluginAttribute, String>>> previous = this.m_pluginToConfigurationMap.put(plugin, (Pair<PluginConfigurationFile, List<Pair<SonargraphPluginAttribute, String>>>)new Pair((Object)pluginConfiguration, attributesAndValues));
        assert (previous == null) : "Configuration for plugin '" + plugin.getId() + "' has already been added";
    }

    @Override
    public Map<SonargraphPlugin, Pair<PluginConfigurationFile, List<Pair<SonargraphPluginAttribute, String>>>> getPluginConfigurations() {
        return this.m_pluginToConfigurationMap;
    }

    @Override
    public String getReportContextInfo() {
        return this.m_reportContextInfo;
    }

    @Override
    public List<StrictPair<ArchitectureFile, String>> getCheckedArchitectureFiles() {
        return this.m_checkedArchitectureAndHashPairs;
    }

    public void addCheckedArchitecture(ArchitectureFile next, String hash) {
        assert (next != null) : "Parameter 'next' of method 'addCheckedArchitecture' must not be null";
        assert (hash != null) : "Parameter 'hash' of method 'addCheckedArchitecture' must not be null";
        this.m_checkedArchitectureAndHashPairs.add((StrictPair<ArchitectureFile, String>)new StrictPair((Object)next, (Object)hash));
    }

    public void setBaseline(String baselinePath) {
        assert (baselinePath != null) : "Parameter 'baselinePath' of method 'setBaseline' must not be null";
        this.m_baselinePath = baselinePath;
    }

    @Override
    public String getBaseline() {
        return this.m_baselinePath;
    }

    public void setQualityGateCheckConfigurationEntries(List<String> identifyingPaths) {
        assert (identifyingPaths != null) : "Parameter 'identifyingPaths' of method 'setCheckedQualityGateFiles' must not be null";
        this.m_checkedQualityGateFiles = identifyingPaths;
    }

    @Override
    public List<String> getQualityGateCheckConfigurationEntries() {
        return this.m_checkedQualityGateFiles == null ? null : Collections.unmodifiableList(this.m_checkedQualityGateFiles);
    }

    @Override
    public boolean isQualityGateCheckActive() {
        return this.m_checkedQualityGateFiles != null && !this.m_checkedQualityGateFiles.isEmpty();
    }

    public void addQualityGateResult(QualityGate qualityGate, QualityGateResult result) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'addQualityGateResult' must not be null";
        this.m_qualityGateToResultMap.put(qualityGate, result);
    }

    public void setIssuesAffectingQualityGates(Set<Element> issuesAffectingQualityGateConditions) {
        assert (issuesAffectingQualityGateConditions != null) : "Parameter 'issues' of method 'setIssuesAffectingQualityGates' must not be null";
        this.m_issuesAffectingQualityGates = issuesAffectingQualityGateConditions;
    }

    @Override
    public boolean issueAffectingQualityGates(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'issueAffectingQualityGates' must not be null";
        return this.m_issuesAffectingQualityGates.contains(issue);
    }

    public void setMetricValuesAffectingQualityGates(Set<Element> metricValuesAffectingQualityGates) {
        assert (metricValuesAffectingQualityGates != null) : "Parameter 'metricValuesAffectingQualityGates' of method 'setMetricValuesAffectingQualityGates' must not be null";
        this.m_metricValuesAffectingQualityGates = metricValuesAffectingQualityGates;
    }

    @Override
    public boolean metricValueAffectingQualityGates(IMetricValue value) {
        MetricValue element = (MetricValue)value;
        return this.m_metricValuesAffectingQualityGates.contains(element);
    }

    @Override
    public Map<QualityGate, QualityGateResult> getQualityGateToResultMap() {
        return this.m_qualityGateToResultMap;
    }

    @Override
    public long getNumberOfFailedQualityGates() {
        return this.m_qualityGateToResultMap.values().stream().filter(result -> result != null && result.getResultStatus() == QualityGateResultStatus.FAILED).count();
    }

    public void setIssueRankings(List<IssueRank> rankings) {
        assert (rankings != null) : "Parameter 'rankings' of method 'setIssueRankings' must not be null";
        this.m_issueRankings = rankings;
    }

    @Override
    public List<IssueRank> getIssueRankings() {
        return this.m_issueRankings;
    }
}

