/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.refactoring.ICollisionValidator;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringData;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.List;
import java.util.Map;

public final class MoveRenameRefactoringData
extends MoveRefactoringData {
    private final ITextValidator m_nameValidator;
    private final String m_originalName;
    private String m_targetName;

    public MoveRenameRefactoringData(MoveRenameRefactoringInfo info, RootDirectoryPath targetRootDirectory, String moveToParentName, ICollisionValidator collisionValidator, String parentKind, String parentImageResourceName, String elementImageResourceName, Map<Module, List<RootDirectoryPath>> availableTargetRootDirectories, List<String> availableMoveToParentNames, ITextValidator moveToParentNameValidator, ITextValidator nameValidator, String name) {
        super(info, targetRootDirectory, moveToParentName, collisionValidator, parentKind, parentImageResourceName, elementImageResourceName, availableTargetRootDirectories, availableMoveToParentNames, moveToParentNameValidator);
        assert (nameValidator != null) : "Parameter 'nameValidator' of method 'MoveRenameRefactoringData' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'MoveRenameRefactoringData' must not be empty";
        this.m_nameValidator = nameValidator;
        this.m_originalName = name;
        this.m_targetName = name;
    }

    @Override
    public ITextValidator getTargetNameValidator() {
        return this.m_nameValidator;
    }

    @Override
    public ValidationResult setTargetName(String targetName) {
        this.m_targetName = targetName;
        return this.validateCollision();
    }

    @Override
    public String getTargetName() {
        return this.m_targetName;
    }

    @Override
    protected boolean useTargetNameForCollisionCheck() {
        return true;
    }

    @Override
    public boolean hasBeenModified() {
        return super.hasBeenModified() || !this.m_originalName.equals(this.m_targetName);
    }

    @Override
    public boolean hasValidData() {
        return super.hasValidData() && this.m_targetName != null && this.m_nameValidator.isValid(this.m_originalName, this.m_targetName).isSuccess();
    }

    @Override
    public RefactoringType getEffectiveRefactoringType() {
        if (!this.hasBeenModified()) {
            return RefactoringType.NONE;
        }
        if (super.hasBeenModified() && !this.m_originalName.equals(this.m_targetName)) {
            return RefactoringType.MOVE_RENAME;
        }
        if (super.hasBeenModified()) {
            return RefactoringType.MOVE;
        }
        return RefactoringType.RENAME;
    }
}

